;-------------------------------------------------------------------------------
pro jinmi
;
common StarBase,StarTable,Notes
;
status=dc_read_fixed('InputParameters-VLTI-1250nm-128m.dat',/col, $
	il,format='(a151)',ignore=['!'])
;
status=dc_read_fixed('calibrators-VLTI-claret-2220nm-140m.dat',/col, $
        cl,format='(a109)',ignore=['!'])
;
ni=n_elements(il)
nc=n_elements(cl)
;
hr=fix(strmid(il,0,4))
get_startable,'BSC'+string(hr,format='(i4.4)')
;
startable.vsini=float(strmid(il,52,3))
;
startable.omega=float(strmid(il,63,4))
; index=where(strpos(il,'w=') ge 0)
; startable(index).omega=float(strmid(il(index),146,5))
;
; startable.tilt=float(strmid(il,68,5))
; index=where(strpos(il,'ZAMS') ge 0)
; startable(index).tilt=90
startable.tilt=90
;
startable.teff=float(strmid(il,86,7))
logg_stars
startable.mass=float(strmid(il,102,4))
startable.diameter=float(strmid(il,117,4))
startable.model='LD'
startable.px=float(strmid(il,57,5))
;
l=10^(findgen(100)*0.015+2.6)
for i=0,ni-1 do begin
	status=limbgrid(startable(i).teff,startable(i).logg, $
		lambda,limbdu,fluxes)
	startable(i).sed=spline(lambda,fluxes,l)
	startable(i).ldc=spline(lambda,limbdu,l)
	startable(i).wvl=l*1e-9
endfor
;
put_oitarget,'jinmi.fits'
;
end
