pro extract_vis2data_fast, file=file, oivis2=oivis2_input, $
 oiwavelength=oiwavelength_input, oitarget=oitarget_input,vis2data  ,$
 status=status

;+
; NAME:
;     extract_uvdata
; PURPOSE:
;     To extract uvdata into 'usuable' IDL variables for plotting,
;     inspecting data, etc.  Can either be used to read directly from
;     FITS file or by passing the required OITABLES. Will also allow 
;     selection parameters
;
; CALLING SEQUENCE (Examples):
;     extract_vis2data, vis2data, file=fits_file, $
;             eff_wave =[1.8,2.3], target_id =[1,2]
;           or
;     extract_vis2data, vis2data, oivis2= oivis2table,$
;             oiwavelength=oiwavetable, oitarget=oitargettable,$
;              insname=['IOTA_IONIC3']
;
; INPUTS:
;
;   KEYWORDS:

;   One must pass EITHER 
;     FILE      - Name of fits file to read. Must be in
;
;            or All
;   OIWAVELENGTH Contains information on the observing bandpasses.
;      OIVIS2    Contains visibility-squared measurements.
;      OITARGET  Contains information on the target names
;
;    -
;
; OPTIONAL INPUTS:
;
;     Various keywords can be used to select subsets of the data that
;     pass certain selection criteria.  This section will be expanded
;     and new capabilities are added.
;
;     /STATUS    Print out status messages as data is being Extracted
;
; OUTPUTS:
;
;      VIS2DATA  A structure which contains in a simple format all the
;                requested data.   Does not use pointers and so all
;                data can be easily searched and plotted in IDL.
;                See define_vis2data.pro for detailed description of
;                this structure
;
; RESTRICTIONS:
;      None.
;
; PROCEDURE:
;      Call from command line or in a program.
;
;
;      The Data Exchange Standard for Optical (Visible/IR) Interferometry
;      is being maintained by the IAU Working group on Optical Interferometry
;      and the current version of the standard can be found at :
;            http://www.mrao.cam.ac.uk/~jsy1001/exchange/
;
; EXAMPLE:


;
; PROCEDURES USED:
;	This routine is part of the IDL Optical Interferometry (IOI) Library
;	 (more information at www.astro.lsa.umich.edu/~monnier).
;       The routines of the IOI Library generically 
;       require an up-to-date Astrolib library in order to read and write binary
;       FITS tables, among other things. The IDL Astronomy User's Library can
;       be found at http://idlastro.gsfc.nasa.gov/homepage.html.
;	
;
; MODIFICATION HISTORY:
;     v0.0 2003Jul04    J.D. Monnier    Initiated
;     v0.1 2005May30    J.D. Monnier	Added target names.
;     v0.2 2006Oct22    J.D. Monnier	Added sfu
;     v0.3 2009Mar22    J.D. Monnier    Added, ra, dec, equi
;	   2015Aug12    JDM		Sped up by avoiding concat_tables
;
;     To do: A.  Add Revision Checking (once multiple revisions exist)  
;	     B.  Add /gui or /interactive options to do fancy
;                selections.
;            C.  Better options for SORTING by TIME, baseline, etc.
;            D.  Better error checking
;  *** Please write monnier@umich.edu with bug reports. ***
;-

if (keyword_set(file) eq 1) then begin
  read_oidata, file, oiarray,oitarget,oiwavelength,oivis,oivis2,oit3
endif else begin
  oiwavelength = oiwavelength_input
  oivis2 =oivis2_input
  oitarget=oitarget_input
endelse

; Add error checking.
if n_elements(oivis2) eq 0 then begin
  print,'NO DATA'
  vis2data=-1
  return
endif


; First approach [maybe too slow and memory hog for big data sets!]
;    make big long array.
;    apply cuts at the end using a WHERE statements.
;

lastarrname = ' '
;init
define_vis2data,vis2data_unit
insnames = strtrim( oiwavelength.insname,2)
vis2_insnames =strtrim(oivis2.insname,2)

;——
ndata=0LL
for i=long64(0),n_elements(oivis2)-1LL do begin
  oiwave_index =  (where(insnames eq vis2_insnames(i)))(0)
   nwave = long64(oiwavelength(oiwave_index).nwave)
 ndata=ndata+nwave
endfor

vis2data = replicate(vis2data_unit,ndata)
i1=-1



;—
for i=0,n_elements(oivis2)-1 do begin
  oiwave_index =  (where(insnames eq vis2_insnames(i)))(0)
   nwave = oiwavelength(oiwave_index).nwave
       ; Not supposed to ever crash in the above line since
       ; oidata standard requires wavelength tables for each insnames

 i0=i1+1
 i1=i0+long64(nwave)-1LL

if (keyword_set(status) eq 1) then begin
   if (oivis2(i).arrname ne lastarrname) then begin
       pe= strtrim(string(fix(100.*i/n_elements(oivis2))),2)
       print, pe+'% Complete:  Beginning extraction of ARRNAME : ',oivis2(i).arrname 
       lastarrname = oivis2(i).arrname
   endif
endif

   
   vis2data(i0:i1).oi_revn = oivis2(i).oi_revn
   vis2data(i0:i1).date_obs= oivis2(i).date_obs
   vis2data(i0:i1).arrname = strtrim(oivis2(i).arrname,2)
   vis2data(i0:i1).insname = strtrim(oivis2(i).insname,2)
   vis2data(i0:i1).eff_wave   = *oiwavelength(oiwave_index).eff_wave
   vis2data(i0:i1).eff_band   = *oiwavelength(oiwave_index).eff_band
   vis2data(i0:i1).wave_id    = indgen(nwave)
   vis2data(i0:i1).target_id  = oivis2(i).target_id
   tin=where( oitarget.target_id eq oivis2(i).target_id,ct ) ; NO ERRORS!!
    if ct eq 0 then begin
        print,' Target ID not in OITARGET table!! 
	stop
        return
    endif
   vis2data(i0:i1).target     = oitarget(tin).target
   vis2data(i0:i1).ra 	  = oitarget(tin).raep0
   vis2data(i0:i1).dec	  = oitarget(tin).decep0
   vis2data(i0:i1).equinox    = oitarget(tin).equinox
   vis2data(i0:i1).time       = oivis2(i).time
   vis2data(i0:i1).mjd        = oivis2(i).mjd
   vis2data(i0:i1).int_time   = oivis2(i).int_time
   vis2data(i0:i1).vis2data      =*oivis2(i).vis2data
   vis2data(i0:i1).vis2err       =*oivis2(i).vis2err
   vis2data(i0:i1).ucoord     = oivis2(i).ucoord
   vis2data(i0:i1).vcoord     = oivis2(i).vcoord
   vis2data(i0:i1).sta_index  = oivis2(i).sta_index
   vis2data(i0:i1).flag          =*oivis2(i).flag
  

   
endfor

; Geometry
   vis2data.u = vis2data.ucoord/vis2data.eff_wave
   vis2data.v = vis2data.vcoord/vis2data.eff_wave
   ri2at, vis2data.vcoord, vis2data.ucoord, amp, theta ; not a bug (angle E of No)
   vis2data.baseline = amp
   vis2data.pa       = theta
   vis2data.sfu = vis2data.baseline/vis2data.eff_wave

end


