pro stellarparam, starname, rstar, lstar, tstar, dist

; Written 2/99 by

; Marc J. Kuchner
; Harvard-Smithsonian Center for Astrophysics
; Mail Stop #20
; 60 Garden St. 
; Cambridge, MA 02138
; (617)496-4773

; revised 2/01

; These stellar parameters are not guaranteed to be
; right!
; When in doubt...use your own tstar, lstar, rstar and dist
; The luminosity, lstar, is especially suspect.

; phi is interferometrically determined angular diam. in mas
; if phi=0 then there's no such data

case 1 of
starname eq 'Alpha_Centauri_B' or starname eq 'Alf_Cen_B' :begin
rstar=0.87
dist=1.34
lstar=0.45
tstar=5325.0 ; A&A 328, 261
phi=0
end

starname eq 'Epsilon_Eridani' or starname eq 'Eps_Eri' :begin
rstar=0.98
lstar=0.30
dist=3.218 ; Hipparcos
tstar=5156.0 ; Bell, R. A., Gustafsson, B. 1989, MNRAS, 236, 653
phi=0
end

starname eq 'Alpha_Centauri_A' or starname eq 'Alf_Cen_A': begin
rstar=1.23
dist=1.34
lstar=1.6
tstar=5770.0  ; A&A 328, 261
phi=0
end

starname eq 'Tau_Ceti' or starname eq 'Tau_Cet' :begin
tstar=5570.0
lstar=0.66
rstar=0.89
dist = 3.647 ; Hipparcos
phi=0
end

starname eq 'Procyon' or starname eq 'Alf_CMi' : begin
lstar=7.65
dist=3.497  ; Hipparcos
tstar=6501.0 ; di Benedetto, G. P. 1998, A&A, 339, 858
rstar=1.20 ; Allen F5V
phi=5.51 ; Mozurkewich et al. 1991
end

starname eq 'Sirius' or starname eq 'Alf_CMa' :begin
lstar=23.5
dist=2.637 ; Hipparcos
tstar=9945.0  ; di Benedetto, G. P. 1998, A&A, 339, 858
rstar=1.8
phi=5.92 ; Davis & Tango 1986, Nature, 323, 234
end

starname eq 'Altair' :begin
rstar=1.65
dist=5.143  ; Hipparcos
tstar=8000.0
lstar=10.5
end

starname eq 'Vega' : begin
tstar=9520.0
;lstar= 54.0
lstar= 60.0  ; Backman, D.E. & Paresce, F. PP III
rstar=2.5
dist=7.756 ; Hipparcos
phi=3.24 ; Code et al. 1976, ApJ, 203, 417
end

starname eq 'Fomalhaut' or starname eq 'Alf_PsA' : begin
tstar=8800.0 ; Backman, D.E. & Paresce, F. PP III
lstar=13.0 ; Backman, D.E. & Paresce, F. PP III
dist=7.688 ; Hipparcos
phi=2.10  ; Code et al. 1976, ApJ, 203, 417
end

starname eq 'HR_4796' or starname eq 'HR4796' :begin
rstar=1.45  ; based on lstar
dist=67.07  ; Hipparcos
tstar=9500.0
lstar=18.1 ; Koerner, Ressler, Werner and Backman
; The big ring has an inclination of 73.1 degrees
; position angle 26.8 degrees see also Schneider et al. 1999
phi=0
end

starname eq 'Fstar' :begin
rstar=1.2  ; F5V Allen
dist=10.0  
tstar=6580.0 ; F5V  Allen
lstar=2.5 
phi=0
end

starname eq 'Kstar' :begin
rstar=0.7 ; K7V  interpolated from Allen
dist=10.0 
tstar=3870.0 ; K7V interpolated from Allen
lstar=0.1
phi=0
end

starname eq 'Sun' :begin
; The sun
rstar=1.0
dist=10.0
tstar=5770.0
lstar=1.0
phi=0
end

else: begin
print, "I don't know that Star"
return
end

endcase

print, ' '
print, 'Star: ', starname

if phi ne 0 then begin
print, 'Interferometrically determined angular diameter (mas):', phi
rsunau=6.96d10/1.49597d13
iradius=(phi/2000.0)*dist/rsunau
print, 'Combined with Hipparcos parallax gives radius (solar units):', iradius
rstar=iradius
endif

end
