pro temperaturecalc, lstar, tstar, lambda0microns, rau, t

; program to calculate the equilibrium
; temperature (t) of
; dust grains of arbitrary size, in
; microns (lambda0microns)
; as a function of the distance from
; the star in AU, (rau)


p=1 ; absorbtion
q=1 ; emission

; calculate stellar radius from effective temperature 
; and luminosity
; rstar^2*(tstar/5770.0)^4.0=lstar
rstar=(lstar^0.5)*(tstar/5770.0)^(-2.0)  ; solar units
; radius of the star in cm
rstarcm=rstar*6.9599d10

; effective dust size, in cm
lambda0=lambda0microns*1e-4


; tol is the fractional error in the final temperature
 tol=0.001
;****************************************
; fundamental constants
kb=1.38066d-16
c=2.9979d10
h=6.62608d-27
; ***************************************

; lambda ranges from 1d-10 to 1d+4 cm
; with 10 steps per log interval

lambda=10.0^((findgen(142.0)/10.0)-10) ; cgs
nu = c/lambda  ; cgs
deltanu=abs(nu-shift(nu,-1))
deltanu(141)=0.0
nu(141)=0.0

sz=size(rau)
raulen=sz(1)
t=fltarr(raulen)

for i=0,raulen-1 do begin

; distance from the star in cm
rcm=rau(i)*1.495979d13

; guess that the grain is at blackbody temperature 
tgrain=278.0

; calculate absorbed energy

;Calculate Planck spectrum Bnu (erg s^-1 cm^-2 ster^-1 Hz^-1)
  xb=h*nu/(kb*tstar)
  bnu=xb^3.0/(exp(xb)-1.0)
  bnu=bnu*2.0*((kb*tstar)^3.0)/((c*h)^2.0)
  bnu(141)=0.0
; efficiency of absorbtion

absorb=(lambda0/lambda)^p < 1.0 

eabsorb=((rstarcm/rcm)^2.0)*total(bnu*deltanu*absorb)

ok=0
bad=0
tstep=20.0
while (ok eq 0) do begin
; calculate emitted energy
 
;Calculate Planck spectrum Bnu (erg s^-1 cm^-2 ster^-1 Hz^-1)
  xb=h*nu/(kb*tgrain)
  bnu=xb^3.0/(exp(xb)-1.0)
  bnu=bnu*2.0*((kb*tgrain)^3.0)/((c*h)^2.0)
  bnu(141)=0.0
 
; efficiency of emission
emit=(lambda0/lambda)^q < 1.0 
eemit=4.0*total(bnu*deltanu*emit)

match=eemit/eabsorb

oldbad=bad

; If the guess is too low, increase the temperature
if match gt 1.0+tol then begin
bad=1
tgrain=tgrain-tstep
endif

; If the guess is too high, decrease the temperature
if match lt 1.0-tol then begin
bad=-1
tgrain=tgrain+tstep
; quit if the grain is hot enough to melt and still not hot
; enough to satisfy the equation
if tgrain gt 10000.0 then begin
  tgrain=-1.0
  ok=1
endif
endif

; quit iterating when we are close enough
if match le 1.0+tol and match ge 1.0-tol then ok=1

; if we overshot, reduce the step size
if oldbad ne bad then tstep=tstep/2.0

endwhile

t(i)=tgrain

endfor


end
