pro xfullzodimodel, lstar, tstar, rstar, num, inu, stepau, inc, pos, lambda,$
  radin, radout, pfunc500, albedo=albedo, ring, blob, earthlong, bands, nofan=nofan, offsetx, offsety, offsetz, iras=iras,$
  scatterflag=scatterflag, useralpha=useralpha, userdelta=userdelta, scube=scube, radring=radring, userdustsize=userdustsize


; Written 2/99 by

; Marc J. Kuchner
; Harvard-Smithsonian Center for Astrophysics
; Mail Stop #20
; 60 Garden St. 
; Cambridge, MA 02138
; (617)496-4773

; revised 2/01

; the x is for expansion
; this code is for making big big images

; lstar luminosity of the star in solar luminosities
; num is the number of steps in radius to take

; cloud will be an 2*num by 2*num by 2*num array
; containing the emissivity of the dust as a function of wavelength

; stepau is the stepsize in au

; radin and radout are the is the disk inner and outer radii in AU

; set iras to use IRAS model


;*****************************************************************
; fundamental constants
pi=3.1415926536
pi2=pi*2.0
kb=1.38066d-16
cc=2.9979d10
hp=6.62608d-27
sigma=5.6705d-5
l10=2.30259

; Model Gene used
;alpha=1.39
;beta=3.26
;gamma=1.02
;T0=286.0
;delta=0.42
;n0=1.14e-7

; DIRBE
; Smooth Cloud
alpha = 1.34
beta = 4.14
gamma = 0.942
delta=0.467
T0=286.0
mu=0.189
;<n sigma> in AU^-1 measured at the Earth
n0=1.13d-7
al=0.36  ; so Hong phase function agrees with DIRBE at 90 degrees 
; this is a fit to the DIRBE emissivities
em=(280.0/(280.0+lambda))+((2.2-0.45*lambda) > 0)
;deltas in AU
;x0=0.119
;y0=0.00548
;z0=0.00215

if keyword_set(iras) then begin
; Old J Good
alpha=1.803
beta=4.973
gamma=1.265
T0=266.20
delta=0.359
n0=2.1527e-7  ;   =1.439e-20*1.495979e13
endif

if keyword_set(useralpha) then alpha=useralpha
if keyword_set(userdelta) then delta=userdelta
if keyword_set(albedo) then al=albedo
if not keyword_set(scube) then scube=0

; ***************************************************************
;  Solar Ring
nsr=1.83d-8
rsr=1.03
if keyword_set(radring) then rsr=radring
;sigrsr=0.025
sigrsr=0.025*rsr/1.03  ; make width of ring scale with the radius
sigrsr2=2.0*sigrsr*sigrsr
;sigzsr=0.054
sigzsr=0.054*rsr/1.03  ; make the height of the ring scale with the radius
;irb=0.49
;omegarb=22.3
; Trailing Blob
ntb=1.9d-8
;rtb=1.06
rtb=1.06*rsr/1.03  ; make the location of the blob scale with the ring
;sigrtb=0.10
sigrtb=0.10*rsr/1.03  ; make width of blob scale with the ring
sigrtb2=2.0*sigrtb*sigrtb
;sigztb=0.091
sigztb=0.091*rsr/1.03  ; make height of the blob scale with the ring
heltb=-10.0*pi/180.0  ; converted to radians
sigheltb=12.1*pi/180.0  ; converted to radians
sigheltb2=sigheltb*sigheltb

;***************************************************************
; Dust bands
nb1=5.59e-10
delb1=8.78*pi/180.0
vb1=0.10
pb1=4.0
rcut1=1.5
nb2=1.99e-9
delb2=1.99*pi/180.0
vb2=0.90
pb2=4.0
rcut2=0.94
nb3=1.44e-10
delb3=15.0*pi/180.0
vb3=0.05
pb3=4.0
rcut3=1.5
rcut120=rcut1^20.0
rcut220=rcut2^20.0
rcut320=rcut3^20.0
delb16=delb1^6.0
delb26=delb2^6.0
delb36=delb3^6.0
delb14=delb1^4.0
delb24=delb2^4.0
delb34=delb3^4.0

;************************************************************
; More Definitions

num2=num*2
gum=num-1

;l0 is the wavelength, in cm
l0= lambda*1e-4

; some math we can do now to make the Bnu calculation faster 
chk=2.0*(kb^3.0)/((cc*hp)^2.0)
hnuok=hp*(cc/l0)/kb

; radsolar is the radius of the sum in cm
radsolar=6.96d10

; rstarcm is the radius of the star in cm
rstarcm=radsolar*rstar

; rstarau is the radius of the star in AU
rstarau=rstarcm/1.49597d13

deltax=offsetx/stepau
deltay=offsety/stepau
deltaz=offsetz/stepau

; make sure earthlong is between 0 and 2*pi
earthlong=(earthlong*pi/180.0) mod pi2
if earthlong lt 0 then earthlong = earthlong + pi2

; Calculate Bnu for the star
xb=hnuok/tstar
bnus=(tstar^3.0)*chk*xb^3.0/(exp(xb)-1.0)
starfactor=pi * bnus * rstarau*rstarau/(stepau*stepau)

;**********************************************************
; Make some geometrical calulations 
print, 'Doing some geometry'

c0=cos(pos*pi/180.0 )
s0=sin(pos*pi/180.0 )
c1=cos(inc*pi/180.0)
s1=sin(inc*pi/180.0)
c2=cos(0.5*pi + earthlong)
s2=sin(0.5*pi + earthlong)

inu=fltarr(num2, num2)

; Do the spherically symmetric part of the physics.
print, 'Calculating spherically symmetric factors'

; make a vector that contains bnu as a function of radius,
; sampled every 1/5 of a radial step
raus=findgen(num*9.0)*stepau/5.0 > 1e-8 ; 9 is roughly 5 times sqrt(2)

if keyword_set(userdustsize) then begin
print, 'Calculating the equilibrium temperature of the dust'
temperaturecalc, lstar, tstar, userdustsize, raus, t
endif else begin
t = T0 * raus^(-delta)* (lstar^(delta/2.0))
endelse
;Calculate Planck spectrum Bnu (erg s^-1 cm^-2 ster^-1 Hz^-1)
bnu=hnuok/t
bnu=(t^3.0)*chk*bnu^3.0/(exp(bnu)-1.0)
  t=0
 
; compute a spherically symmetric factor from the number density
spherefactor=raus^(-alpha) 
if keyword_set(nofan) then spherefactor=spherefactor*0.0

; Fill arrays with y and z values
yarray=fltarr(num2, num2, /nozero) & zarray=yarray
for i=0, num2-1 do begin
yarray(i,*)=i+0.5-num
zarray(*,i)=i+0.5-num
endfor

; do some math with these matrices for the coordinate transformation
trans1=-(s0*c1*c2 + c0*s2)*yarray + s1*c2*zarray + c2*deltax -s2* deltay
trans2=-(s0*c1*s2 - c0*c2)*yarray + s1*s2*zarray + s2*deltax +c2*deltay
trans3=s0*s1*yarray + c1*zarray+deltaz

print, 'Calculating azimuthally symmetric factors.'
zetas=findgen(1001)/1000.0   ; zeta goes from 0 to 1 in steps of 0.001 
if keyword_set(iras) then begin
azimuthterms=exp(-beta*(zetas^gamma))  ; use for IRAS
endif else begin
; DIRBE
g= abs(zetas)-(mu/2.0)
smallz=where(zetas lt mu)
g(smallz)=(zetas(smallz)^2.0)/(2.0*mu) 
azimuthterms=exp(-beta*(g^gamma))  
endelse

g=0 & smallz=0 & zetas=0   ; save memory

print, 'Countdown'
;*****************************************************************


for i=0, num2-1 do begin
count=fix(((num2-1)-i)/10.0)
if ((num2-1)-i)/10.0 eq count then print, -count
x=i+0.5-num

; do some serious geometry
; start calculating the cosine of the scattering angle
costheta=zarray*zarray   ; not really costheta yet
; rsteps will be the distance to the star in steps!
rsteps=costheta+x*x+yarray*yarray > 1e-8   ; actually this is rsteps squared
; grab the local starlight while we have rsteps squared
starlight=starfactor/rsteps  ; like I said, it's really rsteps^2
rsteps=sqrt(rsteps) > 1e-8    ;  ah there we go...now it's rsteps
costheta=zarray/rsteps < 0.999999 ; now we have the cosine of scattering angle

; Here's the coordinate transformation.
; It's a translation and three rotations.
; I'm writing it out in full in the comments here,
; but in the implementation below, some of the algebra has been done.
; x0=x
; y0=yarray
; z0=zarray
;
; c0=cos(pos*pi/180.0 )
; s0=sin(pos*pi/180.0 )
; x1=c0*x0 - s0*y0
; y1=s0*x0 + c0*y0
; z1=z0
;
; c1=cos(inc*pi/180.0)
; s1=sin(inc*pi/180.0)
; x2=c1*x1 + s1*z1+deltax
; y2=y1+deltay
; z2=-s1*x1 + c1*z1+deltaz
;
; c2=cos(0.5*pi + earthlong)
; s2=sin(0.5*pi + earthlong)
; x3=c2*x2 - s2*y2
; y3=s2*x2 + c2*y2
; z3=z2

; substituting in we get
; x3=c2*(c1*x1 + s1*z1+deltax) - s2*(y1+deltay)
; y3=s2*(c1*x1 + s1*z1+deltax) + c2*(y1+deltay)
; z3=-s1*x1 + c1*z1+deltaz

; x3=c2*(c1*(c0*x0 - s0*y0) + s1*z0+deltax) - s2*((s0*x0 + c0*y0)+deltay)
; y3=s2*(c1*(c0*x0 - s0*y0) + s1*z0+deltax) + c2*((s0*x0 + c0*y0)+deltay)
; z3=-s1*(c0*x0 - s0*y0) + c1*z0+deltaz

; finally some expressions we can use
; the sines and cosines are done at the beginning of the program
;x3=(c0*c1*c2 - s0*s2)*x - (s0*c1*c2 + c0*s2)*yarray + s1*c2*zarray + c2*deltax -s2* deltay
;y3=(c0*c1*s2 + s0*c2)*x - (s0*c1*s2 - c0*c2)*yarray + s1*s2*zarray + s2*deltax +c2*deltay
;z3=-c0*s1*x + s0*s1*yarray + c1*zarray+deltaz
; and we already calculated other parts of this already

x3=(c0*c1*c2 - s0*s2)*x + trans1
y3=(c0*c1*s2 + s0*c2)*x + trans2
z3=-c0*s1*x + trans3

z3=abs(z3)
rstepst=sqrt(x3*x3+y3*y3+z3*z3)
zeta=abs(z3/rstepst)

raut=stepau*rstepst  ; in units of AU
if ring ne 0 or bands ne 0 then begin
zaut=stepau*z3 ; in units of AU
endif

; make an array to put the numberdensity of the ring, wake + bands in
nd=zarray*0.0  

if ring ne 0 then begin
; Add the Earth Ring
nd=nd+ring*nsr*exp(-(((raut-rsr)^2.0)/(sigrsr2) + zaut/sigzsr ))
endif

if blob ne 0 then begin
; Add the Earth Blob
; no inclination or delta
; We're going to need this angle
deltahel=atan(y3,x3)
dhel=heltb-deltahel
places=where(dhel gt pi)
if places(0) ne -1 then dhel(places)=dhel(places) - pi2
nd=nd+blob*ntb*exp(-(((raut-rtb)^2.0)/(sigrtb2)+zaut/sigztb+(dhel*dhel/(2.0*sigheltb2)) ))
endif

; Add the dust bands
if bands ne 0 then begin
;print, 'Adding the Dust Bands'
zau6=zaut^6.0
zau4=zaut^4.0
rau20=raut^20.0
nd=nd+3.0*bands*nb1*exp(-(zau6/delb16))*(vb1+(zau4/delb14))*(1.0-exp(-(rau20/rcut120)))
nd=nd+3.0*bands*nb2*exp(-(zau6/delb26))*(vb2+(zau4/delb24))*(1.0-exp(-(rau20/rcut220)))
nd=nd+3.0*bands*nb3*exp(-(zau6/delb36))*(vb3+(zau4/delb34))*(1.0-exp(-(rau20/rcut320)))
endif

if scatterflag eq 1 then begin
; compute scattered light
; put it all together
cloud=(spherefactor(rstepst*5.0)*azimuthterms(zeta*1000.0)*n0+nd)*(em*bnu(rsteps*5.0) + al*starlight*pfunc500(costheta*500.0))

endif else begin
; no scattered light
cloud=(spherefactor(rstepst*5.0)*azimuthterms(zeta*1000.0)*n0+nd)*(em*bnu(rsteps*5.0))
endelse

; get rid of dust interior to radin and exterior to radout
places=where(raut lt radin)
if places(0) ne -1 then cloud(places)=0.0
places=where(raut gt radout)
if places(0) ne -1 then cloud(places)=0.0

; clear out center of cube for iteration, if necessary
if scube ne 0 and i gt gum-scube and i lt num+scube then begin
gscube=scube-1
cloud(gum-gscube:num+gscube, gum-gscube:num+gscube)=0.0
endif

; Now integrate the emission along lines of sight
inu(i,*)=stepau*total(cloud,2) 

endfor

;  We're done.  Go return the answer to zodipic.

end
