pro xscatteringzodimodel, lstar, tstar, rstar, num, inu, stepau, inc, pos, lambda, radin, radout, pfunc500, albedo=albedo, iras=iras, scatterflag=scatterflag, useralpha=useralpha, userdelta=userdelta, scube=scube, userdustsize=userdustsize

; NOTE THAT THIS MODEL GIVES THE WRONG ANSWERS IF
; YOU USE BOTH SCATTERING AND POSITION ANGLE!!

; lstar luminosity of the star in solar luminosities
; num is the number of steps in radius to take

; cloud will be an 2num-1 by 2num-1 by 2num-1 array
; containing the emissivity of the dust as a function of wavelength

; stepau is the stepsize in au

; radin and radout are the is the disk inner and outer radii in AU

; set iras to use IRAS model

; Written 2/99 by

; Marc J. Kuchner
; Harvard-Smithsonian Center for Astrophysics
; Mail Stop #20
; 60 Garden St. 
; Cambridge, MA 02138
; (617)496-4773

; revised 2/01


;*****************************************************************
; fundamental constants
pi=3.141592
kb=1.38066d-16
cc=2.9979d10
hp=6.62608d-27
sigma=5.6705d-5
l10=2.30259

; Model Gene used
;alpha=1.39
;beta=3.26
;gamma=1.02
;T0=286.0
;delta=0.42
;n0=1.14e-7

;COBE
; Smooth Cloud
alpha = 1.34
beta = 4.14
gamma = 0.942
delta=0.467
T0=286.0
mu=0.189
;<n sigma> in AU^-1 measured at the Earth
n0=1.13d-7
al=0.36  ; so Hong phase function agrees with DIRBE at 90 degrees 
; this is a fit to the DIRBE emissivities
em=(280.0/(280.0+lambda))+((2.2-0.45*lambda) > 0)
;offsets in AU
;x0=0.119
;y0=0.00548
;z0=0.00215

if keyword_set(iras) then begin
; Old J Good
alpha=1.803
beta=4.973
gamma=1.265
T0=266.20
delta=0.359
n0=2.1527e-7  ;   =1.439e-20*1.495979e13
endif

if keyword_set(useralpha) then alpha=useralpha
if keyword_set(userdelta) then delta=userdelta
if not keyword_set(scube) then scube=0
if keyword_set(albedo) then al=albedo

;************************************************************
; More Definitions

num2=num*2
gum=num-1

;l0 is the wavelength, in cm
l0= lambda*1e-4

; some math we can do now to make the Bnu calculation faster 
chk=2.0*(kb^3.0)/((cc*hp)^2.0)
hnuok=hp*(cc/l0)/kb

; radsolar is the radius of the sum in cm
radsolar=6.96d10

; rstarcm is the radius of the star in cm
rstarcm=radsolar*rstar

; rstarau is the radius of the star in au
rstarau=rstarcm/1.49597d13

; Calculate Bnu for the star
xb=hnuok/tstar
bnus=(tstar^3.0)*chk*xb^3.0/(exp(xb)-1.0)
starfactor=pi * bnus * rstarau*rstarau/(stepau*stepau)

;**********************************************************
; Make some geometrical calulations 
print, 'Doing the geometry'
; work only with x < num and z < num to save time
; then reflect the answer at the end

c1=cos(pi*inc/180.0)
s1=sin(pi*inc/180.0)
c2=cos(pi*pos/180.0)
s2=sin(pi*pos/180.0)

inu=fltarr(num2, num2)

; Do the spherically symmetric part of the physics.
print, 'Calculating spherically symmetric factors'

; make a vector that contains bnu as a function of radius,
; sampled every 1/5 of a radial step
raus=findgen(num*9.0)*stepau/5.0 > 1e-8 ; 9 is roughly 5 times sqrt(2)
if keyword_set(userdustsize) then begin
print, 'Calculating the equilibrium temperature of the dust'
temperaturecalc, lstar, tstar, userdustsize, raus, t
endif else begin
t = T0 * raus^(-delta)* (lstar^(delta/2.0))
endelse
;Calculate Planck spectrum Bnu (erg s^-1 cm^-2 ster^-1 Hz^-1)
bnu=hnuok/t
bnu=(t^3.0)*chk*bnu^3.0/(exp(bnu)-1.0)
  t=0
 
; compute a spherically symmetric factor from the number density
spherefactor=raus^(-alpha) 

; get rid of the dust outside of radout and inside of radin
stin=(radin*5.0/stepau)-1.0 > 0.0
stout=(radout*5.0/stepau)+1 < num*9.0-1
spherefactor(0:stin)=0
spherefactor(stout:(num*9.0)-1)=0


; Fill arrays with y and z values
yarray=fltarr(num2, num2, /nozero) & zarray=yarray
for i=0, num2-1 do begin
yarray(i,*)=i+0.5-num
zarray(*,i)=i+0.5-num
endfor

; Now do the azimuthally symmetric part

print, 'Calculating azimuthally symmetric factors.'
zetas=findgen(1001)/1000.0   ; zeta goes from 0 to 1 in steps of 0.001 

if keyword_set(iras) then begin
azimuthterms=exp(-beta*(zetas^gamma))  ; use for IRAS
endif else begin
; DIRBE
g= abs(zetas)-(mu/2.0)
smallz=where(zetas lt mu)
g(smallz)=(zetas(smallz)^2.0)/(2.0*mu) 
azimuthterms=exp(-beta*(g^gamma))  
endelse

g=0 & smallz=0 & zetas=0   ; save memory

print, 'Countdown'
;*****************************************************************

for i=0, gum do begin
count=fix((gum-i)/10.0)
if (gum-i)/10.0 eq count then print, -count
x=i+0.5-num

; do some serious geometry
; start calculating the cosine of the scattering angle
costheta=zarray*zarray   ; not really costheta yet
; rsteps will be the distance to the star in steps!
rsteps=costheta+x*x+yarray*yarray > 1e-8   ; actually this is rsteps squared
; grab the local starlight while we have rsteps squared
starlight=starfactor/rsteps  ; like I said, it's really rsteps^2
rsteps=sqrt(rsteps) > 1e-8    ;  ah there we go...now it's rsteps
costheta=zarray/rsteps < 0.999999 ; now we have the cosine of scattering angle

; Then make an array of zeta using a transformed z axis.
zeta=abs((-s1*(s2*x + c2*yarray) + c1*zarray)/rsteps)

if scatterflag eq 1 then begin
; compute scattered light
; put it all together
cloud=spherefactor(rsteps*5.0)*azimuthterms(zeta*1000.0)*(em*bnu(rsteps*5.0) + al*starlight*pfunc500(costheta*500.0))
; double check that dust interior to radin is gone
places=where(rsteps lt radin/stepau)
if places(0) ne -1 then cloud(places)=0.0

endif else begin
; no scattered light
cloud=spherefactor(rsteps*5.0)*azimuthterms(zeta*1000.0)*em*bnu(rsteps*5.0)
endelse

; clear out center of cube for iteration, if necessary
if scube ne 0 and i gt gum-scube and i lt num+scube then begin
gscube=scube-1
cloud(gum-gscube:num+gscube, gum-gscube:num+gscube)=0.0
endif

; Now integrate the emission along lines of sight
inu(i,*)=stepau*total(cloud,2) 

endfor

; then reflect the answer over the vertical axis to fill out inu

if scatterflag eq 1 then begin
; scattered light only
inu(num:num2-1,*)=reverse(inu(0:gum,*),1)
endif else begin
; thermal light + position angle only
inu(num:num2-1,*)=rotate(inu(0:gum,*),2)
endelse

; Multiply the final answer by the local dust n<sigma>

inu=inu*n0
inu=rotate(inu,3)  ; make positionangle=0 North


;  We're done.  Go return the answer to zodipic.

end
