pro xthermalzodimodel, lstar, tstar, num, inu, stepau, inc, lambda, radin, radout, iras=iras, useralpha=useralpha, userdelta=userdelta, scube=scube, userdustsize=userdustsize

; the x is for expansion
; this code is for making big big images

; Rotates the coordinates so you don't have to rotate the matrix

; lstar luminosity of the star in solar luminosities
; num is the number of steps in radius to take

; cloud will be an array
; containing the emissivity of the dust as a function of wavelength

; stepau is the stepsize in au

; radin and radout are the is the disk inner and outer radii in AU

; set iras to use IRAS model

; Written 2/99 by

; Marc J. Kuchner
; Harvard-Smithsonian Center for Astrophysics
; Mail Stop #20
; 60 Garden St. 
; Cambridge, MA 02138
; (617)496-4773

; revised 2/01


;*****************************************************************
; fundamental constants
pi=3.141592
kb=1.38066d-16
cc=2.9979d10
hp=6.62608d-27
sigma=5.6705d-5
l10=2.30259

;DIRBE
; Smooth Cloud
alpha = 1.34
beta = 4.14
gamma = 0.942
delta=0.467
T0=286.0
mu=0.189
;<n sigma> in AU^-1 measured at the Earth
n0=1.13d-7
em=(280.0/(280.0+lambda))+((2.2-0.45*lambda) > 0)
;offsets in AU
;x0=0.119
;y0=0.00548
;z0=0.00215

if keyword_set(iras) then begin
; Old J Good
alpha=1.803
beta=4.973
gamma=1.265
T0=266.20
delta=0.359
n0=2.1527e-7  ;   =1.439e-20*1.495979e13
endif

if keyword_set(useralpha) then alpha=useralpha
if keyword_set(userdelta) then delta=userdelta
if not keyword_set(scube) then scube=0

;************************************************************
; More Definitions

;l0 is the wavelength, in cm
l0= lambda*1e-4

; some math we can do now to make the Bnu calculation faster 
chk=2.0*(kb^3.0)/((cc*hp)^2.0)
hnuok=hp*(cc/l0)/kb



;**********************************************************
; Make some geometrical calulations 
;print, 'Doing the geometry'
; work only with x < num and z < num to save time
; then reflect the answer at the end

c1=cos(pi*inc/180.0)
c2=sin(pi*inc/180.0)
num2=num*2   ; num2 correspondes to upixnum in zodipic
gum=num-1
inu=fltarr(num2, num2)

; Do the spherically symmetric part of the physics.
;print, 'Calculating spherically symmetric terms'

; make a vector that contains bnu as a function of radius,
; sampled every 1/5 of a radial step
; we'll make it run to num*9 though, instead of num*5
; because of the corners 
raus=findgen(num*9.0)*stepau/5.0 > 1e-8 ; 9 is roughly 5 times sqrt(2)
if keyword_set(userdustsize) then begin
print, 'Calculating the equilibrium temperature of the dust'
temperaturecalc, lstar, tstar, userdustsize, raus, t
endif else begin
t = T0 * raus^(-delta)* (lstar^(delta/2.0))
endelse

;Calculate Planck spectrum Bnu (erg s^-1 cm^-2 ster^-1 Hz^-1)
  sphereterms=hnuok/t
  sphereterms=(t^3.0)*chk*sphereterms^3.0/(exp(sphereterms)-1.0)
  t=0
 
; multiply by a spherically symmetric term from the number density
sphereterms=sphereterms*raus^(-alpha) 
;sphereterms=raus^(-alpha)    ; use for outputting <n sigma> alone

; get rid of the dust outside of radout and inside of radin
stin=(radin*5.0/stepau) > 0.0
stout=(radout*5.0/stepau) < (num*9.0)-1
sphereterms(0:stin)=0
sphereterms(stout:(num*9.0)-1)=0

; Fill arrays with x and z values
xarray=fltarr(num2, num, /nozero) & zarray=xarray
for i=0, num2-1 do begin
xarray(i,*)=i+0.5-num
endfor

for i=0, num-1 do begin
zarray(*,i)=i+0.5-num
endfor

zetacloud=abs(-c2*xarray + c1*zarray)
xsquaredpluszsquared=xarray^2.0+zarray^2.0

; Now do the azimuthally symmetric part

;print, 'Calculating azimuthally symmetric terms.'
zetas=findgen(1001)/1000.0   ; zeta goes from 0 to 1 in steps of 0.001 

if keyword_set(iras) then begin
azimuthterms=exp(-beta*(zetas^gamma))  ; use for IRAS
endif else begin
; DIRBE
g= abs(zetas)-(mu/2.0)
smallz=where(zetas lt mu)
g(smallz)=(zetas(smallz)^2.0)/(2.0*mu) 
azimuthterms=exp(-beta*(g^gamma))  
endelse

g=0 & smallz=0 & zetas=0   ; save memory

print, 'Countdown'
;*****************************************************************
for i=0, gum do begin
count=fix((gum-i)/10.0)
if (gum-i)/10.0 eq count then print, -count

; fill a rectangular matrix (cloud) with the distance to the center
; eventually cloud will contain the emission of the model at a given x 
y=i+0.5-num
cloud=sqrt(xsquaredpluszsquared+y*y) > 1e-8 

; Then make an array with zeta using a rotated z axis 
zeta=zetacloud/cloud

; update cloud so it contains the emission, not just some geometry
cloud=sphereterms(cloud*5.0)
cloud=cloud*azimuthterms(zeta*1000.0)

; clear out center of cube for iteration, if necessary
if scube ne 0 and i gt gum-scube then begin
gscube=scube-1
cloud(gum-gscube:num+gscube, gum-gscube:gum)=0.0
endif

; Now integrate the emission along lines of sight
inu(*,i)=stepau*total(cloud,2)   ; total along the z axis

endfor

; then reflect the answer to fill out inu
inu(*,num:num2-1)=reverse(inu(*,0:gum),2)
inu=inu+reverse(inu)


; Multiply the final answer by the emissivity and the local dust n<sigma>

inu=inu*em*n0

;  We're done.  Go return the answer to zodipic.

end
