pro plot_modelvis_uvrad_sc,_EXTRA=e,scan=scan,color=color
;
@common_vars.wave
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,viserr1,viserr2,viserr3,amp,amperr,phas,phaserr
common mymodel,modelvissq1,modelvissq2,modelvissq3,modelamp,modelphas
common mysys,starname,chaname
;
if n_elements(color) eq 0 then color=1
plottitle=starname+','+string(scan,format='(I2)')
;
nu1=u1(*,scan)
nu2=u2(*,scan)
nu3=u3(*,scan)
nv1=v1(*,scan)
nv2=v2(*,scan)
nv3=v3(*,scan)
nvissq1=vissq1(*,scan)
nvissq2=vissq2(*,scan)
nvissq3=vissq3(*,scan)
nviserr1=viserr1(*,scan)
nviserr2=viserr2(*,scan)
nviserr3=viserr3(*,scan)
namp=amp(*,scan)
namperr=amperr(*,scan)
nphas=phas(*,scan)
nphaserr=phaserr(*,scan)
;
nmodelvissq1=modelvissq1(*,scan)
nmodelvissq2=modelvissq2(*,scan)
nmodelvissq3=modelvissq3(*,scan)
nmodelamp=modelamp(*,scan)
nmodelphas=modelphas(*,scan)
;
nuvrad=sqrt(nu1*nu1+nv1*nv1)
nmv=nmodelvissq1
nindex=sort(nuvrad)
plot,_EXTRA=e,$
title=plottitle,$
nuvrad(nindex),nmv(nindex),/nodata,$
xtitle='uv radius [cycles/arcsec]',ytitle='Powerspectrum'
oplot,nuvrad(nindex),nmv(nindex),psym=0,color=color
;
nuvrad=sqrt(nu2*nu2+nv2*nv2)
nmv=nmodelvissq2
nindex=sort(nuvrad)
oplot,nuvrad(nindex),nmv(nindex),psym=0,color=color
;
nuvrad=sqrt(nu3*nu3+nv3*nv3)
nmv=nmodelvissq3
nindex=sort(nuvrad)
oplot,nuvrad(nindex),nmv(nindex),psym=0,color=color
;
end
