pro plot_vis_uvrad_sc,_EXTRA=e,scan=scan
;
@common_vars.wave
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,viserr1,viserr2,viserr3,amp,amperr,phas,phaserr
common mysys,starname,chaname
;
nu1=u1(*,scan)
nu2=u2(*,scan)
nu3=u3(*,scan)
nv1=v1(*,scan)
nv2=v2(*,scan)
nv3=v3(*,scan)
nvissq1=vissq1(*,scan)
nvissq2=vissq2(*,scan)
nvissq3=vissq3(*,scan)
nviserr1=viserr1(*,scan)
nviserr2=viserr2(*,scan)
nviserr3=viserr3(*,scan)
namp=amp(*,scan)
namperr=amperr(*,scan)
nphas=phas(*,scan)
nphaserr=phaserr(*,scan)
;
nuvrad1=sqrt(nu1*nu1+nv1*nv1)
nuvrad2=sqrt(nu2*nu2+nv2*nv2)
nuvrad3=sqrt(nu3*nu3+nv3*nv3)
;
plotitle=starname+','+string(scan,format='(I2)')
index1=where(nviserr1 gt 0 and nviserr1 lt 1.0)
plot,_EXTRA=e,$
nuvrad1(index1),nvissq1(index1),/nodata,$
xtitle='uv radius [cycles/arcsec]',ytitle='Powerspectrum',$
title=plotitle
oploterr,nuvrad1(index1),nvissq1(index1),nviserr1(index1)
;
index2=where(nviserr2 gt 0 and nviserr2 lt 1.0)
oploterr,nuvrad2(index2),nvissq2(index2),nviserr2(index2)
;
index3=where(nviserr3 gt 0 and nviserr3 lt 1.0)
oploterr,nuvrad3(index3),nvissq3(index3),nviserr3(index3)
end
