pro geom1,X,A,F,pder
F=A[0] * X^A[1]
if n_params() ge 4 then $
pder=[[x^a[1]] , [a[0] * alog(x) * x^a[1]] ]
end

pro geom2,X,A,F,pder
F=A[0] / X
if n_params() ge 4 then $
pder=[1/X]
end

pro biascalc_geom
;
; Compute the bias correction for each channel and spectrometer if the data
; was taken away from the fringe packet by fitting to the geometric model.
;
common Tables,scantable,bgtable,stationtable
common SysConfig,Date,SystemId,MetroConfig,GeoParms,GenConfig,GeoInfo,GenInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common mybias,coeffa0,coeffa1,coeffb0,coeffa0sig,coeffa1sig,coeffb0sig,coeffchisq,coeffchisq2
;
coeffa0=fltarr(GenConfig.NumOutBeam,max(GenConfig.NumSpecChan))
coeffa1=fltarr(GenConfig.NumOutBeam,max(GenConfig.NumSpecChan))
coeffb0=fltarr(GenConfig.NumOutBeam,max(GenConfig.NumSpecChan))
coeffa0sig=fltarr(GenConfig.NumOutBeam,max(GenConfig.NumSpecChan))
coeffa1sig=fltarr(GenConfig.NumOutBeam,max(GenConfig.NumSpecChan))
coeffb0sig=fltarr(GenConfig.NumOutBeam,max(GenConfig.NumSpecChan))
coeffchisq=fltarr(GenConfig.NumOutBeam,max(GenConfig.NumSpecChan))
coeffchisq2=fltarr(GenConfig.NumOutBeam,max(GenConfig.NumSpecChan))
;
for i=0,GenConfig.NumOutBeam-1 do begin
for j=0,GenConfig.NumSpecChan(i)-1 do begin
      a=[0.5,-1.0]
      b=[0.5]
      index=where(scans(*).vissqerr(i,j,0) gt 0,count)
      if count gt 1 then begin 
       xx=scans(index).photonrate(i,j)
       yy=scans(index).vissq(i,j,0)
       ss=scans(index).vissqerr(i,j,0)
       ww=1./(ss^2.)
;       ww=1./xx
;       fac=avg(ww)
;       ww=ww/fac
       ww=0.*ww+1.
       fac=1.
       yfit=curvefit(xx,yy,ww,a,sig,FUNCTION_NAME='geom1',chisq=chsq)
       yfit=curvefit(xx,yy,ww,a,sig,FUNCTION_NAME='geom1',chisq=chsq)
       yfit=curvefit(xx,yy,ww,a,sig,FUNCTION_NAME='geom1',chisq=chsq)
       yfit=curvefit(xx,yy,ww,a,sig,FUNCTION_NAME='geom1',chisq=chsq)
       yfit=curvefit(xx,yy,ww,a,sig,FUNCTION_NAME='geom1',chisq=chsq)
       coeffa0(i,j)=a(0)
       coeffa1(i,j)=a(1)
       coeffa0sig(i,j)=sig(0)/fac
       coeffa1sig(i,j)=sig(1)/fac
       coeffchisq(i,j)=fac*chsq/(n_elements(xx)-1)
       yfit=curvefit(xx,yy,ww,b,sig,FUNCTION_NAME='geom2',chisq=chsq)
       yfit=curvefit(xx,yy,ww,b,sig,FUNCTION_NAME='geom2',chisq=chsq)
       yfit=curvefit(xx,yy,ww,b,sig,FUNCTION_NAME='geom2',chisq=chsq)
       yfit=curvefit(xx,yy,ww,b,sig,FUNCTION_NAME='geom2',chisq=chsq)
       yfit=curvefit(xx,yy,ww,b,sig,FUNCTION_NAME='geom2',chisq=chsq)
       coeffb0(i,j)=b(0)
       coeffb0sig(i,j)=sig(0)/fac
       coeffchisq2(i,j)=fac*chsq/(n_elements(xx)-1)
      endif
endfor
endfor
;
end
