pro chisq,_EXTRA=e,method=method,uvmax=uvmax
;
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,viserr1,$
       viserr2,viserr3,amp,amperr,phas,phaserr
common mymodel,modelvissq1,modelvissq2,modelvissq3,modelamp,modelphas,chisq
;
if (n_elements(method) ne 1 ) then method=123
if (n_elements(uvmax) ne 1 ) then uvmax=10000
;
PI=3.14159265358979323846d0
;
model,_EXTRA=e
;
uvrad1 = sqrt ( (u1*u1) + (v1*v1) )
uvrad2 = sqrt ( (u2*u2) + (v2*v2) )
uvrad3 = sqrt ( (u3*u3) + (v3*v3) )

if ((method eq 1) or (method eq 12) or (method eq 13) or (method eq 123))$
then begin
index1=where((viserr1 gt 0) and (uvrad1 lt uvmax),count)
if count gt 0 then begin
chisqvis1=total(((vissq1(index1)-modelvissq1(index1))/viserr1(index1))*$
                ((vissq1(index1)-modelvissq1(index1))/viserr1(index1)))
endif else chisqvis1=0
index2=where((viserr2 gt 0) and (uvrad2 lt uvmax),count)
if count gt 0 then begin
chisqvis2=total(((vissq2(index2)-modelvissq2(index2))/viserr2(index2))*$
                ((vissq2(index2)-modelvissq2(index2))/viserr2(index2)))
endif else chisqvis2=0
index3=where((viserr3 gt 0) and (uvrad3 lt uvmax),count)
if count gt 0 then begin
chisqvis3=total(((vissq3(index3)-modelvissq3(index3))/viserr3(index3))*$
                ((vissq3(index3)-modelvissq3(index3))/viserr3(index3)))
endif else chisqvis3=0
chisqvis=chisqvis1+chisqvis2+chisqvis3
visnel=n_elements(index1)+n_elements(index2)+n_elements(index3)
endif
;
if ((method eq 2) or (method eq 12) or (method eq 23) or (method eq 123))$
then begin
index=where((amperr gt 0) and (uvrad1 lt uvmax) and (uvrad2 lt uvmax) and $
(uvrad3 lt uvmax),count)
if count gt 0 then begin
chisqamp=total(((amp(index)-modelamp(index))/amperr(index))*$
               ((amp(index)-modelamp(index))/amperr(index)))
endif else chisqamp=0
ampnel=n_elements(index)
;
endif
;
if ((method eq 3) or (method eq 13) or (method eq 23) or (method eq 123))$
then begin
index=where((phaserr gt 0) and (uvrad1 lt uvmax) and (uvrad2 lt uvmax) and $
(uvrad3 lt uvmax),count)
if count gt 0 then begin
diff=abs(phas(index)-modelphas(index))
indexp=where(diff ge PI,count)
if (count gt 0) then diff(indexp)=(2.0*PI)-diff(indexp)
indexp=where(diff ge PI,count)
if (count gt 0) then diff(indexp)=(2.0*PI)-diff(indexp)
indexp=where(diff ge PI,count)
if (count gt 0) then diff(indexp)=(2.0*PI)-diff(indexp)
indexp=where(diff ge PI,count)
if (count gt 0) then diff(indexp)=(2.0*PI)-diff(indexp)
diffsq=diff*diff
chisqpha=total(diffsq/(phaserr(index)*phaserr(index)))
endif else chisqpha=0
phanel=n_elements(index)
endif
;
if (method eq 1) then chisq=chisqvis/(visnel-1.0)
if (method eq 2) then chisq=chisqamp/(ampnel-1.0)
if (method eq 3) then chisq=chisqpha/(phanel-1.0)
if (method eq 12) then chisq=(chisqvis+chisqamp)/(visnel+ampnel-1.0)
if (method eq 13) then chisq=(chisqvis+chisqpha)/(visnel+phanel-1.0)
if (method eq 23) then chisq=(chisqamp+chisqpha)/(ampnel+phanel-1.0)
if (method eq 123) $
  then chisq=(chisqvis+chisqamp+chisqpha)/(visnel+ampnel+phanel-1.0)
;
end
