pro extract,star=star,num_chan=num_chan
;
PI=3.14159265358979323846d0
;
common mysys,starname,chaname
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,viserr1,$
       viserr2,viserr3,amp,amperr,phas,phaserr
common SysConfig,Date,SystemId,MetroConfig,GeoParms,GenConfig,GeoInfo,GenInfo
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
starname=star
if n_elements(num_chan) eq 0 then num_chan=20
ch=indgen(num_chan)
wavele=genconfig.wavelength(ch,0)
index=where(scans.starid eq star)
iu1=reform(scans(index).uvw(0,ch,0,0)/206264.8)
iv1=reform(scans(index).uvw(0,ch,0,1)/206264.8)
iu2=reform(scans(index).uvw(1,ch,0,0)/206264.8)
iv2=reform(scans(index).uvw(1,ch,0,1)/206264.8)
iu3=reform(scans(index).uvw(2,ch,0,0)/206264.8)
iv3=reform(scans(index).uvw(2,ch,0,1)/206264.8)
ivissq1=reform(scans(index).vissqc(0,ch,0))
ivissq2=reform(scans(index).vissqc(1,ch,0))
ivissq3=reform(scans(index).vissqc(2,ch,0))
iviserr1=reform(scans(index).vissqcerr(0,ch,0))
iviserr2=reform(scans(index).vissqcerr(1,ch,0))
iviserr3=reform(scans(index).vissqcerr(2,ch,0))
iamp=reform(scans(index).tripleampc(0,ch))
iamperr=reform(scans(index).tripleampcerr(0,ch))
iphas=reform(scans(index).triplephasec(0,ch))
iphaserr=reform(scans(index).triplephasecerr(0,ch))
;
if n_elements(u1) ne 0 then u1=[[u1],[iu1]] else u1=iu1
if n_elements(u2) ne 0 then u2=[[u2],[iu2]] else u2=iu2
if n_elements(u3) ne 0 then u3=[[u3],[iu3]] else u3=iu3
if n_elements(v1) ne 0 then v1=[[v1],[iv1]] else v1=iv1
if n_elements(v2) ne 0 then v2=[[v2],[iv2]] else v2=iv2
if n_elements(v3) ne 0 then v3=[[v3],[iv3]] else v3=iv3
if n_elements(vissq1) ne 0 then vissq1=[[vissq1],[ivissq1]] else vissq1=ivissq1
if n_elements(vissq2) ne 0 then vissq2=[[vissq2],[ivissq2]] else vissq2=ivissq2
if n_elements(vissq3) ne 0 then vissq3=[[vissq3],[ivissq3]] else vissq3=ivissq3
if n_elements(viserr1) ne 0 then viserr1=[[viserr1],[iviserr1]]$
  else viserr1=iviserr1
if n_elements(viserr2) ne 0 then viserr2=[[viserr2],[iviserr2]]$
  else viserr2=iviserr2
if n_elements(viserr3) ne 0 then viserr3=[[viserr3],[iviserr3]]$
  else viserr3=iviserr3
if n_elements(amp) ne 0 then amp=[[amp],[iamp]] else amp=iamp
if n_elements(amperr) ne 0 then amperr=[[amperr],[iamperr]] else amperr=iamperr
if n_elements(phas) ne 0 then phas=[[phas],[iphas]] else phas=iphas
if n_elements(phaserr) ne 0 then phaserr=[[phaserr],[iphaserr]]$
  else phaserr=iphaserr
;
index=where(phas lt (-0.25*PI),count)
if (count gt 0) then phas(index)=phas(index)+(2.0*PI)
index=where(phas ge (1.75*PI),count)
if (count gt 0) then phas(index)=phas(index)-(2.0*PI)
index=where(phas lt (-0.25*PI),count)
if (count gt 0) then phas(index)=phas(index)+(2.0*PI)
index=where(phas ge (1.75*PI),count)
if (count gt 0) then phas(index)=phas(index)-(2.0*PI)
;
end
