pro model,major=major,phi=phi,dst=dst,dhs=dhs,a=a,iratio=iratio,sep=sep,$
          model=model,teff=teff,logg=logg
;
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,$
       viserr1,viserr2,viserr3,amp,amperr,phas,phaserr
common mymodel,modelvissq1,modelvissq2,modelvissq3,modelamp,modelphas,chisq
common kurucz,kur_teff,kur_logg,kur_I,kur_mu,kur_alpha,kur_int

;
if (n_elements(major) ne 1) then major=1
if (n_elements(phi) ne 1) then phi=0
if (n_elements(dhs) ne 1) then dhs=1
if (n_elements(a) lt 1) then a=0
if (n_elements(iratio) ne 1) then iratio=0
if (n_elements(sep) ne 1) then sep=0
if (n_elements(model) ne 1) then model=2
;
la=major
PI=3.14159265358979323846d0
;
if keyword_set(teff) then begin
alpha=u1
para=kur_npoi(teff,logg,model)
sss=size(u1)
scans=sss[2]-1
channels=sss[1]-1
for ch=0,channels do begin
for sc=0,scans do begin
alpha[ch,sc]=para[ch,0]
endfor
endfor
endif else begin
alpha=u1
sss=size(u1)
scans=sss[2]-1
channels=sss[1]-1
for ch=0,channels do begin
for sc=0,scans do begin
if (n_elements(a) eq 1) then alpha[ch,sc]=a
if (n_elements(a) eq (channels+1)) then alpha[ch,sc]=a[ch]
endfor
endfor
endelse
;
Ihs=abs(iratio)/(abs(iratio)+1.0)
Istar=1.0-Ihs
phi=phi*PI/180
;
sa=1/la
;
u1n=((1.0/la)*(cos(phi)*u1+sin(phi)*v1))
v1n=((1.0/sa)*(cos(phi)*v1-sin(phi)*u1))
u2n=((1.0/la)*(cos(phi)*u2+sin(phi)*v2))
v2n=((1.0/sa)*(cos(phi)*v2-sin(phi)*u2))
u3n=((1.0/la)*(cos(phi)*u3+sin(phi)*v3))
v3n=((1.0/sa)*(cos(phi)*v3-sin(phi)*u3))
uvrad1 = sqrt ( (u1n*u1n) + (v1n*v1n) )
uvrad2 = sqrt ( (u2n*u2n) + (v2n*v2n) )
uvrad3 = sqrt ( (u3n*u3n) + (v3n*v3n) )
;
; V is calculated by evaluating the integrals, e.g. Davis et al. 2000
; MNRAS 318, 387
if (model eq 0) then begin
xx=reverse([1.,kur_mu,0.],1)
;
;star at uvrad1
chmax=n_elements(uvrad1(*,0))
scmax=n_elements(uvrad1(0,*))
visstar1=fltarr(chmax,scmax)
for i=0,chmax-1 do begin
for j=0,scmax-1 do begin
f1=reverse([1.,reform(kur_int(i,0,*))/1.0E5,0.],1)*xx
xld=uvrad1(i,j)*PI*dst
f2=beselj(xld*sqrt(1.-xx*xx),0)*f1
visstar1(i,j)=Istar*int_tabulated(xx,f2)/int_tabulated(xx,f1)
endfor
endfor
;
;star at uvrad2
visstar2=uvrad2
for i=0,chmax-1 do begin
for j=0,scmax-1 do begin
f1=reverse([1.,reform(kur_int(i,0,*))/1.0E5,0.],1)*xx
xld=uvrad2(i,j)*PI*dst
f2=beselj(xld*sqrt(1.-xx*xx),0)*f1
visstar2(i,j)=Istar*int_tabulated(xx,f2)/int_tabulated(xx,f1)
endfor
endfor
;
;star at uvrad3
visstar3=uvrad3
for i=0,chmax-1 do begin
for j=0,scmax-1 do begin
f1=reverse([1.,reform(kur_int(i,0,*))/1.0E5,0.],1)*xx
xld=uvrad3(i,j)*PI*dst
f2=beselj(xld*sqrt(1.-xx*xx),0)*f1
visstar3(i,j)=Istar*int_tabulated(xx,f2)/int_tabulated(xx,f1)
endfor
endfor
;
;spots with model 1 assumption
;
;spot at uvrad1
x=uvrad1*PI*dhs
xnu=1.0
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
vishs1=Ihs*gamm*(bes/nnn)
;
;spot at uvrad2
x=uvrad2*PI*dhs
xnu=1.0
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
vishs2=Ihs*gamm*(bes/nnn)
;
;spot at uvrad3
x=uvrad3*PI*dhs
xnu=1.0
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
vishs3=Ihs*gamm*(bes/nnn)
;
endif
;
if (model eq 1) then begin
;star at uvrad1
x=uvrad1*PI*dst
xnu=1.0+(alpha/2.0)
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
visstar1=Istar*gamm*(bes/nnn)
;
;spot at uvrad1
x=uvrad1*PI*dhs
xnu=1.0
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
vishs1=Ihs*gamm*(bes/nnn)
;
;
;star at uvrad2
x=uvrad2*PI*dst
xnu=1.0+(alpha/2.0)
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
visstar2=Istar*gamm*(bes/nnn)
;
;spot at uvrad2
x=uvrad2*PI*dhs
xnu=1.0
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
vishs2=Ihs*gamm*(bes/nnn)
;
;star at uvrad3
x=uvrad3*PI*dst
xnu=1.0+(alpha/2.0)
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
visstar3=Istar*gamm*(bes/nnn)
;
;spot at uvrad3
x=uvrad3*PI*dhs
xnu=1.0
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
vishs3=Ihs*gamm*(bes/nnn)
endif
;
if (model eq 2) then begin
;star at pos 1
x=uvrad1*PI*dst
aa=1-alpha
bb=alpha
bes1 = bessj(x,1.)
bes15= bessj(x,1.5) 
visstar1=Istar * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;star at pos 2
x=uvrad2*PI*dst
aa=1-alpha
bb=alpha
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
visstar2=Istar * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;star at pos 3
x=uvrad3*PI*dst
aa=1-alpha
bb=alpha
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
visstar3=Istar * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;
;spot at pos 1
x=uvrad1*PI*dhs
aa=1.
bb=0.
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
vishs1=Ihs * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;spot at pos 2
x=uvrad2*PI*dhs
aa=1.
bb=0.
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
vishs2=Ihs * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;spot at pos 3
x=uvrad3*PI*dhs
aa=1.
bb=0.
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
vishs3=Ihs * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
endif
;
;/* star+hs at pos 1 */
nom = vishs1 * sin(2.0*PI*u1n*sep)
den = visstar1 + ( vishs1 * cos(2.0*PI*u1n*sep))
vis1   = sqrt(nom*nom+den*den)
phase1 = atan ( nom, den )
modelvissq1 = vis1*vis1

;/* star+hs at pos 2 */
nom = vishs2 * sin(2.0*PI*u2n*sep)
den = visstar2 + ( vishs2 * cos(2.0*PI*u2n*sep))
vis2   = sqrt(nom*nom+den*den)
phase2 = atan ( nom, den )
modelvissq2 = vis2*vis2

;/* star+hs at pos 3 */
nom = vishs3 * sin(2.0*PI*u3n*sep)
den = visstar3 + ( vishs3 * cos(2.0*PI*u3n*sep))
vis3   = sqrt(nom*nom+den*den)
phase3 = atan ( nom, den )
modelvissq3 = vis3*vis3
;
modelamp=abs(vis1*vis2*vis3)
modelphas=phase1+phase2-phase3
;
index=where(modelphas lt (-0.25*PI),count)
if (count gt 0) then modelphas(index)=modelphas(index)+(2.0*PI)
index=where(modelphas ge (1.75*PI),count)
if (count gt 0) then modelphas(index)=modelphas(index)-(2.0*PI)
index=where(modelphas lt (-0.25*PI),count)
if (count gt 0) then modelphas(index)=modelphas(index)+(2.0*PI)
index=where(modelphas ge (1.75*PI),count)
if (count gt 0) then modelphas(index)=modelphas(index)-(2.0*PI)
;
end
