pro modelcont,major=major,phi=phi,dst=dst,dhs=dhs,a=a,iratio=iratio,sep=sep,$
          model=model,teff=teff,logg=logg
;
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,$
       viserr1,viserr2,viserr3,amp,amperr,phas,phaserr
common mymodel,modelvissq1,modelvissq2,modelvissq3,modelamp,modelphas,chisq
common mycont,uvradcont,modelvissqcont
;
if (n_elements(major) ne 1) then major=1
if (n_elements(phi) ne 1) then phi=0
if (n_elements(dhs) ne 1) then dhs=1
if (n_elements(a) lt 1) then a=0
if (n_elements(iratio) ne 1) then iratio=0
if (n_elements(sep) ne 1) then sep=0
if (n_elements(model) ne 1) then model=2
;
la=major
PI=3.14159265358979323846d0
;
if keyword_set(teff) then begin
alpha=uvradcont
if model eq 1 then para=kur_npoi(teff,logg)
if model eq 2 then para=limbnpoi(teff,logg)
sss=size(uvradcont)
channels=sss[1]-1
for ch=0,channels do begin
alpha[ch]=para[ch]
endfor
endif else begin
alpha=uvradcont
sss=size(uvradcont)
channels=sss[1]-1
for ch=0,channels do begin
if (n_elements(a) eq 1) then alpha[ch]=a
if (n_elements(a) eq (channels+1)) then alpha[ch]=a[ch]
endfor
endelse
;
Ihs=iratio/(iratio+1.0)
Istar=1.0-Ihs
phi=phi*PI/180
;
sa=1/la
;
;u1n=((1.0/la)*(cos(phi)*u1+sin(phi)*v1))
;v1n=((1.0/sa)*(cos(phi)*v1-sin(phi)*u1))
;u2n=((1.0/la)*(cos(phi)*u2+sin(phi)*v2))
;v2n=((1.0/sa)*(cos(phi)*v2-sin(phi)*u2))
;u3n=((1.0/la)*(cos(phi)*u3+sin(phi)*v3))
;v3n=((1.0/sa)*(cos(phi)*v3-sin(phi)*u3))
;uvrad1 = sqrt ( (u1n*u1n) + (v1n*v1n) )
;uvrad2 = sqrt ( (u2n*u2n) + (v2n*v2n) )
;uvrad3 = sqrt ( (u3n*u3n) + (v3n*v3n) )
uvrad1=uvradcont
;
if (model eq 1) then begin
;star at uvrad1
x=uvrad1*PI*dst
xnu=1.0+(alpha/2.0)
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
visstar1=Istar*gamm*(bes/nnn)
;
;spot at uvrad1
x=uvrad1*PI*dhs
xnu=1.0
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
vishs1=Ihs*gamm*(bes/nnn)
;
endif
;
if (model eq 2) then begin
;star at pos 1
x=uvrad1*PI*dst
aa=1-alpha
bb=alpha
bes1 = bessj(x,1.)
bes15= bessj(x,1.5) 
visstar1=Istar * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;spot at pos 1
x=uvrad1*PI*dhs
aa=1.
bb=0.
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
vishs1=Ihs * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
endif
;
modelvissqcont = visstar1*visstar1
;
end
