pro modeltriplecont,major=major,phi=phi,dst=dst,dhs=dhs,a=a,$
                    iratio=iratio,sep=sep,model=model,teff=teff,logg=logg
;
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,$
       viserr1,viserr2,viserr3,amp,amperr,phas,phaserr
common contdata,contwavele,contu1,contv1,contu2,contv2,contu3,contv3
common contmodel,contvissq1,contvissq2,contvissq3,contamp,contphas
;
sss=size(u1)
scans=sss[2]
;
wavemin=5e-7
wavemax=9e-7
wavesteps=500
contwavele = (findgen (wavesteps) * (wavemax - wavemin) / wavesteps) + wavemin
;
contu1=fltarr(wavesteps,scans)
contv1=fltarr(wavesteps,scans)
contu2=fltarr(wavesteps,scans)
contv2=fltarr(wavesteps,scans)
contu3=fltarr(wavesteps,scans)
contv3=fltarr(wavesteps,scans)
;
for i=0,wavesteps-1 do begin
for j=0,scans-1 do begin
contu1(i,j)=u1(0,j)*wavele(0)/contwavele(i)
contv1(i,j)=v1(0,j)*wavele(0)/contwavele(i)
contu2(i,j)=u2(0,j)*wavele(0)/contwavele(i)
contv2(i,j)=v2(0,j)*wavele(0)/contwavele(i)
contu3(i,j)=u3(0,j)*wavele(0)/contwavele(i)
contv3(i,j)=v3(0,j)*wavele(0)/contwavele(i)
endfor
endfor
;
if (n_elements(major) ne 1) then major=1
if (n_elements(phi) ne 1) then phi=0
if (n_elements(dhs) ne 1) then dhs=1
if (n_elements(a) lt 1) then a=0
if (n_elements(iratio) ne 1) then iratio=0
if (n_elements(sep) ne 1) then sep=0
if (n_elements(model) ne 1) then model=2
;
la=major
PI=3.14159265358979323846d0
;
if keyword_set(teff) then begin
alpha=contu1
if model eq 1 then para=kur_npoi(teff,logg)
if model eq 2 then para=limbnpoi(teff,logg)
sss=size(contu1)
scans=sss[2]-1
channels=sss[1]-1
for ch=0,channels do begin
for sc=0,scans do begin
alpha[ch,sc]=para[ch,0]
endfor
endfor
endif else begin
alpha=contu1
sss=size(contu1)
scans=sss[2]-1
channels=sss[1]-1
for ch=0,channels do begin
for sc=0,scans do begin
if (n_elements(a) eq 1) then alpha[ch,sc]=a
if (n_elements(a) eq (channels+1)) then alpha[ch,sc]=a[ch]
endfor
endfor
endelse
;
Ihs=iratio/(iratio+1.0)
Istar=1.0-Ihs
phi=phi*PI/180
;
sa=1/la
;
u1n=((1.0/la)*(cos(phi)*contu1+sin(phi)*contv1))
v1n=((1.0/sa)*(cos(phi)*contv1-sin(phi)*contu1))
u2n=((1.0/la)*(cos(phi)*contu2+sin(phi)*contv2))
v2n=((1.0/sa)*(cos(phi)*contv2-sin(phi)*contu2))
u3n=((1.0/la)*(cos(phi)*contu3+sin(phi)*contv3))
v3n=((1.0/sa)*(cos(phi)*contv3-sin(phi)*contu3))
uvrad1 = sqrt ( (u1n*u1n) + (v1n*v1n) )
uvrad2 = sqrt ( (u2n*u2n) + (v2n*v2n) )
uvrad3 = sqrt ( (u3n*u3n) + (v3n*v3n) )
;
if (model eq 1) then begin
;star at uvrad1
x=uvrad1*PI*dst
xnu=1.0+(alpha/2.0)
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
visstar1=Istar*gamm*(bes/nnn)
;
;spot at uvrad1
x=uvrad1*PI*dhs
xnu=1.0
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
vishs1=Ihs*gamm*(bes/nnn)
;
;
;star at uvrad2
x=uvrad2*PI*dst
xnu=1.0+(alpha/2.0)
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
visstar2=Istar*gamm*(bes/nnn)
;
;spot at uvrad2
x=uvrad2*PI*dhs
xnu=1.0
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
vishs2=Ihs*gamm*(bes/nnn)
;
;star at uvrad3
x=uvrad3*PI*dst
xnu=1.0+(alpha/2.0)
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
visstar3=Istar*gamm*(bes/nnn)
;
;spot at uvrad3
x=uvrad3*PI*dhs
xnu=1.0
gamm=gamma((xnu+1.0))
bes=bessj(x,xnu)
nnn=(x/2.0)^xnu
vishs3=Ihs*gamm*(bes/nnn)
endif
;
if (model eq 2) then begin
;star at pos 1
x=uvrad1*PI*dst
aa=1-alpha
bb=alpha
bes1 = bessj(x,1.)
bes15= bessj(x,1.5) 
visstar1=Istar * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;star at pos 2
x=uvrad2*PI*dst
aa=1-alpha
bb=alpha
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
visstar2=Istar * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;star at pos 3
x=uvrad3*PI*dst
aa=1-alpha
bb=alpha
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
visstar3=Istar * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;
;spot at pos 1
x=uvrad1*PI*dhs
aa=1.
bb=0.
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
vishs1=Ihs * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;spot at pos 2
x=uvrad2*PI*dhs
aa=1.
bb=0.
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
vishs2=Ihs * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
;spot at pos 3
x=uvrad3*PI*dhs
aa=1.
bb=0.
bes1 = bessj(x,1.)
bes15= bessj(x,1.5)
vishs3=Ihs * ( 1.0 / (aa/2.0 + bb/3.0) ) *$
 ( (aa*bes1/x) + (bb*sqrt(PI/2.0)*bes15/(x^1.5)) )
;
endif
;
;/* star+hs at pos 1 */
nom = vishs1 * sin(2.0*PI*u1n*sep)
den = visstar1 + ( vishs1 * cos(2.0*PI*u1n*sep))
vis1   = sqrt(nom*nom+den*den)
phase1 = atan ( nom, den )
contvissq1 = vis1*vis1

;/* star+hs at pos 2 */
nom = vishs2 * sin(2.0*PI*u2n*sep)
den = visstar2 + ( vishs2 * cos(2.0*PI*u2n*sep))
vis2   = sqrt(nom*nom+den*den)
phase2 = atan ( nom, den )
contvissq2 = vis2*vis2

;/* star+hs at pos 3 */
nom = vishs3 * sin(2.0*PI*u3n*sep)
den = visstar3 + ( vishs3 * cos(2.0*PI*u3n*sep))
vis3   = sqrt(nom*nom+den*den)
phase3 = atan ( nom, den )
contvissq3 = vis3*vis3
;
contamp=abs(vis1*vis2*vis3)
contphas=phase1+phase2-phase3
;
index=where(contphas lt (-0.25*PI),count)
if (count gt 0) then contphas(index)=contphas(index)+(2.0*PI)
index=where(contphas ge (1.75*PI),count)
if (count gt 0) then contphas(index)=contphas(index)-(2.0*PI)
index=where(contphas lt (-0.25*PI),count)
if (count gt 0) then contphas(index)=contphas(index)+(2.0*PI)
index=where(contphas ge (1.75*PI),count)
if (count gt 0) then contphas(index)=contphas(index)-(2.0*PI)
;
end
