pro plot_chisq_ell_pa_sep,pamin=pamin,pamax=pamax,pasteps=pasteps,$
                      sepmin=sepmin,sepmax=sepmax,sepsteps=sepsteps,$
                      _EXTRA=e,method=method,teff=teff,logg=logg,model=model,$
                      dst=dst,a=a
;
common mymodel,modelvissq1,modelvissq2,modelvissq3,modelamp,modelphas,chisq
;
if (n_elements(pamin) ne 1) then pamin=0
if (n_elements(pamax) ne 1) then pamax=360
if (n_elements(pasteps) ne 1) then pasteps=20
if (n_elements(sepmin) ne 1) then sepmin=1.0
if (n_elements(sepmax) ne 1) then sepmax=2.0
if (n_elements(sepsteps) ne 1) then sepsteps=20
if (n_elements(method) ne 1) then method=1
if (n_elements(teff) ne 1) then teff=-1
if (n_elements(logg) ne 1) then logg=-1
if (n_elements(a) ne 1) then a=0
if (n_elements(model) ne 1) then model=2
;
@common_vars.wave
;
npa=(pamax-pamin)/pasteps
nsep=(sepmax-sepmin)/sepsteps
palst=fltarr(pasteps)
seplst=fltarr(sepsteps)
chisqlst=fltarr(pasteps,sepsteps)
for i=0,(pasteps-1) do begin
for j=0,(sepsteps-1) do begin
palst[i]=pamin+(i*npa)
seplst[j]=sepmin+(j*nsep)
if ((teff gt 0) and (logg gt 0)) then begin
chisq,major=seplst[j],dst=dst,iratio=0,dhs=1e-3,sep=0,phi=palst[i],$
 teff=teff,logg=logg,model=model,method=method
endif else begin
chisq,major=seplst[j],dst=dst,iratio=0,dhs=1e-3,sep=0,phi=palst[i],$
 a=0,model=model,method=method
endelse
chisqlst[i,j]=chis 
endfor
endfor
;
mmm=min(chisqlst)
print,min(chisqlst)
for i=0,(pasteps-1) do begin
for j=0,(sepsteps-1) do begin
if (chisqlst[i,j] eq mmm) then begin
print,palst[i]
print,seplst[j]
endif
endfor
endfor
chisqlst=chisqlst/mmm
window,0
contour,1.0/chisqlst,palst,seplst,_EXTRA=e,$
levels=[0.8,0.82,0.84,0.86,0.88,0.9,0.92,0.94,0.96,0.98,0.99],/follow
window,1
shade_surf,1.0/chisqlst,palst,seplst,min_value=0.8
;
end
