pro plot_modelvis_uvproj,angle=angle,_EXTRA=e
;
@common_vars.wave
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,$
       viserr1,viserr2,viserr3,amp,amperr,phas,phaserr
common mymodel,modelvissq1,modelvissq2,modelvissq3,modelamp,modelphas,chisq
;
angle=angle*PI/180
uvrad1=sqrt(u1*u1+v1*v1)
uvrad2=sqrt(u2*u2+v2*v2)
uvrad3=sqrt(u3*u3+v3*v3)
uvproj1=uvrad1*sin(atan(u1/v1)-angle)
uvproj2=uvrad2*sin(atan(u2/v2)-angle)
uvproj3=uvrad3*sin(atan(u3/v3)-angle)
;
uvproj1=abs(uvproj1)
uvproj2=abs(uvproj2)
uvproj3=abs(uvproj3)
;
;
iii=where(viserr1>0)
index1=sort(uvrad1(iii))
plot,_EXTRA=e,$
uvproj1(index1),modelvissq1(index1),/nodata,$
xtitle='Projected uv [cycles/arcsec]',ytitle='Powerspectrum'
oplot,uvproj1(index1),modelvissq1(index1),psym=1
;
iii=where(viserr2>0)
index2=sort(uvrad2(iii))
oplot,uvproj2(index2),modelvissq2(index2),psym=1
;
iii=where(viserr3>0)
index3=sort(uvrad3(iii))
oplot,uvproj3(index3),modelvissq3(index3),psym=1
;
end
