pro plot_modelvis_uvrad_o,_EXTRA=e,scan=scan,color=color,oneplot=oneplot
;
@common_vars.wave
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,$
       viserr1,viserr2,viserr3,amp,amperr,phas,phaserr
common mymodel,modelvissq1,modelvissq2,modelvissq3,modelamp,modelphas,chisq
common mysys,starname,chaname
common SysConfig,Date,SystemId,MetroConfig,GeoParms,GenConfig,GeoInfo,GenInfo
;
if n_elements(color) eq 0 then color=0
if n_elements(oneplot) eq 0 then oneplot=0
if (n_elements(scan) eq 0) then begin
plottitle=starname+', '+Date
endif else begin
plottitle=starname+', '+Date+', '+string(scan,format='(I2)')
endelse
;
if (n_elements(scan) eq 0) then begin
nu1=u1
nu2=u2
nu3=u3
nv1=v1
nv2=v2
nv3=v3
nvissq1=vissq1
nvissq2=vissq2
nvissq3=vissq3
nviserr1=viserr1
nviserr2=viserr2
nviserr3=viserr3
namp=amp
namperr=amperr
nphas=phas
nphaserr=phaserr
;
nmodelvissq1=modelvissq1
nmodelvissq2=modelvissq2
nmodelvissq3=modelvissq3
nmodelamp=modelamp
nmodelphas=modelphas
endif else begin
nu1=u1(*,scan)
nu2=u2(*,scan)
nu3=u3(*,scan)
nv1=v1(*,scan)
nv2=v2(*,scan)
nv3=v3(*,scan)
nvissq1=vissq1(*,scan)
nvissq2=vissq2(*,scan)
nvissq3=vissq3(*,scan)
nviserr1=viserr1(*,scan)
nviserr2=viserr2(*,scan)
nviserr3=viserr3(*,scan)
namp=amp(*,scan)
namperr=amperr(*,scan)
nphas=phas(*,scan)
nphaserr=phaserr(*,scan)
;
nmodelvissq1=modelvissq1(*,scan)
nmodelvissq2=modelvissq2(*,scan)
nmodelvissq3=modelvissq3(*,scan)
nmodelamp=modelamp(*,scan)
nmodelphas=modelphas(*,scan)
endelse
;
index=where(nviserr1 gt 0)
nuvrad=sqrt(nu1(index)*nu1(index)+nv1(index)*nv1(index))
nmv=nmodelvissq1(index)
plot,_EXTRA=e,$
;title=plottitle,$
nuvrad,nmv,/nodata
oplot,_EXTRA=e,nuvrad,nmv,psym=0,color=color
;
index=where(nviserr2 gt 0)
nuvrad=sqrt(nu2(index)*nu2(index)+nv2(index)*nv2(index))
nmv=nmodelvissq2(index)
oplot,_EXTRA=e,nuvrad,nmv,psym=0,color=color
;
index=where(nviserr3 gt 0,count)
if count gt 0 then begin
nuvrad=sqrt(nu3(index)*nu3(index)+nv3(index)*nv3(index))
nmv=nmodelvissq3(index)
oplot,_EXTRA=e,nuvrad,nmv,psym=0,color=color
endif
;
end
