pro plot_pha,_EXTRA=e,scan=scan,color=color
;
@common_vars.wave
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,$
       viserr1,viserr2,viserr3,amp,amperr,phas,phaserr
common mysys,starname,chaname
common SysConfig,Date,SystemId,MetroConfig,GeoParms,GenConfig,GeoInfo,GenInfo
;
if n_elements(color) eq 0 then color=1
if (n_elements(scan) eq 0) then begin
plottitle=starname+', '+Date
endif else begin
plottitle=starname+', '+Date+', '+string(scan,format='(I2)')
endelse
;
if (n_elements(scan) eq 0) then begin
nphas=phas
nphaserr=phaserr
endif else begin
nphas=phas(*,scan)
nphaserr=phaserr(*,scan)
endelse
;
index=where(nphaserr gt 0)
plot,_EXTRA=e,xtitle='Wavelength [nm]',ytitle=TriplePhasetitle,$
;title=plottitle,$
wavele(index)/1e-9,nphas(index),/nodata
oploterr,wavele(index)/1e-9,nphas(index),nphaserr(index)
;
end
