pro plot_vis_uvrad,_EXTRA=e,scan=scan,color=color,errormax=errormax
;
@common_vars.wave
common mydata,channel,wavele,u1,v1,u2,v2,u3,v3,vissq1,vissq2,vissq3,$
       viserr1,viserr2,viserr3,amp,amperr,phas,phaserr
common mysys,starname,chaname
common SysConfig,Date,SystemId,MetroConfig,GeoParms,GenConfig,GeoInfo,GenInfo
;
if n_elements(errormax) eq 0 then errormax=10
if n_elements(color) eq 0 then color=1
if (n_elements(scan) eq 0) then begin
plottitle=starname+', '+Date
endif else begin
plottitle=starname+', '+Date+', '+string(scan,format='(I2)')
endelse
;
if (n_elements(scan) eq 0) then begin
nu1=u1
nu2=u2
nu3=u3
nv1=v1
nv2=v2
nv3=v3
nvissq1=vissq1
nvissq2=vissq2
nvissq3=vissq3
nviserr1=viserr1
nviserr2=viserr2
nviserr3=viserr3
namp=amp
namperr=amperr
nphas=phas
nphaserr=phaserr
;
endif else begin
nu1=u1(*,scan)
nu2=u2(*,scan)
nu3=u3(*,scan)
nv1=v1(*,scan)
nv2=v2(*,scan)
nv3=v3(*,scan)
nvissq1=vissq1(*,scan)
nvissq2=vissq2(*,scan)
nvissq3=vissq3(*,scan)
nviserr1=viserr1(*,scan)
nviserr2=viserr2(*,scan)
nviserr3=viserr3(*,scan)
namp=amp(*,scan)
namperr=amperr(*,scan)
nphas=phas(*,scan)
nphaserr=phaserr(*,scan)
;
endelse
;
nuvrad1=sqrt(nu1*nu1+nv1*nv1)
nuvrad2=sqrt(nu2*nu2+nv2*nv2)
nuvrad3=sqrt(nu3*nu3+nv3*nv3)
;
index1=where(nviserr1 gt 0 and nviserr1 lt errormax,count)
plot,_EXTRA=e,$
nuvrad1,nvissq1,/nodata,$
xtitle='!8uv!X-Radius [cycles/arcsec]',ytitle=powerspectrumtitle
;title=plottitle
if count gt 0 then oploterr,nuvrad1(index1),nvissq1(index1),nviserr1(index1)
;
index2=where(nviserr2 gt 0 and nviserr2 lt errormax,count)
if count gt 0 then oploterr,nuvrad2(index2),nvissq2(index2),nviserr2(index2)
;
index3=where(nviserr3 gt 0 and nviserr3 lt errormax,count)
if count gt 0 then oploterr,nuvrad3(index3),nvissq3(index3),nviserr3(index3)
end
