pro plotbias
set_plot,'ps'
;
;!P.Position=[0.22,0.22,0.96,0.96]
!P.Charsize=1.1
!X.charsize=1.1
!Y.charsize=1.1
!P.Thick=2
!P.Ticklen=0.02
!X.Thick=3
!Y.Thick=3
!X.Style=1
!Y.Style=1
;
device,xsize=10,ysize=10
;
common Tables,scantable,bgtable,stationtable
common SysConfig,Date,SystemId,MetroConfig,GeoParms,GenConfig,GeoInfo,GenInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common mybias,coeffa0,coeffa1,coeffb0,coeffa0sig,coeffa1sig,coeffb0sig,coeffchisq,coeffchisq2
;
for i=0,GenConfig.NumOutBeam-1 do begin
for j=0,GenConfig.NumSpecChan(i)-1 do begin
      device,filename=string(i,format='(I2.2)')+string(j,format='(I2.2)')+$
      '.ps'
      plottitle='Baseline'+string(i+1,format='(I2)')+$
       ', Channel'+string(j+1,format='(I2)')
      index=where(scans(*).vissqerr(i,j,0) gt 0,count)
      if count gt 1 then begin
       xx=scans(index).photonrate(i,j)
       yy=scans(index).vissq(i,j,0)
       ee=scans(index).vissqerr(i,j,0)
       plot,xx,yy,/xlog,/ylog,xstyle=2,ystyle=2,$
;       plot,xx,yy,xstyle=2,ystyle=2,$
        xtitle='Photonrate',ytitle='Vissq',title=plottitle,/nodata
       oploterr,xx,yy,ee
       xval=findgen(200)+1
       yval=coeffa0(i,j)*xval^coeffa1(i,j)
       oplot,xval,yval,psym=0
       yval2=coeffb0(i,j)/xval
       oplot,xval,yval2,psym=0,linestyle=2
;       yval3=genconfig.bias(j,i)/xval
;       oplot,xval,yval3,psym=0,linestyle=3
       ttt1='a0='+string(coeffa0(i,j),format='(f5.2)')
       ttt2='a1='+string(coeffa1(i,j),format='(f5.2)')
       ttt3='!4v!X!U2!N='+string(coeffchisq(i,j),format='(e8.2)')
       ttt4='b='+string(coeffb0(i,j),format='(f5.3)')
       ttt5='!4v!X!U2!N='+string(coeffchisq2(i,j),format='(e8.2)')
       xyouts,2700,3300,ttt1,/device,charsize=1.5
       xyouts,2700,2600,ttt2,/device,charsize=1.5
       xyouts,2700,1900,ttt3,/device,charsize=1.5
       xyouts,5500,8300,ttt4,/device,charsize=1.5
       xyouts,5500,7600,ttt5,/device,charsize=1.5
       device,/close
      endif
endfor
endfor
set_plot,'X'
end
