;-------------------------------------------------------------------------------
pro coherence,beam,channels,parms
;
common RawData,TimeStamp,BinCounts,NatCounts,LaserPos,GeoPos,SoftDelay
common SysConfig,Date,SystemId,MetroConfig,GeoParms,GenConfig,GeoInfo,GenInfo
;
if n_elements(beam) eq 0 then begin
        print,'***Error(RATEHIST): Please specify beam!'
        return
endif else ob=beam(0)-1
;
baseline=genconfig.baselineid(ob)
i1=where(genconfig.stationid eq strmid(baseline,0,3)) & i1=i1(0)
i2=where(genconfig.stationid eq strmid(baseline,4,3)) & i2=i2(0)
ibr=genconfig.refstation-1
d1=laserpos(i1,*)+laserpos(ibr,*)*(i1 ne ibr)
d2=laserpos(i2,*)+laserpos(ibr,*)*(i2 ne ibr)
d=reform(d1-d2) &d1=0 & d2=0
strokes=[0,900d-9,1800d-9]
y=timejitter(timestamp,d,strokes(i1)-strokes(i2))
x=double(nint(timestamp))
d=perires(x,y,86400000)
;
if n_elements(channels) eq 0 then ch=indgen(GenConfig.NumSpecChan(ob))  $
                             else ch=channels-1
l=genconfig.wavelength(ch)
nch=n_elements(ch)
if nch gt 4 then begin
        !p.charsize=1.5
        mf=2
endif else begin
        !p.charsize=1.0
        mf=1
endelse
;
; Set number of plots
ny=nint(sqrt(nch))
nx=nint((float(nch)/ny)+0.4999)
!p.multi=[0,nx,ny]
tek_color
!p.color=1
!x.title='t [ms]'
!y.title='Squared visibility'
;
k=[1,2,3,4,6,8,10,15,20,25]
num=n_elements(k)
dt=fltarr(num)
v2=fltarr(num)
parms=fltarr(3,nch)
a=[0.4,4.0]
;
for j=0,nch-1 do begin
for i=1,num do begin
        dt(i-1)=k(i-1)*genconfig.instrcohint
;v=add(visrotate(fringevis(bincounts(ob,*,ch(j),*)),l(j),-d),k(i-1))
;n=add(fringenphot(bincounts(ob,*,ch(j),*)),k(i-1))
;m=add(fringemphot(bincounts(ob,*,ch(j),*)),k(i-1))
        c=coaddframe(bincounts(ob,*,ch(j),*),k(i-1))
        v=fringevis(c)
        n=fringenphot(c)
        m=fringemphot(c)
        v2(i-1)=4.2*avg(abs(v)^2-m^2)/avg(n)^2
endfor
plot,dt,v2,psym=1,/xlog,/ylog,yrange=[0.01,1], $
        title='ob '+string(beam,format='(i1)') $
             +', ch '+string(ch(j)+1,format='(i2)')
if v2(0) gt 0.1 then begin
a(0)=v2(0)
v2fit=curvefit(dt,v2,v2*0+1,a,function_name='funct_coherence',/noderivat)
b=[a,v2(0)/a(0)]
parms(*,j)=b
x=dindgen(100)+1
oplot,x,b(0)*corrloss(x/b(1)),psym=0
xyouts,1.5,0.03,'t0 = '+string(b(1),format='(f4.1)'),charsize=!p.charsize/mf
xyouts,1.5,0.02,'C0 = '+string(b(0),format='(f4.2)'),charsize=!p.charsize/mf
xyouts,1.5,0.013,'Loss = '+string(b(2),format='(f4.2)'),charsize=!p.charsize/mf
endif
endfor
;
end
;-----------------------------------------------------------------------------
