pro write_triple
;
common SysConfig,Date,SystemId,MetroConfig,GeoParms,GenConfig,GeoInfo,GenInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
; loop over channels
;
for i=0,14 do begin
;
;open file
;
filename=string('list',i)
openw,u,filename,/get_lun
;
; loop over scans
;
num=n_elements(scantable)-1
sc=0
for j=0,num do begin
;
if scans(j).starid eq 'BSC7751' then begin
sc=sc+1
;
wavele=genconfig.wavelength(i,0)
u1=scans(j).uvw(0,i,0,0)/206264.8
v1=scans(j).uvw(0,i,0,1)/206264.8
u2=scans(j).uvw(1,i,0,0)/206264.8
v2=scans(j).uvw(1,i,0,1)/206264.8
u3=scans(j).uvw(2,i,0,0)/206264.8
v3=scans(j).uvw(2,i,0,1)/206264.8
visisq1=scans(j).vissqc(0,i,0)
visisq2=scans(j).vissqc(1,i,0)
visisq3=scans(j).vissqc(2,i,0)
viserr1=scans(j).vissqcerr(0,i,0)
viserr2=scans(j).vissqcerr(1,i,0)
viserr3=scans(j).vissqcerr(2,i,0)
amp    =scans(j).tripleampc(0,i)
amperr =scans(j).tripleampcerr(0,i)
phas   =scans(j).triplephasec(0,i)
phaserr=scans(j).triplephasecerr(0,i)
;
printf,u,sc,wavele,u1,v1,u2,v2,u3,v3,visisq1,viserr1,visisq2,viserr2,$
       visisq3,viserr3,amp,amperr,phas,phaserr,format='(i,e16.8,16(f16.8,1x))'
;
endif  ; object?
endfor ; j scans
close,u
free_lun,u
endfor        ; i channels
end
