function eraAf2a,s,ideg,iamin,asec,rad


;int eraAf2a(char s, int ideg, int iamin, double asec, double *rad)
;/*
;**  - - - - - - - -
;**   e r a A f 2 a
;**  - - - - - - - -
;**
;**  Convert degrees, arcminutes, arcseconds to radians.
;**
;**  Given:
;**     s         char    sign:  '-' = negative, otherwise positive
;**     ideg      int     degrees
;**     iamin     int     arcminutes
;**     asec      double  arcseconds
;**
;**  Returned:
;**     rad       double  angle in radians
;**
;**  Returned (function value):
;**               int     status:  0 = OK
;**                                1 = ideg outside range 0-359
;**                                2 = iamin outside range 0-59
;**                                3 = asec outside range 0-59.999...
;**
;**  Notes:
;**
;**  1)  The result is computed even if any of the range checks fail.
;**
;**  2)  Negative ideg, iamin and/or asec produce a warning status, but
;**      the absolute value is used in the conversion.
;**
;**  3)  If there are multiple errors, the status value reflects only the
;**      first, the smallest taking precedence.
;**
;**  Copyright (C) 2013-2015, NumFOCUS Foundation.
;**  Derived, with permission, from the SOFA library.  See notes at end of file.
;*/

@erfam
;/* Compute the interval. */
if  s eq '-' then sign = -1.0d else sign= 1.0d 
rad  = sign *  $
( 60.0d * ( 60.0d * ( abs(ideg) ) + $
( abs(iamin) ) ) +  $
abs(asec) ) * ERFA_DAS2R;

;/* Validate arguments and return status. */
if ( ideg lt 0 || ideg gt 359 ) then return, 1;
if ( iamin lt 0 || iamin gt 59 ) then return, 2;
if ( asec lt 0.0 || asec ge 60.0 ) then return, 3;
return, 0;


;/*----------------------------------------------------------------------

end