function eraAnp,a

;  double eraAnp(double a)
;  /*
;  **  - - - - - - -
;  **   e r a A n p
;  **  - - - - - - -
;  **
;  **  Normalize angle into the range 0 <= a < 2pi.
;  **
;  **  Given:
;  **     a        double     angle (radians)
;  **
;  **  Returned (function value):
;  **              double     angle in range 0-2pi
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
 w=0d;
 
 ;/* 2Pi */
; ERFA_D2PI=6.283185307179586476925287d
  @erfam
  w = (a mod ERFA_D2PI);
  if (w lt 0d) then w += ERFA_D2PI;
  
  return, w;
  

;/*----------------------------------------------------------------------



end