pro eraBp00,date1,date2,rb,rp,rbp

;void eraBp00(double date1, double date2,
;             double rb[3][3], double rp[3][3], double rbp[3][3])
;/*
;**  - - - - - - - -
;**   e r a B p 0 0
;**  - - - - - - - -
;**
;**  Frame bias and precession, IAU 2000.
;**
;**  Given:
;**     date1,date2  double         TT as a 2-part Julian Date (Note 1)
;**
;**  Returned:
;**     rb           double[3][3]   frame bias matrix (Note 2)
;**     rp           double[3][3]   precession matrix (Note 3)
;**     rbp          double[3][3]   bias-precession matrix (Note 4)
;**
;**  Notes:
;**
;**  1) The TT date date1+date2 is a Julian Date, apportioned in any
;**     convenient way between the two arguments.  For example,
;**     JD(TT)=2450123.7 could be expressed in any of these ways,
;**     among others:
;**
;**             date1         date2
;**
;**         2450123.7           0.0       (JD method)
;**         2451545.0       -1421.3       (J2000 method)
;**         2400000.5       50123.2       (MJD method)
;**         2450123.5           0.2       (date & time method)
;**
;**     The JD method is the most natural and convenient to use in
;**     cases where the loss of several decimal digits of resolution
;**     is acceptable.  The J2000 method is best matched to the way
;**     the argument is handled internally and will deliver the
;**     optimum resolution.  The MJD method and the date & time methods
;**     are both good compromises between resolution and convenience.
;**
;**  2) The matrix rb transforms vectors from GCRS to mean J2000.0 by
;**     applying frame bias.
;**
;**  3) The matrix rp transforms vectors from J2000.0 mean equator and
;**     equinox to mean equator and equinox of date by applying
;**     precession.
;**
;**  4) The matrix rbp transforms vectors from GCRS to mean equator and
;**     equinox of date by applying frame bias then precession.  It is
;**     the product rp x rb.
;**
;**  5) It is permissible to re-use the same array in the returned
;**     arguments.  The arrays are filled in the order given.
;**
;**  Called:
;**     eraBi00      frame bias components, IAU 2000
;**     eraPr00      IAU 2000 precession adjustments
;**     eraIr        initialize r-matrix to identity
;**     eraRx        rotate around X-axis
;**     eraRy        rotate around Y-axis
;**     eraRz        rotate around Z-axis
;**     eraCr        copy r-matrix
;**     eraRxr       product of two r-matrices
;**
;**  Reference:
;**     "Expressions for the Celestial Intermediate Pole and Celestial
;**     Ephemeris Origin consistent with the IAU 2000A precession-
;**     nutation model", Astron.Astrophys. 400, 1145-1154 (2003)
;**
;**     n.b. The celestial ephemeris origin (CEO) was renamed "celestial
;**          intermediate origin" (CIO) by IAU 2006 Resolution 2.
;**
;**  Copyright (C) 2013-2015, NumFOCUS Foundation.
;**  Derived, with permission, from the SOFA library.  See notes at end of file.
;*/
@erfam
;/* J2000.0 obliquity (Lieske et al. 1977) */
  EPS0 = 84381.448d * ERFA_DAS2R;

 t=0d & dpsibi=0d & depsbi=0d & dra0=0d & psia77=0d & oma77=0d & chia=0d
          dpsipr=0d & depspr=0d & psia=0d & oma=0d & rbw=dblarr(3,3);

;/* Interval between fundamental epoch J2000.0 and current date (JC). */
   t = ((date1 - ERFA_DJ00) + date2) / ERFA_DJC;

;/* Frame bias. */
   eraBi00,dpsibi, depsbi, dra0;

;/* Precession angles (Lieske et al. 1977) */
   psia77 = (5038.7784d + (-1.07259d + (-0.001147d) * t) * t) * t * ERFA_DAS2R;
   oma77  =       EPS0 + ((0.05127d + (-0.007726d) * t) * t) * t * ERFA_DAS2R;
   chia   = (  10.5526d + (-2.38064d + (-0.001125d) * t) * t) * t * ERFA_DAS2R;

;/* Apply IAU 2000 precession corrections. */
   eraPr00,date1, date2, dpsipr, depspr;
   psia = psia77 + dpsipr;
   oma  = oma77  + depspr;

;/* Frame bias matrix: GCRS to J2000.0. */
   eraIr,rbw;
   eraRz,dra0, rbw;
   eraRy,dpsibi*sin(EPS0), rbw;
   eraRx,-depsbi, rbw;
   eraCr,rbw, rb;

;/* Precession matrix: J2000.0 to mean of date. */
   eraIr,rp;
   eraRx,EPS0, rp;
   eraRz,-psia, rp;
   eraRx,-oma, rp;
   eraRz,chia, rp;

;/* Bias-precession matrix: GCRS to mean of date. */
   eraRxr,rp, rbw, rbp;

   


;/*----------------------------------------------------------------------

end