pro eraC2s,p,theta,phi


;  void eraC2s(double p[3], double *theta, double *phi)
;  /*
;  **  - - - - - - -
;  **   e r a C 2 s
;  **  - - - - - - -
;  **
;  **  P-vector to spherical coordinates.
;  **
;  **  Given:
;  **     p      double[3]    p-vector
;  **
;  **  Returned:
;  **     theta  double       longitude angle (radians)
;  **     phi    double       latitude angle (radians)
;  **
;  **  Notes:
;  **
;  **  1) The vector p can have any magnitude; only its direction is used.
;  **
;  **  2) If p is null, zero theta and phi are returned.
;  **
;  **  3) At either pole, zero theta is returned.
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  x=0d & y=0d & z=0d & d2=0d;
  
  x  = p[0];
  y  = p[1];
  z  = p[2];
  d2 = x*x + y*y;
  if d2 eq 0.0d then begin
    theta = 0.0d
  endif else begin
    theta =atan(y, x)
  endelse
 
  if z eq 0.0d then begin
    phi= 0.0d 
  endif else begin
    phi = atan(z, sqrt(d2))
  endelse
  
  

;/*----------------------------------------------------------------------




end