function eraCal2jd,iy,im,id,djm0,djm

;  int eraCal2jd(int iy, int im, int id, double *djm0, double *djm)
;  /*
;  **  - - - - - - - - - -
;  **   e r a C a l 2 j d
;  **  - - - - - - - - - -
;  **
;  **  Gregorian Calendar to Julian Date.
;  **
;  **  Given:
;  **     iy,im,id  int     year, month, day in Gregorian calendar (Note 1)
;  **
;  **  Returned:
;  **     djm0      double  MJD zero-point: always 2400000.5
;  **     djm       double  Modified Julian Date for 0 hrs
;  **
;  **  Returned (function value):
;  **               int     status:
;  **                           0 = OK
;  **                          -1 = bad year   (Note 3: JD not computed)
;  **                          -2 = bad month  (JD not computed)
;  **                          -3 = bad day    (JD computed)
;  **
;  **  Notes:
;  **
;  **  1) The algorithm used is valid from -4800 March 1, but this
;  **     implementation rejects dates before -4799 January 1.
;  **
;  **  2) The Julian Date is returned in two pieces, in the usual ERFA
;  **     manner, which is designed to preserve time resolution.  The
;  **     Julian Date is available as a single number by adding djm0 and
;  **     djm.
;  **
;  **  3) In early eras the conversion is from the "Proleptic Gregorian
;  **     Calendar";  no account is taken of the date(s) of adoption of
;  **     the Gregorian Calendar, nor is the AD/BC numbering convention
;  **     observed.
;  **
;  **  Reference:
;  **
;  **     Explanatory Supplement to the Astronomical Almanac,
;  **     P. Kenneth Seidelmann (ed), University Science Books (1992),
;  **     Section 12.92 (p604).
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  j=0 & ly=0 & my=0;
   iypmy=0l;
  
;  /* Earliest year allowed (4800BC) */
 IYMIN = -4799l;
;/* Julian Date of Modified Julian Date zero */
ERFA_DJM0=2400000.5d
@erfam
;  /* Month lengths in days */
mtab= [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  
;  /* Preset status. */
  j = 0;
  
;  /* Validate year and month. */
  if (iy lt IYMIN) then return, -1;
  if (im lt 1 or im gt 12) then return, -2;
  
;  /* If February in a leap year, 1, otherwise 0. */
  ly = ((im eq 2) && ~(iy mod 4) && (iy mod 100 || ~(iy mod 400)));
  
;  /* Validate day, taking into account leap years. */
  if ( (id lt 1) || (id gt (mtab[im-1] + ly))) then j = -3;
  
;  /* Return result. */
  my = (im - 14) / 12;
  iypmy = long(iy + my);
  djm0 = ERFA_DJM0;
  djm = double((1461L * (iypmy + 4800L)) / 4L $
  + (367L * long(im - 2 - 12 * my)) / 12L $
  - (3L * ((iypmy + 4900L) / 100L)) / 4L $
  + long(id) - 2432076L);
 
  ;/* Return status. */
  return, j;
  

;/*----------------------------------------------------------------------



end