pro eraD2tf,ndp,days,sign,ihmsf

;  void eraD2tf(int ndp, double days, char *sign, int ihmsf[4])
;  /*
;  **  - - - - - - - -
;  **   e r a D 2 t f
;  **  - - - - - - - -
;  **
;  **  Decompose days to hours, minutes, seconds, fraction.
;  **
;  **  Given:
;  **     ndp     int     resolution (Note 1)
;  **     days    double  interval in days
;  **
;  **  Returned:
;  **     sign    char    '+' or '-'
;  **     ihmsf   int[4]  hours, minutes, seconds, fraction
;  **
;  **  Notes:
;  **
;  **  1) The argument ndp is interpreted as follows:
;  **
;  **     ndp         resolution
;  **      :      ...0000 00 00
;  **     -7         1000 00 00
;  **     -6          100 00 00
;  **     -5           10 00 00
;  **     -4            1 00 00
;  **     -3            0 10 00
;  **     -2            0 01 00
;  **     -1            0 00 10
;  **      0            0 00 01
;  **      1            0 00 00.1
;  **      2            0 00 00.01
;  **      3            0 00 00.001
;  **      :            0 00 00.000...
;  **
;  **  2) The largest positive useful value for ndp is determined by the
;  **     size of days, the format of double on the target platform, and
;  **     the risk of overflowing ihmsf[3].  On a typical platform, for
;  **     days up to 1.0, the available floating-point precision might
;  **     correspond to ndp=12.  However, the practical limit is typically
;  **     ndp=9, set by the capacity of a 32-bit int, or ndp=4 if int is
;  **     only 16 bits.
;  **
;  **  3) The absolute value of days may exceed 1.0.  In cases where it
;  **     does not, it is up to the caller to test for and handle the
;  **     case where days is very nearly 1.0 and rounds up to 24 hours,
;  **     by testing for ihmsf[0]=24 and setting ihmsf[0-3] to zero.
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
 nrs=0l & n=0l;
  rs=0d & rm=0d & rh=0d & a=0d & w=0d & ah=0d & am=0d & as=0d & af=0d;
@erfam  
;  /* Handle sign. */
if ( days ge 0.0d ) then begin 
  sign='+'
endif  else begin
 sign = '-'
endelse  
  

  
;  /* Interval in seconds. */
  a = ERFA_DAYSEC * abs(days);
  
;  /* Pre-round if resolution coarser than 1s (then pretend ndp=1). */
  if (ndp lt 0) then begin;{
  nrs = 1l;
  for n = 1l,-ndp do begin; n <= -ndp; n++) {
    if (n eq 2 || n eq 4) then begin
      nrs *=  6l 
    endif else begin      
     nrs *=  10l;
  endelse
endfor
rs = double(nrs);
w = a / rs;
a = rs * ERFA_DNINT(w);
endif

;/* Express the unit of each field in resolution units. */
nrs = 1l;
for n = 1l,ndp do begin; n <= ndp; n++) {
nrs *= 10l;
endfor
rs = double(nrs);
rm = rs * 60.0d;
rh = rm * 60.0d;

;/* Round the interval and express in resolution units. */
a = ERFA_DNINT(rs * a);

;/* Break into fields. */
ah = a / rh;
ah = ERFA_DINT(ah);
a -= ah * rh;
am = a / rm;
am = ERFA_DINT(am);
a -= am * rm;
as = a / rs;
as = ERFA_DINT(as);
af = a - as * rs;

;/* Return results. */
ihmsf[0] = long(ah);
ihmsf[1] = long(am);
ihmsf[2] = long(as);
ihmsf[3] = long(af);


;/*----------------------------------------------------------------------


end