function eraDtf2d,scale,iy,im,id,ihr, imn,sec,d1,d2


;  int eraDtf2d(const char *scale, int iy, int im, int id,
;  int ihr, int imn, double sec, double *d1, double *d2)
;  /*
;  **  - - - - - - - - -
;  **   e r a D t f 2 d
;  **  - - - - - - - - -
;  **
;  **  Encode date and time fields into 2-part Julian Date (or in the case
;  **  of UTC a quasi-JD form that includes special provision for leap
;  **  seconds).
;  **
;  **  Given:
;  **     scale     char[]  time scale ID (Note 1)
;  **     iy,im,id  int     year, month, day in Gregorian calendar (Note 2)
;  **     ihr,imn   int     hour, minute
;  **     sec       double  seconds
;  **
;  **  Returned:
;  **     d1,d2     double  2-part Julian Date (Notes 3,4)
;  **
;  **  Returned (function value):
;  **               int     status: +3 = both of next two
;  **                               +2 = time is after end of day (Note 5)
;  **                               +1 = dubious year (Note 6)
;  **                                0 = OK
;  **                               -1 = bad year
;  **                               -2 = bad month
;  **                               -3 = bad day
;  **                               -4 = bad hour
;  **                               -5 = bad minute
;  **                               -6 = bad second (<0)
;  **
;  **  Notes:
;  **
;  **  1) scale identifies the time scale.  Only the value "UTC" (in upper
;  **     case) is significant, and enables handling of leap seconds (see
;  **     Note 4).
;  **
;  **  2) For calendar conventions and limitations, see eraCal2jd.
;  **
;  **  3) The sum of the results, d1+d2, is Julian Date, where normally d1
;  **     is the Julian Day Number and d2 is the fraction of a day.  In the
;  **     case of UTC, where the use of JD is problematical, special
;  **     conventions apply:  see the next note.
;  **
;  **  4) JD cannot unambiguously represent UTC during a leap second unless
;  **     special measures are taken.  The ERFA internal convention is that
;  **     the quasi-JD day represents UTC days whether the length is 86399,
;  **     86400 or 86401 SI seconds.  In the 1960-1972 era there were
;  **     smaller jumps (in either direction) each time the linear UTC(TAI)
;  **     expression was changed, and these "mini-leaps" are also included
;  **     in the ERFA convention.
;  **
;  **  5) The warning status "time is after end of day" usually means that
;  **     the sec argument is greater than 60.0.  However, in a day ending
;  **     in a leap second the limit changes to 61.0 (or 59.0 in the case
;  **     of a negative leap second).
;  **
;  **  6) The warning status "dubious year" flags UTCs that predate the
;  **     introduction of the time scale or that are too far in the future
;  **     to be trusted.  See eraDat for further details.
;  **
;  **  7) Only in the case of continuous and regular time scales (TAI, TT,
;  **     TCG, TCB and TDB) is the result d1+d2 a Julian Date, strictly
;  **     speaking.  In the other cases (UT1 and UTC) the result must be
;  **     used with circumspection;  in particular the difference between
;  **     two such results cannot be interpreted as a precise time
;  **     interval.
;  **
;  **  Called:
;  **     eraCal2jd    Gregorian calendar to JD
;  **     eraDat       delta(AT) = TAI-UTC
;  **     eraJd2cal    JD to Gregorian calendar
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  js=0d & iy2=0 & im2=0 & id2=0;
  dj=0d & w=0d & day=0d & seclim=0d & dat0=0d & dat12=0d & dat24=0d & dleap=0d & time=0d;
@erfam  
 ; /* Today's Julian Day Number. */
  js = eraCal2jd(iy, im, id, dj, w);
  if ( js ) then return, js;
  dj += w;
  
;  /* Day length and final minute length in seconds (provisional). */
  day = ERFA_DAYSEC;
  seclim = 60.0d;
  
;  /* Deal with the UTC leap second case. */
;note: idl strcmp reports 1 if str1=str2; in C++ strcmp reports 0 in the same case
  if ( strcmp(scale,"UTC") ) then begin
  
;  /* TAI-UTC at 0h today. */
  js = eraDat(iy, im, id, 0.0d, dat0);
  if ( js lt 0 ) then return, js;
  
;  /* TAI-UTC at 12h today (to detect drift). */
  js = eraDat(iy, im, id, 0.5d, dat12);
  if ( js lt 0 ) then return, js;
  
;  /* TAI-UTC at 0h tomorrow (to detect jumps). */
  js = eraJd2cal ( dj, 1.5d, iy2, im2, id2, w);
  if ( js ) then return, js;
  js = eraDat(iy2, im2, id2, 0.0d, dat24);
  if ( js lt 0 ) then return, js;
  
;  /* Any sudden change in TAI-UTC between today and tomorrow. */
  dleap = dat24 - (2.0d*dat12 - dat0);
  
;  /* If leap second day, correct the day and final minute lengths. */
  day += dleap;
  if ( ihr eq 23 && imn eq 59 ) then seclim += dleap;
  
;  /* End of UTC-specific actions. */
endif

;/* Validate the time. */
if ( ihr ge 0 && ihr le 23 ) then begin; {
if ( imn ge 0 && imn le 59 ) then begin;{
if ( sec ge 0 ) then begin;{
if ( sec ge seclim ) then begin;{
js += 2;
endif
endif else begin;{
js = -6;
endelse
endif else begin;{
js = -5;
endelse
endif else begin;{
js = -4;
endelse
if ( js lt 0 ) then return, js;

;/* The time in days. */
time  = ( 60.0d * (  ( 60d * ihr + imn ) ) + sec ) / day;

;/* Return the date and time. */
d1 = dj;
d2 = time;

;/* Status. */
return, js;


;/*----------------------------------------------------------------------

end