function eraEors,rnpb,s 


;  double eraEors(double rnpb[3][3], double s)
;  /*
;  **  - - - - - - - -
;  **   e r a E o r s
;  **  - - - - - - - -
;  **
;  **  Equation of the origins, given the classical NPB matrix and the
;  **  quantity s.
;  **
;  **  Given:
;  **     rnpb  double[3][3]  classical nutation x precession x bias matrix
;  **     s     double        the quantity s (the CIO locator)
;  **
;  **  Returned (function value):
;  **           double        the equation of the origins in radians.
;  **
;  **  Notes:
;  **
;  **  1)  The equation of the origins is the distance between the true
;  **      equinox and the celestial intermediate origin and, equivalently,
;  **      the difference between Earth rotation angle and Greenwich
;  **      apparent sidereal time (ERA-GST).  It comprises the precession
;  **      (since J2000.0) in right ascension plus the equation of the
;  **      equinoxes (including the small correction terms).
;  **
;  **  2)  The algorithm is from Wallace & Capitaine (2006).
;  **
;  ** References:
;  **
;  **     Capitaine, N. & Wallace, P.T., 2006, Astron.Astrophys. 450, 855
;  **
;  **     Wallace, P. & Capitaine, N., 2006, Astron.Astrophys. 459, 981
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
   x=0d & ax=0d & xs=0d & ys=0d & zs=0d & p=0d & q=0d & eo=0d;
  
;  /* Evaluate Wallace & Capitaine (2006) expression (16). */
  x = rnpb[2,0];
  ax = x / (1.0d + rnpb[2,2]);
  xs = 1.0d - ax * x;
  ys = -ax * rnpb[2,1];
  zs = -x;
  p = rnpb[0,0] * xs + rnpb[0,1] * ys + rnpb[0,2] * zs;
  q = rnpb[1,0] * xs + rnpb[1,1] * ys + rnpb[1,2] * zs;
  if ((p ne 0) || (q ne 0)) then begin
    eo = s - atan(q, p)
  endif else begin
    eo=s
  endelse
 
  
  return, eo
  

;/*----------------------------------------------------------------------


end