function eraFal03,t


;  double eraFal03(double t)
;  /*
;  **  - - - - - - - - -
;  **   e r a F a l 0 3
;  **  - - - - - - - - -
;  **
;  **  Fundamental argument, IERS Conventions (2003):
;  **  mean anomaly of the Moon.
;  **
;  **  Given:
;  **     t     double    TDB, Julian centuries since J2000.0 (Note 1)
;  **
;  **  Returned (function value):
;  **           double    l, radians (Note 2)
;  **
;  **  Notes:
;  **
;  **  1) Though t is strictly TDB, it is usually more convenient to use
;  **     TT, which makes no significant difference.
;  **
;  **  2) The expression used is as adopted in IERS Conventions (2003) and
;  **     is from Simon et al. (1994).
;  **
;  **  References:
;  **
;  **     McCarthy, D. D., Petit, G. (eds.), IERS Conventions (2003),
;  **     IERS Technical Note No. 32, BKG (2004)
;  **
;  **     Simon, J.-L., Bretagnon, P., Chapront, J., Chapront-Touze, M.,
;  **     Francou, G., Laskar, J. 1994, Astron.Astrophys. 282, 663-683
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  a=0d;
  
 @erfam 
;  /* Mean anomaly of the Moon (IERS Conventions 2003). */
  a = (           485868.249036d  +  $
  t * ( 1717915923.2178d +  $
  t * (         31.8792d +  $
  t * (          0.051635d +  $
  t * (        - 0.00024470d ) ) ) ) mod ERFA_TURNAS ) * ERFA_DAS2R;
  
  return, a;
  

;/*----------------------------------------------------------------------



end