function eraFasa03,t

;  double eraFasa03(double t)
;  /*
;  **  - - - - - - - - - -
;  **   e r a F a s a 0 3
;  **  - - - - - - - - - -
;  **
;  **  Fundamental argument, IERS Conventions (2003):
;  **  mean longitude of Saturn.
;  **
;  **  Given:
;  **     t     double    TDB, Julian centuries since J2000.0 (Note 1)
;  **
;  **  Returned (function value):
;  **           double    mean longitude of Saturn, radians (Note 2)
;  **
;  **  Notes:
;  **
;  **  1) Though t is strictly TDB, it is usually more convenient to use
;  **     TT, which makes no significant difference.
;  **
;  **  2) The expression used is as adopted in IERS Conventions (2003) and
;  **     comes from Souchay et al. (1999) after Simon et al. (1994).
;  **
;  **  References:
;  **
;  **     McCarthy, D. D., Petit, G. (eds.), IERS Conventions (2003),
;  **     IERS Technical Note No. 32, BKG (2004)
;  **
;  **     Simon, J.-L., Bretagnon, P., Chapront, J., Chapront-Touze, M.,
;  **     Francou, G., Laskar, J. 1994, Astron.Astrophys. 282, 663-683
;  **
;  **     Souchay, J., Loysel, B., Kinoshita, H., Folgueira, M. 1999,
;  **     Astron.Astrophys.Supp.Ser. 135, 111
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
   a=0d;
  @erfam
;  /* Mean longitude of Saturn (IERS Conventions 2003). */
  a = (0.874016757d + 21.3299104960d * t mod ERFA_D2PI);
  
  return, a;
  

;/*----------------------------------------------------------------------


end