function eraGd2gce,a,f,elong,phi,height,xyz=xyz

;  int eraGd2gce ( double a, double f, double elong, double phi,
;  double height, double xyz[3] )
;  /*
;  **  - - - - - - - - - -
;  **   e r a G d 2 g c e
;  **  - - - - - - - - - -
;  **
;  **  Transform geodetic coordinates to geocentric for a reference
;  **  ellipsoid of specified form.
;  **
;  **  Given:
;  **     a       double     equatorial radius (Notes 1,4)
;  **     f       double     flattening (Notes 2,4)
;  **     elong   double     longitude (radians, east +ve)
;  **     phi     double     latitude (geodetic, radians, Note 4)
;  **     height  double     height above ellipsoid (geodetic, Notes 3,4)
;  **
;  **  Returned:
;  **     xyz     double[3]  geocentric vector (Note 3)
;  **
;  **  Returned (function value):
;  **             int        status:  0 = OK
;  **                                -1 = illegal case (Note 4)
;  **  Notes:
;  **
;  **  1) The equatorial radius, a, can be in any units, but meters is
;  **     the conventional choice.
;  **
;  **  2) The flattening, f, is (for the Earth) a value around 0.00335,
;  **     i.e. around 1/298.
;  **
;  **  3) The equatorial radius, a, and the height, height, must be
;  **     given in the same units, and determine the units of the
;  **     returned geocentric vector, xyz.
;  **
;  **  4) No validation is performed on individual arguments.  The error
;  **     status -1 protects against (unrealistic) cases that would lead
;  **     to arithmetic exceptions.  If an error occurs, xyz is unchanged.
;  **
;  **  5) The inverse transformation is performed in the function
;  **     eraGc2gde.
;  **
;  **  6) The transformation for a standard ellipsoid (such as ERFA_WGS84) can
;  **     more conveniently be performed by calling eraGd2gc,  which uses a
;  **     numerical code to identify the required a and f values.
;  **
;  **  References:
;  **
;  **     Green, R.M., Spherical Astronomy, Cambridge University Press,
;  **     (1985) Section 4.5, p96.
;  **
;  **     Explanatory Supplement to the Astronomical Almanac,
;  **     P. Kenneth Seidelmann (ed), University Science Books (1992),
;  **     Section 4.22, p202.
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  sp=0d & cp=0d & w =0d & d=0d & ac=0d & as=0d & r=0d
  
;  /* Functions of geodetic latitude. */
  sp = sin(phi);
  cp = cos(phi);
  w = 1.0 - f;
  w = w * w;
  d = cp*cp + w*sp*sp;
  if  d le 0.0 then return, -1;
  ac = a / sqrt(d);
  as = w * ac;
  
;  /* Geocentric vector. */
  r = (ac + height) * cp;
  xyz[0] = r * cos(elong);
  xyz[1] = r * sin(elong);
  xyz[2] = (as + height) * sp;
  
;  /* Success. */
  return, 0;
  

;/*----------------------------------------------------------------------


end