pro eraLdsun,p,e,em,p1
; Oliver Pfuhl 2017Mar01: ported erfa C-routines to IDL
;void eraLdsun(double p[3], double e[3], double em, double p1[3])
;/*
;**  - - - - - - - - -
;**   e r a L d s u n
;**  - - - - - - - - -
;**
;**  Deflection of starlight by the Sun.
;**
;**  Given:
;**     p      double[3]  direction from observer to star (unit vector)
;**     e      double[3]  direction from Sun to observer (unit vector)
;**     em     double     distance from Sun to observer (au)
;**
;**  Returned:
;**     p1     double[3]  observer to deflected star (unit vector)
;**
;**  Notes:
;**
;**  1) The source is presumed to be sufficiently distant that its
;**     directions seen from the Sun and the observer are essentially
;**     the same.
;**
;**  2) The deflection is restrained when the angle between the star and
;**     the center of the Sun is less than about 9 arcsec, falling to
;**     zero for zero separation. (The chosen threshold is within the
;**     solar limb for all solar-system applications.)
;**
;**  3) The arguments p and p1 can be the same array.
;**
;**  Called:
;**     eraLd        light deflection by a solar-system body
;**
;**  Copyright (C) 2013-2015, NumFOCUS Foundation.
;**  Derived, with permission, from the SOFA library.  See notes at end of file.
;*/

eraLd,1.0d, p, p, e, em, 1d-9, p1;

;/* Finished. */


;/*----------------------------------------------------------------------

end