pro eraNut00a,date1,date2,dpsi,deps

;  void eraNut00a(double date1, double date2, double *dpsi, double *deps)
;  /*
;  **  - - - - - - - - - -
;  **   e r a N u t 0 0 a
;  **  - - - - - - - - - -
;  **
;  **  Nutation, IAU 2000A model (MHB2000 luni-solar and planetary nutation
;  **  with free core nutation omitted).
;  **
;  **  Given:
;  **     date1,date2   double   TT as a 2-part Julian Date (Note 1)
;  **
;  **  Returned:
;  **     dpsi,deps     double   nutation, luni-solar + planetary (Note 2)
;  **
;  **  Notes:
;  **
;  **  1) The TT date date1+date2 is a Julian Date, apportioned in any
;  **     convenient way between the two arguments.  For example,
;  **     JD(TT)=2450123.7 could be expressed in any of these ways,
;  **     among others:
;  **
;  **            date1          date2
;  **
;  **         2450123.7           0.0       (JD method)
;  **         2451545.0       -1421.3       (J2000 method)
;  **         2400000.5       50123.2       (MJD method)
;  **         2450123.5           0.2       (date & time method)
;  **
;  **     The JD method is the most natural and convenient to use in
;  **     cases where the loss of several decimal digits of resolution
;  **     is acceptable.  The J2000 method is best matched to the way
;  **     the argument is handled internally and will deliver the
;  **     optimum resolution.  The MJD method and the date & time methods
;  **     are both good compromises between resolution and convenience.
;  **
;  **  2) The nutation components in longitude and obliquity are in radians
;  **     and with respect to the equinox and ecliptic of date.  The
;  **     obliquity at J2000.0 is assumed to be the Lieske et al. (1977)
;  **     value of 84381.448 arcsec.
;  **
;  **     Both the luni-solar and planetary nutations are included.  The
;  **     latter are due to direct planetary nutations and the
;  **     perturbations of the lunar and terrestrial orbits.
;  **
;  **  3) The function computes the MHB2000 nutation series with the
;  **     associated corrections for planetary nutations.  It is an
;  **     implementation of the nutation part of the IAU 2000A precession-
;  **     nutation model, formally adopted by the IAU General Assembly in
;  **     2000, namely MHB2000 (Mathews et al. 2002), but with the free
;  **     core nutation (FCN - see Note 4) omitted.
;  **
;  **  4) The full MHB2000 model also contains contributions to the
;  **     nutations in longitude and obliquity due to the free-excitation
;  **     of the free-core-nutation during the period 1979-2000.  These FCN
;  **     terms, which are time-dependent and unpredictable, are NOT
;  **     included in the present function and, if required, must be
;  **     independently computed.  With the FCN corrections included, the
;  **     present function delivers a pole which is at current epochs
;  **     accurate to a few hundred microarcseconds.  The omission of FCN
;  **     introduces further errors of about that size.
;  **
;  **  5) The present function provides classical nutation.  The MHB2000
;  **     algorithm, from which it is adapted, deals also with (i) the
;  **     offsets between the GCRS and mean poles and (ii) the adjustments
;  **     in longitude and obliquity due to the changed precession rates.
;  **     These additional functions, namely frame bias and precession
;  **     adjustments, are supported by the ERFA functions eraBi00  and
;  **     eraPr00.
;  **
;  **  6) The MHB2000 algorithm also provides "total" nutations, comprising
;  **     the arithmetic sum of the frame bias, precession adjustments,
;  **     luni-solar nutation and planetary nutation.  These total
;  **     nutations can be used in combination with an existing IAU 1976
;  **     precession implementation, such as eraPmat76,  to deliver GCRS-
;  **     to-true predictions of sub-mas accuracy at current dates.
;  **     However, there are three shortcomings in the MHB2000 model that
;  **     must be taken into account if more accurate or definitive results
;  **     are required (see Wallace 2002):
;  **
;  **       (i) The MHB2000 total nutations are simply arithmetic sums,
;  **           yet in reality the various components are successive Euler
;  **           rotations.  This slight lack of rigor leads to cross terms
;  **           that exceed 1 mas after a century.  The rigorous procedure
;  **           is to form the GCRS-to-true rotation matrix by applying the
;  **           bias, precession and nutation in that order.
;  **
;  **      (ii) Although the precession adjustments are stated to be with
;  **           respect to Lieske et al. (1977), the MHB2000 model does
;  **           not specify which set of Euler angles are to be used and
;  **           how the adjustments are to be applied.  The most literal
;  **           and straightforward procedure is to adopt the 4-rotation
;  **           epsilon_0, psi_A, omega_A, xi_A option, and to add DPSIPR
;  **           to psi_A and DEPSPR to both omega_A and eps_A.
;  **
;  **     (iii) The MHB2000 model predates the determination by Chapront
;  **           et al. (2002) of a 14.6 mas displacement between the
;  **           J2000.0 mean equinox and the origin of the ICRS frame.  It
;  **           should, however, be noted that neglecting this displacement
;  **           when calculating star coordinates does not lead to a
;  **           14.6 mas change in right ascension, only a small second-
;  **           order distortion in the pattern of the precession-nutation
;  **           effect.
;  **
;  **     For these reasons, the ERFA functions do not generate the "total
;  **     nutations" directly, though they can of course easily be
;  **     generated by calling eraBi00, eraPr00 and the present function
;  **     and adding the results.
;  **
;  **  7) The MHB2000 model contains 41 instances where the same frequency
;  **     appears multiple times, of which 38 are duplicates and three are
;  **     triplicates.  To keep the present code close to the original MHB
;  **     algorithm, this small inefficiency has not been corrected.
;  **
;  **  Called:
;  **     eraFal03     mean anomaly of the Moon
;  **     eraFaf03     mean argument of the latitude of the Moon
;  **     eraFaom03    mean longitude of the Moon's ascending node
;  **     eraFame03    mean longitude of Mercury
;  **     eraFave03    mean longitude of Venus
;  **     eraFae03     mean longitude of Earth
;  **     eraFama03    mean longitude of Mars
;  **     eraFaju03    mean longitude of Jupiter
;  **     eraFasa03    mean longitude of Saturn
;  **     eraFaur03    mean longitude of Uranus
;  **     eraFapa03    general accumulated precession in longitude
;  **
;  **  References:
;  **
;  **     Chapront, J., Chapront-Touze, M. & Francou, G. 2002,
;  **     Astron.Astrophys. 387, 700
;  **
;  **     Lieske, J.H., Lederle, T., Fricke, W. & Morando, B. 1977,
;  **     Astron.Astrophys. 58, 1-16
;  **
;  **     Mathews, P.M., Herring, T.A., Buffet, B.A. 2002, J.Geophys.Res.
;  **     107, B4.  The MHB_2000 code itself was obtained on 9th September
;  **     2002 from ftp//maia.usno.navy.mil/conv2000/chapter5/IAU2000A.
;  **
;  **     Simon, J.-L., Bretagnon, P., Chapront, J., Chapront-Touze, M.,
;  **     Francou, G., Laskar, J. 1994, Astron.Astrophys. 282, 663-683
;  **
;  **     Souchay, J., Loysel, B., Kinoshita, H., Folgueira, M. 1999,
;  **     Astron.Astrophys.Supp.Ser. 135, 111
;  **
;  **     Wallace, P.T., "Software for Implementing the IAU 2000
;  **     Resolutions", in IERS Workshop 5.1 (2002)
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  i=0;
  t=0d & el=0d & elp=0d & f=0d & d=0d & om=0d & arg=0d & dp=0d & de=0d & sarg=0d & carg=0d
  al=0d & af=0d & ad=0d & aom=0d & alme=0d & alve=0d & alea=0d & alma=0d
  alju=0d & alsa=0d & alur=0d & alne=0d & apa =0d & dpsils=0d & depsls=0d
  dpsipl=0d & depspl=0d;
 
 @erfam 
;  /* Units of 0.1 microarcsecond to radians */
  U2R = ERFA_DAS2R / 1d7;
  
;  /* ------------------------- */
;  /* Luni-Solar nutation model */
;  /* ------------------------- */
  
;  /* The units for the sine and cosine coefficients are */
;  /* 0.1 microarcsecond and the same per Julian century */
  
;  static const struct {
;  int nl,nlp,nf,nd,nom; /* coefficients of l,l',F,D,Om */
;  double sp,spt,cp;     /* longitude sin, t*sin, cos coefficients */
;  double ce,cet,se;     /* obliquity cos, t*cos, sin coefficients */
;} xls[] = {
term0={nl:0,nlp:0,nf:0,nd:0,nom:0,  $; /* coefficients of l,l',F,D,Om */
  sp:0d,spt:0d,cp:0d,  $   ;/* longitude sin, t*sin, cos coefficients */
  ce:0d,cet:0d,se:0d}


xls=replicate(term0,678) 


xls_m = [  $
;/* 1- 10 */
[ 0, 0, 0, 0, 1,  $
-172064161.0d, -174666.0d, 33386.0d, 92052331.0d, 9086.0d, 15377.0d], $
[ 0, 0, 2,-2, 2,  $
-13170906.0d, -1675.0d, -13696.0d, 5730336.0d, -3015.0d, -4587.0d], $
[ 0, 0, 2, 0, 2,-2276413.0d,-234.0d,2796.0d,978459.0d,-485.0d, 1374.0d], $
[ 0, 0, 0, 0, 2,2074554.0d, 207.0d, -698.0d,-897492.0d,470.0d, -291.0d], $
[ 0, 1, 0, 0, 0,1475877.0d,-3633.0d,11817.0d,73871.0d,-184.0d,-1924.0d], $
[ 0, 1, 2,-2, 2,-516821.0d,1226.0d, -524.0d,224386.0d,-677.0d, -174.0d], $
[ 1, 0, 0, 0, 0, 711159.0d,  73.0d, -872.0d,  -6750.0d,  0.0d,  358.0d], $
[ 0, 0, 2, 0, 1,-387298.0d,-367.0d,  380.0d, 200728.0d, 18.0d,  318.0d], $
[ 1, 0, 2, 0, 2,-301461.0d, -36.0d,  816.0d, 129025.0d,-63.0d,  367.0d], $
[ 0,-1, 2,-2, 2, 215829.0d,-494.0d,  111.0d, -95929.0d,299.0d,  132.0d], $
;/* 11-20 */
[ 0, 0, 2,-2, 1, 128227.0d, 137.0d,  181.0d, -68982.0d, -9.0d,   39.0d], $
[-1, 0, 2, 0, 2, 123457.0d,  11.0d,   19.0d, -53311.0d, 32.0d,   -4.0d], $
[-1, 0, 0, 2, 0, 156994.0d,  10.0d, -168.0d,  -1235.0d,  0.0d,   82.0d], $
[ 1, 0, 0, 0, 1,  63110.0d,  63.0d,   27.0d, -33228.0d,  0.0d,   -9.0d], $
[-1, 0, 0, 0, 1, -57976.0d, -63.0d, -189.0d,  31429.0d,  0.0d,  -75.0d], $
[-1, 0, 2, 2, 2, -59641.0d, -11.0d,  149.0d,  25543.0d,-11.0d,   66.0d], $
[ 1, 0, 2, 0, 1, -51613.0d, -42.0d,  129.0d,  26366.0d,  0.0d,   78.0d], $
[-2, 0, 2, 0, 1,  45893.0d,  50.0d,   31.0d, -24236.0d,-10.0d,   20.0d], $
[ 0, 0, 0, 2, 0,  63384.0d,  11.0d, -150.0d,  -1220.0d,  0.0d,   29.0d], $
[ 0, 0, 2, 2, 2, -38571.0d,  -1.0d,  158.0d,  16452.0d,-11.0d,   68.0d], $
;/* 21-30 */
[ 0,-2, 2,-2, 2,  32481.0d,   0.0d,    0.0d, -13870.0d,  0.0d,    0.0d], $
[-2, 0, 0, 2, 0, -47722.0d,   0.0d,  -18.0d,    477.0d,  0.0d,  -25.0d], $
[ 2, 0, 2, 0, 2, -31046.0d,  -1.0d,  131.0d,  13238.0d,-11.0d,   59.0d], $
[ 1, 0, 2,-2, 2,  28593.0d,   0.0d,   -1.0d, -12338.0d, 10.0d,   -3.0d], $
[-1, 0, 2, 0, 1,  20441.0d,  21.0d,   10.0d, -10758.0d,  0.0d,   -3.0d], $
[ 2, 0, 0, 0, 0,  29243.0d,   0.0d,  -74.0d,   -609.0d,  0.0d,   13.0d], $
[ 0, 0, 2, 0, 0,  25887.0d,   0.0d,  -66.0d,   -550.0d,  0.0d,   11.0d], $
[ 0, 1, 0, 0, 1, -14053.0d, -25.0d,   79.0d,   8551.0d, -2.0d,  -45.0d], $
[-1, 0, 0, 2, 1,  15164.0d,  10.0d,   11.0d,  -8001.0d,  0.0d,   -1.0d], $
[ 0, 2, 2,-2, 2, -15794.0d,  72.0d,  -16.0d,   6850.0d,-42.0d,   -5.0d], $
;/* 31-40 */
[ 0, 0,-2, 2, 0,  21783.0d,   0.0d,   13.0d,   -167.0d,  0.0d,   13.0d], $
[ 1, 0, 0,-2, 1, -12873.0d, -10.0d,  -37.0d,   6953.0d,  0.0d,  -14.0d], $
[ 0,-1, 0, 0, 1, -12654.0d,  11.0d,   63.0d,   6415.0d,  0.0d,   26.0d], $
[-1, 0, 2, 2, 1, -10204.0d,   0.0d,   25.0d,   5222.0d,  0.0d,   15.0d], $
[ 0, 2, 0, 0, 0,  16707.0d, -85.0d,  -10.0d,    168.0d, -1.0d,   10.0d], $
[ 1, 0, 2, 2, 2,  -7691.0d,   0.0d,   44.0d,   3268.0d,  0.0d,   19.0d], $
[-2, 0, 2, 0, 0, -11024.0d,   0.0d,  -14.0d,    104.0d,  0.0d,    2.0d], $
[ 0, 1, 2, 0, 2,   7566.0d, -21.0d,  -11.0d,  -3250.0d,  0.0d,   -5.0d], $
[ 0, 0, 2, 2, 1,  -6637.0d, -11.0d,   25.0d,   3353.0d,  0.0d,   14.0d], $
[ 0,-1, 2, 0, 2,  -7141.0d,  21.0d,    8.0d,   3070.0d,  0.0d,    4.0d], $
;/* 41-50 */
[ 0, 0, 0, 2, 1,  -6302.0d, -11.0d,    2.0d,   3272.0d,  0.0d,    4.0d], $
[ 1, 0, 2,-2, 1,   5800.0d,  10.0d,    2.0d,  -3045.0d,  0.0d,   -1.0d], $
[ 2, 0, 2,-2, 2,   6443.0d,   0.0d,   -7.0d,  -2768.0d,  0.0d,   -4.0d], $
[-2, 0, 0, 2, 1,  -5774.0d, -11.0d,  -15.0d,   3041.0d,  0.0d,   -5.0d], $
[ 2, 0, 2, 0, 1,  -5350.0d,   0.0d,   21.0d,   2695.0d,  0.0d,   12.0d], $
[ 0,-1, 2,-2, 1,  -4752.0d, -11.0d,   -3.0d,   2719.0d,  0.0d,   -3.0d], $
[ 0, 0, 0,-2, 1,  -4940.0d, -11.0d,  -21.0d,   2720.0d,  0.0d,   -9.0d], $
[-1,-1, 0, 2, 0,   7350.0d,   0.0d,   -8.0d,    -51.0d,  0.0d,    4.0d], $
[ 2, 0, 0,-2, 1,   4065.0d,   0.0d,    6.0d,  -2206.0d,  0.0d,    1.0d], $
[ 1, 0, 0, 2, 0,   6579.0d,   0.0d,  -24.0d,   -199.0d,  0.0d,    2.0d], $
;/* 51-60 */
[ 0, 1, 2,-2, 1,   3579.0d,   0.0d,    5.0d,  -1900.0d,  0.0d,    1.0d], $
[ 1,-1, 0, 0, 0,   4725.0d,   0.0d,   -6.0d,    -41.0d,  0.0d,    3.0d], $
[-2, 0, 2, 0, 2,  -3075.0d,   0.0d,   -2.0d,   1313.0d,  0.0d,   -1.0d], $
[ 3, 0, 2, 0, 2,  -2904.0d,   0.0d,   15.0d,   1233.0d,  0.0d,    7.0d], $
[ 0,-1, 0, 2, 0,   4348.0d,   0.0d,  -10.0d,    -81.0d,  0.0d,    2.0d], $
[ 1,-1, 2, 0, 2,  -2878.0d,   0.0d,    8.0d,   1232.0d,  0.0d,    4.0d], $
[ 0, 0, 0, 1, 0,  -4230.0d,   0.0d,    5.0d,    -20.0d,  0.0d,   -2.0d], $
[-1,-1, 2, 2, 2,  -2819.0d,   0.0d,    7.0d,   1207.0d,  0.0d,    3.0d], $
[-1, 0, 2, 0, 0,  -4056.0d,   0.0d,    5.0d,     40.0d,  0.0d,   -2.0d], $
[ 0,-1, 2, 2, 2,  -2647.0d,   0.0d,   11.0d,   1129.0d,  0.0d,    5.0d], $
;/* 61-70 */
[-2, 0, 0, 0, 1,  -2294.0d,   0.0d,  -10.0d,   1266.0d,  0.0d,   -4.0d], $
[ 1, 1, 2, 0, 2,   2481.0d,   0.0d,   -7.0d,  -1062.0d,  0.0d,   -3.0d], $
[ 2, 0, 0, 0, 1,   2179.0d,   0.0d,   -2.0d,  -1129.0d,  0.0d,   -2.0d], $
[-1, 1, 0, 1, 0,   3276.0d,   0.0d,    1.0d,     -9.0d,  0.0d,    0.0d], $
[ 1, 1, 0, 0, 0,  -3389.0d,   0.0d,    5.0d,     35.0d,  0.0d,   -2.0d], $
[ 1, 0, 2, 0, 0,   3339.0d,   0.0d,  -13.0d,   -107.0d,  0.0d,    1.0d], $
[-1, 0, 2,-2, 1,  -1987.0d,   0.0d,   -6.0d,   1073.0d,  0.0d,   -2.0d], $
[ 1, 0, 0, 0, 2,  -1981.0d,   0.0d,    0.0d,    854.0d,  0.0d,    0.0d], $
[-1, 0, 0, 1, 0,   4026.0d,   0.0d, -353.0d,   -553.0d,  0.0d, -139.0d], $
[ 0, 0, 2, 1, 2,   1660.0d,   0.0d,   -5.0d,   -710.0d,  0.0d,   -2.0d], $
;/* 71-80 */
[-1, 0, 2, 4, 2,  -1521.0d,   0.0d,    9.0d,    647.0d,  0.0d,    4.0d], $
[-1, 1, 0, 1, 1,   1314.0d,   0.0d,    0.0d,   -700.0d,  0.0d,    0.0d], $
[ 0,-2, 2,-2, 1,  -1283.0d,   0.0d,    0.0d,    672.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 2, 1,  -1331.0d,   0.0d,    8.0d,    663.0d,  0.0d,    4.0d], $
[-2, 0, 2, 2, 2,   1383.0d,   0.0d,   -2.0d,   -594.0d,  0.0d,   -2.0d], $
[-1, 0, 0, 0, 2,   1405.0d,   0.0d,    4.0d,   -610.0d,  0.0d,    2.0d], $
[ 1, 1, 2,-2, 2,   1290.0d,   0.0d,    0.0d,   -556.0d,  0.0d,    0.0d], $
[-2, 0, 2, 4, 2,  -1214.0d,   0.0d,    5.0d,    518.0d,  0.0d,    2.0d], $
[-1, 0, 4, 0, 2,   1146.0d,   0.0d,   -3.0d,   -490.0d,  0.0d,   -1.0d], $
[ 2, 0, 2,-2, 1,   1019.0d,   0.0d,   -1.0d,   -527.0d,  0.0d,   -1.0d], $
;/* 81-90 */
[ 2, 0, 2, 2, 2,  -1100.0d,   0.0d,    9.0d,    465.0d,  0.0d,    4.0d], $
[ 1, 0, 0, 2, 1,   -970.0d,   0.0d,    2.0d,    496.0d,  0.0d,    1.0d], $
[ 3, 0, 0, 0, 0,   1575.0d,   0.0d,   -6.0d,    -50.0d,  0.0d,    0.0d], $
[ 3, 0, 2,-2, 2,    934.0d,   0.0d,   -3.0d,   -399.0d,  0.0d,   -1.0d], $
[ 0, 0, 4,-2, 2,    922.0d,   0.0d,   -1.0d,   -395.0d,  0.0d,   -1.0d], $
[ 0, 1, 2, 0, 1,    815.0d,   0.0d,   -1.0d,   -422.0d,  0.0d,   -1.0d], $
[ 0, 0,-2, 2, 1,    834.0d,   0.0d,    2.0d,   -440.0d,  0.0d,    1.0d], $
[ 0, 0, 2,-2, 3,   1248.0d,   0.0d,    0.0d,   -170.0d,  0.0d,    1.0d], $
[-1, 0, 0, 4, 0,   1338.0d,   0.0d,   -5.0d,    -39.0d,  0.0d,    0.0d], $
[ 2, 0,-2, 0, 1,    716.0d,   0.0d,   -2.0d,   -389.0d,  0.0d,   -1.0d], $
;/* 91-100 */
[-2, 0, 0, 4, 0,   1282.0d,   0.0d,   -3.0d,    -23.0d,  0.0d,    1.0d], $
[-1,-1, 0, 2, 1,    742.0d,   0.0d,    1.0d,   -391.0d,  0.0d,    0.0d], $
[-1, 0, 0, 1, 1,   1020.0d,   0.0d,  -25.0d,   -495.0d,  0.0d,  -10.0d], $
[ 0, 1, 0, 0, 2,    715.0d,   0.0d,   -4.0d,   -326.0d,  0.0d,    2.0d], $
[ 0, 0,-2, 0, 1,   -666.0d,   0.0d,   -3.0d,    369.0d,  0.0d,   -1.0d], $
[ 0,-1, 2, 0, 1,   -667.0d,   0.0d,    1.0d,    346.0d,  0.0d,    1.0d], $
[ 0, 0, 2,-1, 2,   -704.0d,   0.0d,    0.0d,    304.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 4, 2,   -694.0d,   0.0d,    5.0d,    294.0d,  0.0d,    2.0d], $
[-2,-1, 0, 2, 0,  -1014.0d,   0.0d,   -1.0d,      4.0d,  0.0d,   -1.0d], $
[ 1, 1, 0,-2, 1,   -585.0d,   0.0d,   -2.0d,    316.0d,  0.0d,   -1.0d], $
;/* 101-110 */
[-1, 1, 0, 2, 0,   -949.0d,   0.0d,    1.0d,      8.0d,  0.0d,   -1.0d], $
[-1, 1, 0, 1, 2,   -595.0d,   0.0d,    0.0d,    258.0d,  0.0d,    0.0d], $
[ 1,-1, 0, 0, 1,    528.0d,   0.0d,    0.0d,   -279.0d,  0.0d,    0.0d], $
[ 1,-1, 2, 2, 2,   -590.0d,   0.0d,    4.0d,    252.0d,  0.0d,    2.0d], $
[-1, 1, 2, 2, 2,    570.0d,   0.0d,   -2.0d,   -244.0d,  0.0d,   -1.0d], $
[ 3, 0, 2, 0, 1,   -502.0d,   0.0d,    3.0d,    250.0d,  0.0d,    2.0d], $
[ 0, 1,-2, 2, 0,   -875.0d,   0.0d,    1.0d,     29.0d,  0.0d,    0.0d], $
[-1, 0, 0,-2, 1,   -492.0d,   0.0d,   -3.0d,    275.0d,  0.0d,   -1.0d], $
[ 0, 1, 2, 2, 2,    535.0d,   0.0d,   -2.0d,   -228.0d,  0.0d,   -1.0d], $
[-1,-1, 2, 2, 1,   -467.0d,   0.0d,    1.0d,    240.0d,  0.0d,    1.0d], $
;/* 111-120 */
[ 0,-1, 0, 0, 2,    591.0d,   0.0d,    0.0d,   -253.0d,  0.0d,    0.0d], $
[ 1, 0, 2,-4, 1,   -453.0d,   0.0d,   -1.0d,    244.0d,  0.0d,   -1.0d], $
[-1, 0,-2, 2, 0,    766.0d,   0.0d,    1.0d,      9.0d,  0.0d,    0.0d], $
[ 0,-1, 2, 2, 1,   -446.0d,   0.0d,    2.0d,    225.0d,  0.0d,    1.0d], $
[ 2,-1, 2, 0, 2,   -488.0d,   0.0d,    2.0d,    207.0d,  0.0d,    1.0d], $
[ 0, 0, 0, 2, 2,   -468.0d,   0.0d,    0.0d,    201.0d,  0.0d,    0.0d], $
[ 1,-1, 2, 0, 1,   -421.0d,   0.0d,    1.0d,    216.0d,  0.0d,    1.0d], $
[-1, 1, 2, 0, 2,    463.0d,   0.0d,    0.0d,   -200.0d,  0.0d,    0.0d], $
[ 0, 1, 0, 2, 0,   -673.0d,   0.0d,    2.0d,     14.0d,  0.0d,    0.0d], $
[ 0,-1,-2, 2, 0,    658.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
;/* 121-130 */
[ 0, 3, 2,-2, 2,   -438.0d,   0.0d,    0.0d,    188.0d,  0.0d,    0.0d], $
[ 0, 0, 0, 1, 1,   -390.0d,   0.0d,    0.0d,    205.0d,  0.0d,    0.0d], $
[-1, 0, 2, 2, 0,    639.0d, -11.0d,   -2.0d,    -19.0d,  0.0d,    0.0d], $
[ 2, 1, 2, 0, 2,    412.0d,   0.0d,   -2.0d,   -176.0d,  0.0d,   -1.0d], $
[ 1, 1, 0, 0, 1,   -361.0d,   0.0d,    0.0d,    189.0d,  0.0d,    0.0d], $
[ 1, 1, 2, 0, 1,    360.0d,   0.0d,   -1.0d,   -185.0d,  0.0d,   -1.0d], $
[ 2, 0, 0, 2, 0,    588.0d,   0.0d,   -3.0d,    -24.0d,  0.0d,    0.0d], $
[ 1, 0,-2, 2, 0,   -578.0d,   0.0d,    1.0d,      5.0d,  0.0d,    0.0d], $
[-1, 0, 0, 2, 2,   -396.0d,   0.0d,    0.0d,    171.0d,  0.0d,    0.0d], $
[ 0, 1, 0, 1, 0,    565.0d,   0.0d,   -1.0d,     -6.0d,  0.0d,    0.0d], $
;/* 131-140 */
[ 0, 1, 0,-2, 1,   -335.0d,   0.0d,   -1.0d,    184.0d,  0.0d,   -1.0d], $
[-1, 0, 2,-2, 2,    357.0d,   0.0d,    1.0d,   -154.0d,  0.0d,    0.0d], $
[ 0, 0, 0,-1, 1,    321.0d,   0.0d,    1.0d,   -174.0d,  0.0d,    0.0d], $
[-1, 1, 0, 0, 1,   -301.0d,   0.0d,   -1.0d,    162.0d,  0.0d,    0.0d], $
[ 1, 0, 2,-1, 2,   -334.0d,   0.0d,    0.0d,    144.0d,  0.0d,    0.0d], $
[ 1,-1, 0, 2, 0,    493.0d,   0.0d,   -2.0d,    -15.0d,  0.0d,    0.0d], $
[ 0, 0, 0, 4, 0,    494.0d,   0.0d,   -2.0d,    -19.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 1, 2,    337.0d,   0.0d,   -1.0d,   -143.0d,  0.0d,   -1.0d], $
[ 0, 0, 2, 1, 1,    280.0d,   0.0d,   -1.0d,   -144.0d,  0.0d,    0.0d], $
[ 1, 0, 0,-2, 2,    309.0d,   0.0d,    1.0d,   -134.0d,  0.0d,    0.0d], $
;/* 141-150 */
[-1, 0, 2, 4, 1,   -263.0d,   0.0d,    2.0d,    131.0d,  0.0d,    1.0d], $
[ 1, 0,-2, 0, 1,    253.0d,   0.0d,    1.0d,   -138.0d,  0.0d,    0.0d], $
[ 1, 1, 2,-2, 1,    245.0d,   0.0d,    0.0d,   -128.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 2, 0,    416.0d,   0.0d,   -2.0d,    -17.0d,  0.0d,    0.0d], $
[-1, 0, 2,-1, 1,   -229.0d,   0.0d,    0.0d,    128.0d,  0.0d,    0.0d], $
[-2, 0, 2, 2, 1,    231.0d,   0.0d,    0.0d,   -120.0d,  0.0d,    0.0d], $
[ 4, 0, 2, 0, 2,   -259.0d,   0.0d,    2.0d,    109.0d,  0.0d,    1.0d], $
[ 2,-1, 0, 0, 0,    375.0d,   0.0d,   -1.0d,     -8.0d,  0.0d,    0.0d], $
[ 2, 1, 2,-2, 2,    252.0d,   0.0d,    0.0d,   -108.0d,  0.0d,    0.0d], $
[ 0, 1, 2, 1, 2,   -245.0d,   0.0d,    1.0d,    104.0d,  0.0d,    0.0d], $
;/* 151-160 */
[ 1, 0, 4,-2, 2,    243.0d,   0.0d,   -1.0d,   -104.0d,  0.0d,    0.0d], $
[-1,-1, 0, 0, 1,    208.0d,   0.0d,    1.0d,   -112.0d,  0.0d,    0.0d], $
[ 0, 1, 0, 2, 1,    199.0d,   0.0d,    0.0d,   -102.0d,  0.0d,    0.0d], $
[-2, 0, 2, 4, 1,   -208.0d,   0.0d,    1.0d,    105.0d,  0.0d,    0.0d], $
[ 2, 0, 2, 0, 0,    335.0d,   0.0d,   -2.0d,    -14.0d,  0.0d,    0.0d], $
[ 1, 0, 0, 1, 0,   -325.0d,   0.0d,    1.0d,      7.0d,  0.0d,    0.0d], $
[-1, 0, 0, 4, 1,   -187.0d,   0.0d,    0.0d,     96.0d,  0.0d,    0.0d], $
[-1, 0, 4, 0, 1,    197.0d,   0.0d,   -1.0d,   -100.0d,  0.0d,    0.0d], $
[ 2, 0, 2, 2, 1,   -192.0d,   0.0d,    2.0d,     94.0d,  0.0d,    1.0d], $
[ 0, 0, 2,-3, 2,   -188.0d,   0.0d,    0.0d,     83.0d,  0.0d,    0.0d], $
;/* 161-170 */
[-1,-2, 0, 2, 0,    276.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 2, 1, 0, 0, 0,   -286.0d,   0.0d,    1.0d,      6.0d,  0.0d,    0.0d], $
[ 0, 0, 4, 0, 2,    186.0d,   0.0d,   -1.0d,    -79.0d,  0.0d,    0.0d], $
[ 0, 0, 0, 0, 3,   -219.0d,   0.0d,    0.0d,     43.0d,  0.0d,    0.0d], $
[ 0, 3, 0, 0, 0,    276.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 0, 0, 2,-4, 1,   -153.0d,   0.0d,   -1.0d,     84.0d,  0.0d,    0.0d], $
[ 0,-1, 0, 2, 1,   -156.0d,   0.0d,    0.0d,     81.0d,  0.0d,    0.0d], $
[ 0, 0, 0, 4, 1,   -154.0d,   0.0d,    1.0d,     78.0d,  0.0d,    0.0d], $
[-1,-1, 2, 4, 2,   -174.0d,   0.0d,    1.0d,     75.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 4, 2,   -163.0d,   0.0d,    2.0d,     69.0d,  0.0d,    1.0d], $
;/* 171-180 */
[-2, 2, 0, 2, 0,   -228.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[-2,-1, 2, 0, 1,     91.0d,   0.0d,   -4.0d,    -54.0d,  0.0d,   -2.0d], $
[-2, 0, 0, 2, 2,    175.0d,   0.0d,    0.0d,    -75.0d,  0.0d,    0.0d], $
[-1,-1, 2, 0, 2,   -159.0d,   0.0d,    0.0d,     69.0d,  0.0d,    0.0d], $
[ 0, 0, 4,-2, 1,    141.0d,   0.0d,    0.0d,    -72.0d,  0.0d,    0.0d], $
[ 3, 0, 2,-2, 1,    147.0d,   0.0d,    0.0d,    -75.0d,  0.0d,    0.0d], $
[-2,-1, 0, 2, 1,   -132.0d,   0.0d,    0.0d,     69.0d,  0.0d,    0.0d], $
[ 1, 0, 0,-1, 1,    159.0d,   0.0d,  -28.0d,    -54.0d,  0.0d,   11.0d], $
[ 0,-2, 0, 2, 0,    213.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[-2, 0, 0, 4, 1,    123.0d,   0.0d,    0.0d,    -64.0d,  0.0d,    0.0d], $
;/* 181-190 */
[-3, 0, 0, 0, 1,   -118.0d,   0.0d,   -1.0d,     66.0d,  0.0d,    0.0d], $
[ 1, 1, 2, 2, 2,    144.0d,   0.0d,   -1.0d,    -61.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 4, 1,   -121.0d,   0.0d,    1.0d,     60.0d,  0.0d,    0.0d], $
[ 3, 0, 2, 2, 2,   -134.0d,   0.0d,    1.0d,     56.0d,  0.0d,    1.0d], $
[-1, 1, 2,-2, 1,   -105.0d,   0.0d,    0.0d,     57.0d,  0.0d,    0.0d], $
[ 2, 0, 0,-4, 1,   -102.0d,   0.0d,    0.0d,     56.0d,  0.0d,    0.0d], $
[ 0, 0, 0,-2, 2,    120.0d,   0.0d,    0.0d,    -52.0d,  0.0d,    0.0d], $
[ 2, 0, 2,-4, 1,    101.0d,   0.0d,    0.0d,    -54.0d,  0.0d,    0.0d], $
[-1, 1, 0, 2, 1,   -113.0d,   0.0d,    0.0d,     59.0d,  0.0d,    0.0d], $
[ 0, 0, 2,-1, 1,   -106.0d,   0.0d,    0.0d,     61.0d,  0.0d,    0.0d], $
;/* 191-200 */
[ 0,-2, 2, 2, 2,   -129.0d,   0.0d,    1.0d,     55.0d,  0.0d,    0.0d], $
[ 2, 0, 0, 2, 1,   -114.0d,   0.0d,    0.0d,     57.0d,  0.0d,    0.0d], $
[ 4, 0, 2,-2, 2,    113.0d,   0.0d,   -1.0d,    -49.0d,  0.0d,    0.0d], $
[ 2, 0, 0,-2, 2,   -102.0d,   0.0d,    0.0d,     44.0d,  0.0d,    0.0d], $
[ 0, 2, 0, 0, 1,    -94.0d,   0.0d,    0.0d,     51.0d,  0.0d,    0.0d], $
[ 1, 0, 0,-4, 1,   -100.0d,   0.0d,   -1.0d,     56.0d,  0.0d,    0.0d], $
[ 0, 2, 2,-2, 1,     87.0d,   0.0d,    0.0d,    -47.0d,  0.0d,    0.0d], $
[-3, 0, 0, 4, 0,    161.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[-1, 1, 2, 0, 1,     96.0d,   0.0d,    0.0d,    -50.0d,  0.0d,    0.0d], $
[-1,-1, 0, 4, 0,    151.0d,   0.0d,   -1.0d,     -5.0d,  0.0d,    0.0d], $
;/* 201-210 */
[-1,-2, 2, 2, 2,   -104.0d,   0.0d,    0.0d,     44.0d,  0.0d,    0.0d], $
[-2,-1, 2, 4, 2,   -110.0d,   0.0d,    0.0d,     48.0d,  0.0d,    0.0d], $
[ 1,-1, 2, 2, 1,   -100.0d,   0.0d,    1.0d,     50.0d,  0.0d,    0.0d], $
[-2, 1, 0, 2, 0,     92.0d,   0.0d,   -5.0d,     12.0d,  0.0d,   -2.0d], $
[-2, 1, 2, 0, 1,     82.0d,   0.0d,    0.0d,    -45.0d,  0.0d,    0.0d], $
[ 2, 1, 0,-2, 1,     82.0d,   0.0d,    0.0d,    -45.0d,  0.0d,    0.0d], $
[-3, 0, 2, 0, 1,    -78.0d,   0.0d,    0.0d,     41.0d,  0.0d,    0.0d], $
[-2, 0, 2,-2, 1,    -77.0d,   0.0d,    0.0d,     43.0d,  0.0d,    0.0d], $
[-1, 1, 0, 2, 2,      2.0d,   0.0d,    0.0d,     54.0d,  0.0d,    0.0d], $
[ 0,-1, 2,-1, 2,     94.0d,   0.0d,    0.0d,    -40.0d,  0.0d,    0.0d], $
;/* 211-220 */
[-1, 0, 4,-2, 2,    -93.0d,   0.0d,    0.0d,     40.0d,  0.0d,    0.0d], $
[ 0,-2, 2, 0, 2,    -83.0d,   0.0d,   10.0d,     40.0d,  0.0d,   -2.0d], $
[-1, 0, 2, 1, 2,     83.0d,   0.0d,    0.0d,    -36.0d,  0.0d,    0.0d], $
[ 2, 0, 0, 0, 2,    -91.0d,   0.0d,    0.0d,     39.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 0, 3,    128.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[-2, 0, 4, 0, 2,    -79.0d,   0.0d,    0.0d,     34.0d,  0.0d,    0.0d], $
[-1, 0,-2, 0, 1,    -83.0d,   0.0d,    0.0d,     47.0d,  0.0d,    0.0d], $
[-1, 1, 2, 2, 1,     84.0d,   0.0d,    0.0d,    -44.0d,  0.0d,    0.0d], $
[ 3, 0, 0, 0, 1,     83.0d,   0.0d,    0.0d,    -43.0d,  0.0d,    0.0d], $
[-1, 0, 2, 3, 2,     91.0d,   0.0d,    0.0d,    -39.0d,  0.0d,    0.0d], $
;/* 221-230 */
[ 2,-1, 2, 0, 1,    -77.0d,   0.0d,    0.0d,     39.0d,  0.0d,    0.0d], $
[ 0, 1, 2, 2, 1,     84.0d,   0.0d,    0.0d,    -43.0d,  0.0d,    0.0d], $
[ 0,-1, 2, 4, 2,    -92.0d,   0.0d,    1.0d,     39.0d,  0.0d,    0.0d], $
[ 2,-1, 2, 2, 2,    -92.0d,   0.0d,    1.0d,     39.0d,  0.0d,    0.0d], $
[ 0, 2,-2, 2, 0,    -94.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1,-1, 2,-1, 1,     68.0d,   0.0d,    0.0d,    -36.0d,  0.0d,    0.0d], $
[ 0,-2, 0, 0, 1,    -61.0d,   0.0d,    0.0d,     32.0d,  0.0d,    0.0d], $
[ 1, 0, 2,-4, 2,     71.0d,   0.0d,    0.0d,    -31.0d,  0.0d,    0.0d], $
[ 1,-1, 0,-2, 1,     62.0d,   0.0d,    0.0d,    -34.0d,  0.0d,    0.0d], $
[-1,-1, 2, 0, 1,    -63.0d,   0.0d,    0.0d,     33.0d,  0.0d,    0.0d], $
;/* 231-240 */
[ 1,-1, 2,-2, 2,    -73.0d,   0.0d,    0.0d,     32.0d,  0.0d,    0.0d], $
[-2,-1, 0, 4, 0,    115.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-1, 0, 0, 3, 0,   -103.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-2,-1, 2, 2, 2,     63.0d,   0.0d,    0.0d,    -28.0d,  0.0d,    0.0d], $
[ 0, 2, 2, 0, 2,     74.0d,   0.0d,    0.0d,    -32.0d,  0.0d,    0.0d], $
[ 1, 1, 0, 2, 0,   -103.0d,   0.0d,   -3.0d,      3.0d,  0.0d,   -1.0d], $
[ 2, 0, 2,-1, 2,    -69.0d,   0.0d,    0.0d,     30.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 1, 1,     57.0d,   0.0d,    0.0d,    -29.0d,  0.0d,    0.0d], $
[ 4, 0, 0, 0, 0,     94.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[ 2, 1, 2, 0, 1,     64.0d,   0.0d,    0.0d,    -33.0d,  0.0d,    0.0d], $
;/* 241-250 */
[ 3,-1, 2, 0, 2,    -63.0d,   0.0d,    0.0d,     26.0d,  0.0d,    0.0d], $
[-2, 2, 0, 2, 1,    -38.0d,   0.0d,    0.0d,     20.0d,  0.0d,    0.0d], $
[ 1, 0, 2,-3, 1,    -43.0d,   0.0d,    0.0d,     24.0d,  0.0d,    0.0d], $
[ 1, 1, 2,-4, 1,    -45.0d,   0.0d,    0.0d,     23.0d,  0.0d,    0.0d], $
[-1,-1, 2,-2, 1,     47.0d,   0.0d,    0.0d,    -24.0d,  0.0d,    0.0d], $
[ 0,-1, 0,-1, 1,    -48.0d,   0.0d,    0.0d,     25.0d,  0.0d,    0.0d], $
[ 0,-1, 0,-2, 1,     45.0d,   0.0d,    0.0d,    -26.0d,  0.0d,    0.0d], $
[-2, 0, 0, 0, 2,     56.0d,   0.0d,    0.0d,    -25.0d,  0.0d,    0.0d], $
[-2, 0,-2, 2, 0,     88.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-1, 0,-2, 4, 0,    -75.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 251-260 */
[ 1,-2, 0, 0, 0,     85.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 1, 0, 1, 1,     49.0d,   0.0d,    0.0d,    -26.0d,  0.0d,    0.0d], $
[-1, 2, 0, 2, 0,    -74.0d,   0.0d,   -3.0d,     -1.0d,  0.0d,   -1.0d], $
[ 1,-1, 2,-2, 1,    -39.0d,   0.0d,    0.0d,     21.0d,  0.0d,    0.0d], $
[ 1, 2, 2,-2, 2,     45.0d,   0.0d,    0.0d,    -20.0d,  0.0d,    0.0d], $
[ 2,-1, 2,-2, 2,     51.0d,   0.0d,    0.0d,    -22.0d,  0.0d,    0.0d], $
[ 1, 0, 2,-1, 1,    -40.0d,   0.0d,    0.0d,     21.0d,  0.0d,    0.0d], $
[ 2, 1, 2,-2, 1,     41.0d,   0.0d,    0.0d,    -21.0d,  0.0d,    0.0d], $
[-2, 0, 0,-2, 1,    -42.0d,   0.0d,    0.0d,     24.0d,  0.0d,    0.0d], $
[ 1,-2, 2, 0, 2,    -51.0d,   0.0d,    0.0d,     22.0d,  0.0d,    0.0d], $
;/* 261-270 */
[ 0, 1, 2, 1, 1,    -42.0d,   0.0d,    0.0d,     22.0d,  0.0d,    0.0d], $
[ 1, 0, 4,-2, 1,     39.0d,   0.0d,    0.0d,    -21.0d,  0.0d,    0.0d], $
[-2, 0, 4, 2, 2,     46.0d,   0.0d,    0.0d,    -18.0d,  0.0d,    0.0d], $
[ 1, 1, 2, 1, 2,    -53.0d,   0.0d,    0.0d,     22.0d,  0.0d,    0.0d], $
[ 1, 0, 0, 4, 0,     82.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 2, 0,     81.0d,   0.0d,   -1.0d,     -4.0d,  0.0d,    0.0d], $
[ 2, 0, 2, 1, 2,     47.0d,   0.0d,    0.0d,    -19.0d,  0.0d,    0.0d], $
[ 3, 1, 2, 0, 2,     53.0d,   0.0d,    0.0d,    -23.0d,  0.0d,    0.0d], $
[ 4, 0, 2, 0, 1,    -45.0d,   0.0d,    0.0d,     22.0d,  0.0d,    0.0d], $
[-2,-1, 2, 0, 0,    -44.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
;/* 271-280 */
[ 0, 1,-2, 2, 1,    -33.0d,   0.0d,    0.0d,     16.0d,  0.0d,    0.0d], $
[ 1, 0,-2, 1, 0,    -61.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[ 0,-1,-2, 2, 1,     28.0d,   0.0d,    0.0d,    -15.0d,  0.0d,    0.0d], $
[ 2,-1, 0,-2, 1,    -38.0d,   0.0d,    0.0d,     19.0d,  0.0d,    0.0d], $
[-1, 0, 2,-1, 2,    -33.0d,   0.0d,    0.0d,     21.0d,  0.0d,    0.0d], $
[ 1, 0, 2,-3, 2,    -60.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 1, 2,-2, 3,     48.0d,   0.0d,    0.0d,    -10.0d,  0.0d,    0.0d], $
[ 0, 0, 2,-3, 1,     27.0d,   0.0d,    0.0d,    -14.0d,  0.0d,    0.0d], $
[-1, 0,-2, 2, 1,     38.0d,   0.0d,    0.0d,    -20.0d,  0.0d,    0.0d], $
[ 0, 0, 2,-4, 2,     31.0d,   0.0d,    0.0d,    -13.0d,  0.0d,    0.0d], $
;/* 281-290 */
[-2, 1, 0, 0, 1,    -29.0d,   0.0d,    0.0d,     15.0d,  0.0d,    0.0d], $
[-1, 0, 0,-1, 1,     28.0d,   0.0d,    0.0d,    -15.0d,  0.0d,    0.0d], $
[ 2, 0, 2,-4, 2,    -32.0d,   0.0d,    0.0d,     15.0d,  0.0d,    0.0d], $
[ 0, 0, 4,-4, 4,     45.0d,   0.0d,    0.0d,     -8.0d,  0.0d,    0.0d], $
[ 0, 0, 4,-4, 2,    -44.0d,   0.0d,    0.0d,     19.0d,  0.0d,    0.0d], $
[-1,-2, 0, 2, 1,     28.0d,   0.0d,    0.0d,    -15.0d,  0.0d,    0.0d], $
[-2, 0, 0, 3, 0,    -51.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 0,-2, 2, 1,    -36.0d,   0.0d,    0.0d,     20.0d,  0.0d,    0.0d], $
[-3, 0, 2, 2, 2,     44.0d,   0.0d,    0.0d,    -19.0d,  0.0d,    0.0d], $
[-3, 0, 2, 2, 1,     26.0d,   0.0d,    0.0d,    -14.0d,  0.0d,    0.0d], $
;/* 291-300 */
[-2, 0, 2, 2, 0,    -60.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 2,-1, 0, 0, 1,     35.0d,   0.0d,    0.0d,    -18.0d,  0.0d,    0.0d], $
[-2, 1, 2, 2, 2,    -27.0d,   0.0d,    0.0d,     11.0d,  0.0d,    0.0d], $
[ 1, 1, 0, 1, 0,     47.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 0, 1, 4,-2, 2,     36.0d,   0.0d,    0.0d,    -15.0d,  0.0d,    0.0d], $
[-1, 1, 0,-2, 1,    -36.0d,   0.0d,    0.0d,     20.0d,  0.0d,    0.0d], $
[ 0, 0, 0,-4, 1,    -35.0d,   0.0d,    0.0d,     19.0d,  0.0d,    0.0d], $
[ 1,-1, 0, 2, 1,    -37.0d,   0.0d,    0.0d,     19.0d,  0.0d,    0.0d], $
[ 1, 1, 0, 2, 1,     32.0d,   0.0d,    0.0d,    -16.0d,  0.0d,    0.0d], $
[-1, 2, 2, 2, 2,     35.0d,   0.0d,    0.0d,    -14.0d,  0.0d,    0.0d], $
;/* 301-310 */
[ 3, 1, 2,-2, 2,     32.0d,   0.0d,    0.0d,    -13.0d,  0.0d,    0.0d], $
[ 0,-1, 0, 4, 0,     65.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 2,-1, 0, 2, 0,     47.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 0, 0, 4, 0, 1,     32.0d,   0.0d,    0.0d,    -16.0d,  0.0d,    0.0d], $
[ 2, 0, 4,-2, 2,     37.0d,   0.0d,    0.0d,    -16.0d,  0.0d,    0.0d], $
[-1,-1, 2, 4, 1,    -30.0d,   0.0d,    0.0d,     15.0d,  0.0d,    0.0d], $
[ 1, 0, 0, 4, 1,    -32.0d,   0.0d,    0.0d,     16.0d,  0.0d,    0.0d], $
[ 1,-2, 2, 2, 2,    -31.0d,   0.0d,    0.0d,     13.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 3, 2,     37.0d,   0.0d,    0.0d,    -16.0d,  0.0d,    0.0d], $
[-1, 1, 2, 4, 2,     31.0d,   0.0d,    0.0d,    -13.0d,  0.0d,    0.0d], $
;/* 311-320 */
[ 3, 0, 0, 2, 0,     49.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-1, 0, 4, 2, 2,     32.0d,   0.0d,    0.0d,    -13.0d,  0.0d,    0.0d], $
[ 1, 1, 2, 2, 1,     23.0d,   0.0d,    0.0d,    -12.0d,  0.0d,    0.0d], $
[-2, 0, 2, 6, 2,    -43.0d,   0.0d,    0.0d,     18.0d,  0.0d,    0.0d], $
[ 2, 1, 2, 2, 2,     26.0d,   0.0d,    0.0d,    -11.0d,  0.0d,    0.0d], $
[-1, 0, 2, 6, 2,    -32.0d,   0.0d,    0.0d,     14.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 4, 1,    -29.0d,   0.0d,    0.0d,     14.0d,  0.0d,    0.0d], $
[ 2, 0, 2, 4, 2,    -27.0d,   0.0d,    0.0d,     12.0d,  0.0d,    0.0d], $
[ 1, 1,-2, 1, 0,     30.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-3, 1, 2, 1, 2,    -11.0d,   0.0d,    0.0d,      5.0d,  0.0d,    0.0d], $
;/* 321-330 */
[ 2, 0,-2, 0, 2,    -21.0d,   0.0d,    0.0d,     10.0d,  0.0d,    0.0d], $
[-1, 0, 0, 1, 2,    -34.0d,   0.0d,    0.0d,     15.0d,  0.0d,    0.0d], $
[-4, 0, 2, 2, 1,    -10.0d,   0.0d,    0.0d,      6.0d,  0.0d,    0.0d], $
[-1,-1, 0, 1, 0,    -36.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 0,-2, 2, 2,     -9.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[ 1, 0, 0,-1, 2,    -12.0d,   0.0d,    0.0d,      5.0d,  0.0d,    0.0d], $
[ 0,-1, 2,-2, 3,    -21.0d,   0.0d,    0.0d,      5.0d,  0.0d,    0.0d], $
[-2, 1, 2, 0, 0,    -29.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 0, 0, 2,-2, 4,    -15.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[-2,-2, 0, 2, 0,    -20.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 331-340 */
[-2, 0,-2, 4, 0,     28.0d,   0.0d,    0.0d,      0.0d,  0.0d,   -2.0d], $
[ 0,-2,-2, 2, 0,     17.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 2, 0,-2, 1,    -22.0d,   0.0d,    0.0d,     12.0d,  0.0d,    0.0d], $
[ 3, 0, 0,-4, 1,    -14.0d,   0.0d,    0.0d,      7.0d,  0.0d,    0.0d], $
[-1, 1, 2,-2, 2,     24.0d,   0.0d,    0.0d,    -11.0d,  0.0d,    0.0d], $
[ 1,-1, 2,-4, 1,     11.0d,   0.0d,    0.0d,     -6.0d,  0.0d,    0.0d], $
[ 1, 1, 0,-2, 2,     14.0d,   0.0d,    0.0d,     -6.0d,  0.0d,    0.0d], $
[-3, 0, 2, 0, 0,     24.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-3, 0, 2, 0, 2,     18.0d,   0.0d,    0.0d,     -8.0d,  0.0d,    0.0d], $
[-2, 0, 0, 1, 0,    -38.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 341-350 */
[ 0, 0,-2, 1, 0,    -31.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-3, 0, 0, 2, 1,    -16.0d,   0.0d,    0.0d,      8.0d,  0.0d,    0.0d], $
[-1,-1,-2, 2, 0,     29.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 1, 2,-4, 1,    -18.0d,   0.0d,    0.0d,     10.0d,  0.0d,    0.0d], $
[ 2, 1, 0,-4, 1,    -10.0d,   0.0d,    0.0d,      5.0d,  0.0d,    0.0d], $
[ 0, 2, 0,-2, 1,    -17.0d,   0.0d,    0.0d,     10.0d,  0.0d,    0.0d], $
[ 1, 0, 0,-3, 1,      9.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[-2, 0, 2,-2, 2,     16.0d,   0.0d,    0.0d,     -6.0d,  0.0d,    0.0d], $
[-2,-1, 0, 0, 1,     22.0d,   0.0d,    0.0d,    -12.0d,  0.0d,    0.0d], $
[-4, 0, 0, 2, 0,     20.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 351-360 */
[ 1, 1, 0,-4, 1,    -13.0d,   0.0d,    0.0d,      6.0d,  0.0d,    0.0d], $
[-1, 0, 2,-4, 1,    -17.0d,   0.0d,    0.0d,      9.0d,  0.0d,    0.0d], $
[ 0, 0, 4,-4, 1,    -14.0d,   0.0d,    0.0d,      8.0d,  0.0d,    0.0d], $
[ 0, 3, 2,-2, 2,      0.0d,   0.0d,    0.0d,     -7.0d,  0.0d,    0.0d], $
[-3,-1, 0, 4, 0,     14.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-3, 0, 0, 4, 1,     19.0d,   0.0d,    0.0d,    -10.0d,  0.0d,    0.0d], $
[ 1,-1,-2, 2, 0,    -34.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1,-1, 0, 2, 2,    -20.0d,   0.0d,    0.0d,      8.0d,  0.0d,    0.0d], $
[ 1,-2, 0, 0, 1,      9.0d,   0.0d,    0.0d,     -5.0d,  0.0d,    0.0d], $
[ 1,-1, 0, 0, 2,    -18.0d,   0.0d,    0.0d,      7.0d,  0.0d,    0.0d], $
;/* 361-370 */
[ 0, 0, 0, 1, 2,     13.0d,   0.0d,    0.0d,     -6.0d,  0.0d,    0.0d], $
[-1,-1, 2, 0, 0,     17.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1,-2, 2,-2, 2,    -12.0d,   0.0d,    0.0d,      5.0d,  0.0d,    0.0d], $
[ 0,-1, 2,-1, 1,     15.0d,   0.0d,    0.0d,     -8.0d,  0.0d,    0.0d], $
[-1, 0, 2, 0, 3,    -11.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[ 1, 1, 0, 0, 2,     13.0d,   0.0d,    0.0d,     -5.0d,  0.0d,    0.0d], $
[-1, 1, 2, 0, 0,    -18.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 2, 0, 0, 0,    -35.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1, 2, 2, 0, 2,      9.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[-1, 0, 4,-2, 1,    -19.0d,   0.0d,    0.0d,     10.0d,  0.0d,    0.0d], $
;/* 371-380 */
[ 3, 0, 2,-4, 2,    -26.0d,   0.0d,    0.0d,     11.0d,  0.0d,    0.0d], $
[ 1, 2, 2,-2, 1,      8.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[ 1, 0, 4,-4, 2,    -10.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[-2,-1, 0, 4, 1,     10.0d,   0.0d,    0.0d,     -6.0d,  0.0d,    0.0d], $
[ 0,-1, 0, 2, 2,    -21.0d,   0.0d,    0.0d,      9.0d,  0.0d,    0.0d], $
[-2, 1, 0, 4, 0,    -15.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-2,-1, 2, 2, 1,      9.0d,   0.0d,    0.0d,     -5.0d,  0.0d,    0.0d], $
[ 2, 0,-2, 2, 0,    -29.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 0, 0, 1, 1,    -19.0d,   0.0d,    0.0d,     10.0d,  0.0d,    0.0d], $
[ 0, 1, 0, 2, 2,     12.0d,   0.0d,    0.0d,     -5.0d,  0.0d,    0.0d], $
;/* 381-390 */
[ 1,-1, 2,-1, 2,     22.0d,   0.0d,    0.0d,     -9.0d,  0.0d,    0.0d], $
[-2, 0, 4, 0, 1,    -10.0d,   0.0d,    0.0d,      5.0d,  0.0d,    0.0d], $
[ 2, 1, 0, 0, 1,    -20.0d,   0.0d,    0.0d,     11.0d,  0.0d,    0.0d], $
[ 0, 1, 2, 0, 0,    -20.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0,-1, 4,-2, 2,    -17.0d,   0.0d,    0.0d,      7.0d,  0.0d,    0.0d], $
[ 0, 0, 4,-2, 4,     15.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 0, 2, 2, 0, 1,      8.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[-3, 0, 0, 6, 0,     14.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1,-1, 0, 4, 1,    -12.0d,   0.0d,    0.0d,      6.0d,  0.0d,    0.0d], $
[ 1,-2, 0, 2, 0,     25.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 391-400 */
[-1, 0, 0, 4, 2,    -13.0d,   0.0d,    0.0d,      6.0d,  0.0d,    0.0d], $
[-1,-2, 2, 2, 1,    -14.0d,   0.0d,    0.0d,      8.0d,  0.0d,    0.0d], $
[-1, 0, 0,-2, 2,     13.0d,   0.0d,    0.0d,     -5.0d,  0.0d,    0.0d], $
[ 1, 0,-2,-2, 1,    -17.0d,   0.0d,    0.0d,      9.0d,  0.0d,    0.0d], $
[ 0, 0,-2,-2, 1,    -12.0d,   0.0d,    0.0d,      6.0d,  0.0d,    0.0d], $
[-2, 0,-2, 0, 1,    -10.0d,   0.0d,    0.0d,      5.0d,  0.0d,    0.0d], $
[ 0, 0, 0, 3, 1,     10.0d,   0.0d,    0.0d,     -6.0d,  0.0d,    0.0d], $
[ 0, 0, 0, 3, 0,    -15.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1, 1, 0, 4, 0,    -22.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1,-1, 2, 2, 0,     28.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
;/* 401-410 */
[-2, 0, 2, 3, 2,     15.0d,   0.0d,    0.0d,     -7.0d,  0.0d,    0.0d], $
[ 1, 0, 0, 2, 2,     23.0d,   0.0d,    0.0d,    -10.0d,  0.0d,    0.0d], $
[ 0,-1, 2, 1, 2,     12.0d,   0.0d,    0.0d,     -5.0d,  0.0d,    0.0d], $
[ 3,-1, 0, 0, 0,     29.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 2, 0, 0, 1, 0,    -25.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[ 1,-1, 2, 0, 0,     22.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 1, 0,    -18.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 0, 3,     15.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[ 3, 1, 0, 0, 0,    -23.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 3,-1, 2,-2, 2,     12.0d,   0.0d,    0.0d,     -5.0d,  0.0d,    0.0d], $
;/* 411-420 */
[ 2, 0, 2,-1, 1,     -8.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[ 1, 1, 2, 0, 0,    -19.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 0, 4,-1, 2,    -10.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[ 1, 2, 2, 0, 2,     21.0d,   0.0d,    0.0d,     -9.0d,  0.0d,    0.0d], $
[-2, 0, 0, 6, 0,     23.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 0,-1, 0, 4, 1,    -16.0d,   0.0d,    0.0d,      8.0d,  0.0d,    0.0d], $
[-2,-1, 2, 4, 1,    -19.0d,   0.0d,    0.0d,      9.0d,  0.0d,    0.0d], $
[ 0,-2, 2, 2, 1,    -22.0d,   0.0d,    0.0d,     10.0d,  0.0d,    0.0d], $
[ 0,-1, 2, 2, 0,     27.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[-1, 0, 2, 3, 1,     16.0d,   0.0d,    0.0d,     -8.0d,  0.0d,    0.0d], $
;/* 421-430 */
[-2, 1, 2, 4, 2,     19.0d,   0.0d,    0.0d,     -8.0d,  0.0d,    0.0d], $
[ 2, 0, 0, 2, 2,      9.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[ 2,-2, 2, 0, 2,     -9.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[-1, 1, 2, 3, 2,     -9.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[ 3, 0, 2,-1, 2,     -8.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[ 4, 0, 2,-2, 1,     18.0d,   0.0d,    0.0d,     -9.0d,  0.0d,    0.0d], $
[-1, 0, 0, 6, 0,     16.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[-1,-2, 2, 4, 2,    -10.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[-3, 0, 2, 6, 2,    -23.0d,   0.0d,    0.0d,      9.0d,  0.0d,    0.0d], $
[-1, 0, 2, 4, 0,     16.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
;/* 431-440 */
[ 3, 0, 0, 2, 1,    -12.0d,   0.0d,    0.0d,      6.0d,  0.0d,    0.0d], $
[ 3,-1, 2, 0, 1,     -8.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[ 3, 0, 2, 0, 0,     30.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 1, 0, 4, 0, 2,     24.0d,   0.0d,    0.0d,    -10.0d,  0.0d,    0.0d], $
[ 5, 0, 2,-2, 2,     10.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[ 0,-1, 2, 4, 1,    -16.0d,   0.0d,    0.0d,      7.0d,  0.0d,    0.0d], $
[ 2,-1, 2, 2, 1,    -16.0d,   0.0d,    0.0d,      7.0d,  0.0d,    0.0d], $
[ 0, 1, 2, 4, 2,     17.0d,   0.0d,    0.0d,     -7.0d,  0.0d,    0.0d], $
[ 1,-1, 2, 4, 2,    -24.0d,   0.0d,    0.0d,     10.0d,  0.0d,    0.0d], $
[ 3,-1, 2, 2, 2,    -12.0d,   0.0d,    0.0d,      5.0d,  0.0d,    0.0d], $
;/* 441-450 */
[ 3, 0, 2, 2, 1,    -24.0d,   0.0d,    0.0d,     11.0d,  0.0d,    0.0d], $
[ 5, 0, 2, 0, 2,    -23.0d,   0.0d,    0.0d,      9.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 6, 2,    -13.0d,   0.0d,    0.0d,      5.0d,  0.0d,    0.0d], $
[ 4, 0, 2, 2, 2,    -15.0d,   0.0d,    0.0d,      7.0d,  0.0d,    0.0d], $
[ 0,-1, 1,-1, 1,      0.0d,   0.0d,-1988.0d,      0.0d,  0.0d,-1679.0d], $
[-1, 0, 1, 0, 3,      0.0d,   0.0d,  -63.0d,      0.0d,  0.0d,  -27.0d], $
[ 0,-2, 2,-2, 3,     -4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 0,-1, 0, 1,      0.0d,   0.0d,    5.0d,      0.0d,  0.0d,    4.0d], $
[ 2,-2, 0,-2, 1,      5.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[-1, 0, 1, 0, 2,      0.0d,   0.0d,  364.0d,      0.0d,  0.0d,  176.0d], $
;/* 451-460 */
[-1, 0, 1, 0, 1,      0.0d,   0.0d,-1044.0d,      0.0d,  0.0d, -891.0d], $
[-1,-1, 2,-1, 2,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[-2, 2, 0, 2, 2,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-1, 0, 1, 0, 0,      0.0d,   0.0d,  330.0d,      0.0d,  0.0d,    0.0d], $
[-4, 1, 2, 2, 2,      5.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-3, 0, 2, 1, 1,      3.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-2,-1, 2, 0, 2,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[ 1, 0,-2, 1, 1,     -5.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 2,-1,-2, 0, 1,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[-4, 0, 2, 2, 0,      3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 461-470 */
[-3, 1, 0, 3, 0,      3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1, 0,-1, 2, 0,      0.0d,   0.0d,    5.0d,      0.0d,  0.0d,    0.0d], $
[ 0,-2, 0, 0, 2,      0.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[ 0,-2, 0, 0, 2,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-3, 0, 0, 3, 0,      6.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-2,-1, 0, 2, 2,      5.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-1, 0,-2, 3, 0,     -7.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-4, 0, 0, 4, 0,    -12.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 2, 1,-2, 0, 1,      5.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 2,-1, 0,-2, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
;/* 471-480 */
[ 0, 0, 1,-1, 0,     -5.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1, 2, 0, 1, 0,      3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-2, 1, 2, 0, 2,     -7.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[ 1, 1, 0,-1, 1,      7.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[ 1, 0, 1,-2, 1,      0.0d,   0.0d,  -12.0d,      0.0d,  0.0d,  -10.0d], $
[ 0, 2, 0, 0, 2,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 1,-1, 2,-3, 1,      3.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-1, 1, 2,-1, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-2, 0, 4,-2, 2,     -7.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[-2, 0, 4,-2, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
;/* 481-490 */
[-2,-2, 0, 2, 1,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[-2, 0,-2, 4, 0,      0.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 2, 2,-4, 1,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[ 1, 1, 2,-4, 2,      7.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[-1, 2, 2,-2, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 2, 0, 0,-3, 1,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-1, 2, 0, 0, 1,     -5.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[ 0, 0, 0,-2, 0,      5.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1,-1, 2,-2, 2,     -5.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-1, 1, 0, 0, 2,      5.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
;/* 491-500 */
[ 0, 0, 0,-1, 2,     -8.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[-2, 1, 0, 1, 0,      9.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1,-2, 0,-2, 1,      6.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 1, 0,-2, 0, 2,     -5.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-3, 1, 0, 2, 0,      3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1, 1,-2, 2, 0,     -7.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1,-1, 0, 0, 2,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[-3, 0, 0, 2, 0,      5.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-3,-1, 0, 2, 0,      3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 2, 0, 2,-6, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
;/* 501-510 */
[ 0, 1, 2,-4, 2,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 2, 0, 0,-4, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[-2, 1, 2,-2, 1,     -5.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 0,-1, 2,-4, 1,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 0, 1, 0,-2, 2,      9.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[-1, 0, 0,-2, 0,      4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 2, 0,-2,-2, 1,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-4, 0, 2, 0, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-1,-1, 0,-1, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 0, 0,-2, 0, 2,      9.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
;/* 511-520 */
[-3, 0, 0, 1, 0,     -4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1, 0,-2, 1, 0,     -4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-2, 0,-2, 2, 1,      3.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 0, 0,-4, 2, 0,      8.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-2,-1,-2, 2, 0,      3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 0, 2,-6, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-1, 0, 2,-4, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 1, 0, 0,-4, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 2, 1, 2,-4, 2,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[ 2, 1, 2,-4, 1,      6.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
;/* 521-530 */
[ 0, 1, 4,-4, 4,      3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 1, 4,-4, 2,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[-1,-1,-2, 4, 0,     -7.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1,-3, 0, 2, 0,      9.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1, 0,-2, 4, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-2,-1, 0, 3, 0,     -3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 0,-2, 3, 0,     -4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-2, 0, 0, 3, 1,     -5.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[ 0,-1, 0, 1, 0,    -13.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-3, 0, 2, 2, 0,     -7.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 531-540 */
[ 1, 1,-2, 2, 0,     10.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1, 1, 0, 2, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 1,-2, 2,-2, 1,     10.0d,   0.0d,   13.0d,      6.0d,  0.0d,   -5.0d], $
[ 0, 0, 1, 0, 2,      0.0d,   0.0d,   30.0d,      0.0d,  0.0d,   14.0d], $
[ 0, 0, 1, 0, 1,      0.0d,   0.0d, -162.0d,      0.0d,  0.0d, -138.0d], $
[ 0, 0, 1, 0, 0,      0.0d,   0.0d,   75.0d,      0.0d,  0.0d,    0.0d], $
[-1, 2, 0, 2, 1,     -7.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 0, 2,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-2, 0, 2, 0, 2,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 2, 0, 0,-1, 1,      5.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
;/* 541-550 */
[ 3, 0, 0,-2, 1,      5.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 1, 0, 2,-2, 3,     -3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 2, 0, 0, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 2, 0, 2,-3, 2,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-1, 1, 4,-2, 2,     -5.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-2,-2, 0, 4, 0,      6.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0,-3, 0, 2, 0,      9.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 0,-2, 4, 0,      5.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1,-1, 0, 3, 0,     -7.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-2, 0, 0, 4, 2,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
;/* 551-560 */
[-1, 0, 0, 3, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 2,-2, 0, 0, 0,      7.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1,-1, 0, 1, 0,     -4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1, 0, 0, 2, 0,      4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0,-2, 2, 0, 1,     -6.0d,   0.0d,   -3.0d,      3.0d,  0.0d,    1.0d], $
[-1, 0, 1, 2, 1,      0.0d,   0.0d,   -3.0d,      0.0d,  0.0d,   -2.0d], $
[-1, 1, 0, 3, 0,     11.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1,-1, 2, 1, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 0,-1, 2, 0, 0,     11.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-2, 1, 2, 2, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
;/* 561-570 */
[ 2,-2, 2,-2, 2,     -1.0d,   0.0d,    3.0d,      3.0d,  0.0d,   -1.0d], $
[ 1, 1, 0, 1, 1,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 1, 0, 1, 0, 1,      0.0d,   0.0d,  -13.0d,      0.0d,  0.0d,  -11.0d], $
[ 1, 0, 1, 0, 0,      3.0d,   0.0d,    6.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 2, 0, 2, 0,     -7.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 2,-1, 2,-2, 1,      5.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 0,-1, 4,-2, 1,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[ 0, 0, 4,-2, 3,      3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 1, 4,-2, 1,      5.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 4, 0, 2,-4, 2,     -7.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
;/* 571-580 */
[ 2, 2, 2,-2, 2,      8.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 2, 0, 4,-4, 2,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-1,-2, 0, 4, 0,     11.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1,-3, 2, 2, 2,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[-3, 0, 2, 4, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[-3, 0, 2,-2, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-1,-1, 0,-2, 1,      8.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[-3, 0, 0, 0, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[-3, 0,-2, 2, 0,     11.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 1, 0,-4, 1,     -6.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
;/* 581-590 */
[-2, 1, 0,-2, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-4, 0, 0, 0, 1,     -8.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
[-1, 0, 0,-4, 1,     -7.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[-3, 0, 0,-2, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 0, 0, 0, 3, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[-1, 1, 0, 4, 1,      6.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 1,-2, 2, 0, 1,     -6.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[ 0, 1, 0, 3, 0,      6.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-1, 0, 2, 2, 3,      6.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 2, 2,      5.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
;/* 591-600 */
[-2, 0, 2, 2, 2,     -5.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-1, 1, 2, 2, 0,     -4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 3, 0, 0, 0, 2,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 2, 1, 0, 1, 0,      4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 2,-1, 2,-1, 2,      6.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 0, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 0, 0, 3, 0, 3,      0.0d,   0.0d,  -26.0d,      0.0d,  0.0d,  -11.0d], $
[ 0, 0, 3, 0, 2,      0.0d,   0.0d,  -10.0d,      0.0d,  0.0d,   -5.0d], $
[-1, 2, 2, 2, 1,      5.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[-1, 0, 4, 0, 0,    -13.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 601-610 */
[ 1, 2, 2, 0, 1,      3.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 3, 1, 2,-2, 1,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 1, 1, 4,-2, 2,      7.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[-2,-1, 0, 6, 0,      4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0,-2, 0, 4, 0,      5.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-2, 0, 0, 6, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-2,-2, 2, 4, 2,     -6.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 0,-3, 2, 2, 2,     -5.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 0, 0, 0, 4, 2,     -7.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[-1,-1, 2, 3, 2,      5.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
;/* 611-620 */
[-2, 0, 2, 4, 0,     13.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 2,-1, 0, 2, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 1, 0, 0, 3, 0,     -3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 1, 0, 4, 1,      5.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 0, 1, 0, 4, 0,    -11.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1,-1, 2, 1, 2,      5.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 2, 3,      4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 2, 2,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-1, 0, 2, 2, 2,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-2, 0, 4, 2, 1,      6.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
;/* 621-630 */
[ 2, 1, 0, 2, 1,      3.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 2, 1, 0, 2, 0,    -12.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 2,-1, 2, 0, 0,      4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 1, 0,     -3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 1, 2, 2, 0,     -4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 2, 0, 2, 0, 3,      3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 3, 0, 2, 0, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 0, 2,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[ 1, 0, 3, 0, 3,      0.0d,   0.0d,   -5.0d,      0.0d,  0.0d,   -2.0d], $
[ 1, 1, 2, 1, 1,     -7.0d,   0.0d,    0.0d,      4.0d,  0.0d,    0.0d], $
;/* 631-640 */
[ 0, 2, 2, 2, 2,      6.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 2, 1, 2, 0, 0,     -3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 2, 0, 4,-2, 1,      5.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 4, 1, 2,-2, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[-1,-1, 0, 6, 0,      3.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[-3,-1, 2, 6, 2,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[-1, 0, 0, 6, 1,     -5.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[-3, 0, 2, 6, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 1,-1, 0, 4, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 1,-1, 0, 4, 0,     12.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 641-650 */
[-2, 0, 2, 5, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 1,-2, 2, 2, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 3,-1, 0, 2, 0,      4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1,-1, 2, 2, 0,      6.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 3, 1,      5.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[-1, 1, 2, 4, 1,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 0, 1, 2, 3, 2,     -6.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[-1, 0, 4, 2, 1,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 2, 0, 2, 1, 1,      6.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 5, 0, 0, 0, 0,      6.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 651-660 */
[ 2, 1, 2, 1, 2,     -6.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[ 1, 0, 4, 0, 1,      3.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 3, 1, 2, 0, 1,      7.0d,   0.0d,    0.0d,     -4.0d,  0.0d,    0.0d], $
[ 3, 0, 4,-2, 2,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[-2,-1, 2, 6, 2,     -5.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 0, 0, 0, 6, 0,      5.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0,-2, 2, 4, 2,     -6.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[-2, 0, 2, 6, 1,     -6.0d,   0.0d,    0.0d,      3.0d,  0.0d,    0.0d], $
[ 2, 0, 0, 4, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 2, 0, 0, 4, 0,     10.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
;/* 661-670 */
[ 2,-2, 2, 2, 2,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 0, 0, 2, 4, 0,      7.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 1, 0, 2, 3, 2,      7.0d,   0.0d,    0.0d,     -3.0d,  0.0d,    0.0d], $
[ 4, 0, 0, 2, 0,      4.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 2, 0, 2, 2, 0,     11.0d,   0.0d,    0.0d,      0.0d,  0.0d,    0.0d], $
[ 0, 0, 4, 2, 2,      5.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 4,-1, 2, 0, 2,     -6.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 3, 0, 2, 1, 2,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 2, 1, 2, 2, 1,      3.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 4, 1, 2, 0, 2,      5.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
;/* 671-678 */
[-1,-1, 2, 6, 2,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[-1, 0, 2, 6, 1,     -4.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 1,-1, 2, 4, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d], $
[ 1, 1, 2, 4, 2,      4.0d,   0.0d,    0.0d,     -2.0d,  0.0d,    0.0d], $
[ 3, 1, 2, 2, 2,      3.0d,   0.0d,    0.0d,     -1.0d,  0.0d,    0.0d], $
[ 5, 0, 2, 0, 1,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[ 2,-1, 2, 4, 2,     -3.0d,   0.0d,    0.0d,      1.0d,  0.0d,    0.0d], $
[ 2, 0, 2, 4, 1,     -3.0d,   0.0d,    0.0d,      2.0d,  0.0d,    0.0d] $
];

xls.nl=reform(xls_m[0,*])
xls.nlp=reform(xls_m[1,*])
xls.nf=reform(xls_m[2,*])
xls.nd=reform(xls_m[3,*])
xls.nom=reform(xls_m[4,*])
xls.sp=reform(xls_m[5,*])
xls.spt=reform(xls_m[6,*])
xls.cp=reform(xls_m[7,*])
xls.ce=reform(xls_m[8,*])
xls.cet=reform(xls_m[9,*])
xls.se=reform(xls_m[10,*])

xls_m=0
;/* Number of terms in the luni-solar nutation model */
NLS = n_elements( xls.se);

;/* ------------------------ */
;/* Planetary nutation model */
;/* ------------------------ */

;/* The units for the sine and cosine coefficients are */
;/* 0.1 microarcsecond                                 */

;static const struct {
;int nl,               /* coefficients of l, F, D and Omega */
;nf,
;nd,
;nom,
;nme,              /* coefficients of planetary longitudes */
;nve,
;nea,
;nma,
;nju,
;nsa,
;nur,
;nne,
;npa;              /* coefficient of general precession */
;int sp,cp;            /* longitude sin, cos coefficients */
;int se,ce;            /* obliquity sin, cos coefficients */
;} xpl[] = {

term1={nl:0, nf:0,nd:0,nom:0,nme:0,nve:0,nea:0,nma:0,nju:0,nsa:0,nur:0,nne:0,npa:0,sp:0,cp:0,se:0,ce:0}
xpl=replicate(term1,687)

xpl_m= [ $
;/* 1-10 */
[ 0, 0, 0, 0, 0,  0,  8,-16, 4, 5, 0, 0, 0, 1440,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -8, 16,-4,-5, 0, 0, 2,   56,-117,  -42, -40], $
[ 0, 0, 0, 0, 0,  0,  8,-16, 4, 5, 0, 0, 2,  125, -43,    0, -54], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 0,-1, 2, 2,    0,   5,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -4,  8,-1,-5, 0, 0, 2,    3,  -7,   -3,   0], $
[ 0, 0, 0, 0, 0,  0,  4, -8, 3, 0, 0, 0, 1,    3,   0,    0,  -2], $
[ 0, 1,-1, 1, 0,  0,  3, -8, 3, 0, 0, 0, 0, -114,   0,    0,  61], $
[-1, 0, 0, 0, 0, 10, -3,  0, 0, 0, 0, 0, 0, -219,  89,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  0,-2, 6,-3, 0, 2,   -3,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  4, -8, 3, 0, 0, 0, 0, -462,1604,    0,   0], $
;/* 11-20 */
[ 0, 1,-1, 1, 0,  0, -5,  8,-3, 0, 0, 0, 0,   99,   0,    0, -53], $
[ 0, 0, 0, 0, 0,  0, -4,  8,-3, 0, 0, 0, 1,   -3,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  0,  4, -8, 1, 5, 0, 0, 2,    0,   6,    2,   0], $
[ 0, 0, 0, 0, 0, -5,  6,  4, 0, 0, 0, 0, 2,    3,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 2,-5, 0, 0, 2,  -12,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 2,-5, 0, 0, 1,   14,-218,  117,   8], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 2,-5, 0, 0, 0,   31,-481, -257, -17], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 2,-5, 0, 0, 0, -491, 128,    0,   0], $
[ 0, 1,-1, 1, 0,  0, -1,  0,-2, 5, 0, 0, 0,-3084,5123, 2735,1647], $
[ 0, 0, 0, 0, 0,  0,  0,  0,-2, 5, 0, 0, 1,-1444,2409,-1286,-771], $
;/* 21-30 */
[ 0, 0, 0, 0, 0,  0,  0,  0,-2, 5, 0, 0, 2,   11, -24,  -11,  -9], $
[ 2,-1,-1, 0, 0,  0,  3, -7, 0, 0, 0, 0, 0,   26,  -9,    0,   0], $
[ 1, 0,-2, 0, 0, 19,-21,  3, 0, 0, 0, 0, 0,  103, -60,    0,   0], $
[ 0, 1,-1, 1, 0,  2, -4,  0,-3, 0, 0, 0, 0,    0, -13,   -7,   0], $
[ 1, 0,-1, 1, 0,  0, -1,  0, 2, 0, 0, 0, 0,  -26, -29,  -16,  14], $
[ 0, 1,-1, 1, 0,  0, -1,  0,-4,10, 0, 0, 0,    9, -27,  -14,  -5], $
[-2, 0, 2, 1, 0,  0,  2,  0, 0,-5, 0, 0, 0,   12,   0,    0,  -6], $
[ 0, 0, 0, 0, 0,  3, -7,  4, 0, 0, 0, 0, 0,   -7,   0,    0,   0], $
[ 0,-1, 1, 0, 0,  0,  1,  0, 1,-1, 0, 0, 0,    0,  24,    0,   0], $
[-2, 0, 2, 1, 0,  0,  2,  0,-2, 0, 0, 0, 0,  284,   0,    0,-151], $
;/* 31-40 */
[-1, 0, 0, 0, 0, 18,-16,  0, 0, 0, 0, 0, 0,  226, 101,    0,   0], $
[-2, 1, 1, 2, 0,  0,  1,  0,-2, 0, 0, 0, 0,    0,  -8,   -2,   0], $
[-1, 1,-1, 1, 0, 18,-17,  0, 0, 0, 0, 0, 0,    0,  -6,   -3,   0], $
[-1, 0, 1, 1, 0,  0,  2, -2, 0, 0, 0, 0, 0,    5,   0,    0,  -3], $
[ 0, 0, 0, 0, 0, -8, 13,  0, 0, 0, 0, 0, 2,  -41, 175,   76,  17], $
[ 0, 2,-2, 2, 0, -8, 11,  0, 0, 0, 0, 0, 0,    0,  15,    6,   0], $
[ 0, 0, 0, 0, 0, -8, 13,  0, 0, 0, 0, 0, 1,  425, 212, -133, 269], $
[ 0, 1,-1, 1, 0, -8, 12,  0, 0, 0, 0, 0, 0, 1200, 598,  319,-641], $
[ 0, 0, 0, 0, 0,  8,-13,  0, 0, 0, 0, 0, 0,  235, 334,    0,   0], $
[ 0, 1,-1, 1, 0,  8,-14,  0, 0, 0, 0, 0, 0,   11, -12,   -7,  -6], $
;/* 41-50 */
[ 0, 0, 0, 0, 0,  8,-13,  0, 0, 0, 0, 0, 1,    5,  -6,    3,   3], $
[-2, 0, 2, 1, 0,  0,  2,  0,-4, 5, 0, 0, 0,   -5,   0,    0,   3], $
[-2, 0, 2, 2, 0,  3, -3,  0, 0, 0, 0, 0, 0,    6,   0,    0,  -3], $
[-2, 0, 2, 0, 0,  0,  2,  0,-3, 1, 0, 0, 0,   15,   0,    0,   0], $
[ 0, 0, 0, 1, 0,  3, -5,  0, 2, 0, 0, 0, 0,   13,   0,    0,  -7], $
[-2, 0, 2, 0, 0,  0,  2,  0,-4, 3, 0, 0, 0,   -6,  -9,    0,   0], $
[ 0,-1, 1, 0, 0,  0,  0,  2, 0, 0, 0, 0, 0,  266, -78,    0,   0], $
[ 0, 0, 0, 1, 0,  0, -1,  2, 0, 0, 0, 0, 0, -460,-435, -232, 246], $
[ 0, 1,-1, 2, 0,  0, -2,  2, 0, 0, 0, 0, 0,    0,  15,    7,   0], $
[-1, 1, 0, 1, 0,  3, -5,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   2], $
;/* 51-60 */
[-1, 0, 1, 0, 0,  3, -4,  0, 0, 0, 0, 0, 0,    0, 131,    0,   0], $
[-2, 0, 2, 0, 0,  0,  2,  0,-2,-2, 0, 0, 0,    4,   0,    0,   0], $
[-2, 2, 0, 2, 0,  0, -5,  9, 0, 0, 0, 0, 0,    0,   3,    0,   0], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 0, 0,-1, 0, 0,    0,   4,    2,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 0, 1, 0, 0,    0,   3,    0,   0], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 0, 0, 0, 2, 0,  -17, -19,  -10,   9], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 0, 0, 2, 1,   -9, -11,    6,  -5], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 0, 0, 2, 2,   -6,   0,    0,   3], $
[-1, 0, 1, 0, 0,  0,  3, -4, 0, 0, 0, 0, 0,  -16,   8,    0,   0], $
[ 0,-1, 1, 0, 0,  0,  1,  0, 0, 2, 0, 0, 0,    0,   3,    0,   0], $
;/* 61-70 */
[ 0, 1,-1, 2, 0,  0, -1,  0, 0, 2, 0, 0, 0,   11,  24,   11,  -5], $
[ 0, 0, 0, 1, 0,  0, -9, 17, 0, 0, 0, 0, 0,   -3,  -4,   -2,   1], $
[ 0, 0, 0, 2, 0, -3,  5,  0, 0, 0, 0, 0, 0,    3,   0,    0,  -1], $
[ 0, 1,-1, 1, 0,  0, -1,  0,-1, 2, 0, 0, 0,    0,  -8,   -4,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 1,-2, 0, 0, 0,    0,   3,    0,   0], $
[ 1, 0,-2, 0, 0, 17,-16,  0,-2, 0, 0, 0, 0,    0,   5,    0,   0], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 1,-3, 0, 0, 0,    0,   3,    2,   0], $
[-2, 0, 2, 1, 0,  0,  5, -6, 0, 0, 0, 0, 0,   -6,   4,    2,   3], $
[ 0,-2, 2, 0, 0,  0,  9,-13, 0, 0, 0, 0, 0,   -3,  -5,    0,   0], $
[ 0, 1,-1, 2, 0,  0, -1,  0, 0, 1, 0, 0, 0,   -5,   0,    0,   2], $
;/* 71-80 */
[ 0, 0, 0, 1, 0,  0,  0,  0, 0, 1, 0, 0, 0,    4,  24,   13,  -2], $
[ 0,-1, 1, 0, 0,  0,  1,  0, 0, 1, 0, 0, 0,  -42,  20,    0,   0], $
[ 0,-2, 2, 0, 0,  5, -6,  0, 0, 0, 0, 0, 0,  -10, 233,    0,   0], $
[ 0,-1, 1, 1, 0,  5, -7,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   1], $
[-2, 0, 2, 0, 0,  6, -8,  0, 0, 0, 0, 0, 0,   78, -18,    0,   0], $
[ 2, 1,-3, 1, 0, -6,  7,  0, 0, 0, 0, 0, 0,    0,   3,    1,   0], $
[ 0, 0, 0, 2, 0,  0,  0,  0, 1, 0, 0, 0, 0,    0,  -3,   -1,   0], $
[ 0,-1, 1, 1, 0,  0,  1,  0, 1, 0, 0, 0, 0,    0,  -4,   -2,   1], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 0, 0, 2, 0, 0,    0,  -8,   -4,  -1], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 0, 2, 0, 1,    0,  -5,    3,   0], $
;/* 81-90 */
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 0, 2, 0, 2,   -7,   0,    0,   3], $
[ 0, 0, 0, 0, 0,  0, -8, 15, 0, 0, 0, 0, 2,  -14,   8,    3,   6], $
[ 0, 0, 0, 0, 0,  0, -8, 15, 0, 0, 0, 0, 1,    0,   8,   -4,   0], $
[ 0, 1,-1, 1, 0,  0, -9, 15, 0, 0, 0, 0, 0,    0,  19,   10,   0], $
[ 0, 0, 0, 0, 0,  0,  8,-15, 0, 0, 0, 0, 0,   45, -22,    0,   0], $
[ 1,-1,-1, 0, 0,  0,  8,-15, 0, 0, 0, 0, 0,   -3,   0,    0,   0], $
[ 2, 0,-2, 0, 0,  2, -5,  0, 0, 0, 0, 0, 0,    0,  -3,    0,   0], $
[-2, 0, 2, 0, 0,  0,  2,  0,-5, 5, 0, 0, 0,    0,   3,    0,   0], $
[ 2, 0,-2, 1, 0,  0, -6,  8, 0, 0, 0, 0, 0,    3,   5,    3,  -2], $
[ 2, 0,-2, 1, 0,  0, -2,  0, 3, 0, 0, 0, 0,   89, -16,   -9, -48], $
;/* 91-100 */
[-2, 1, 1, 0, 0,  0,  1,  0,-3, 0, 0, 0, 0,    0,   3,    0,   0], $
[-2, 1, 1, 1, 0,  0,  1,  0,-3, 0, 0, 0, 0,   -3,   7,    4,   2], $
[-2, 0, 2, 0, 0,  0,  2,  0,-3, 0, 0, 0, 0, -349, -62,    0,   0], $
[-2, 0, 2, 0, 0,  0,  6, -8, 0, 0, 0, 0, 0,  -15,  22,    0,   0], $
[-2, 0, 2, 0, 0,  0,  2,  0,-1,-5, 0, 0, 0,   -3,   0,    0,   0], $
[-1, 0, 1, 0, 0,  0,  1,  0,-1, 0, 0, 0, 0,  -53,   0,    0,   0], $
[-1, 1, 1, 1, 0,-20, 20,  0, 0, 0, 0, 0, 0,    5,   0,    0,  -3], $
[ 1, 0,-2, 0, 0, 20,-21,  0, 0, 0, 0, 0, 0,    0,  -8,    0,   0], $
[ 0, 0, 0, 1, 0,  0,  8,-15, 0, 0, 0, 0, 0,   15,  -7,   -4,  -8], $
[ 0, 2,-2, 1, 0,  0,-10, 15, 0, 0, 0, 0, 0,   -3,   0,    0,   1], $
;/* 101-110 */
[ 0,-1, 1, 0, 0,  0,  1,  0, 1, 0, 0, 0, 0,  -21, -78,    0,   0], $
[ 0, 0, 0, 1, 0,  0,  0,  0, 1, 0, 0, 0, 0,   20, -70,  -37, -11], $
[ 0, 1,-1, 2, 0,  0, -1,  0, 1, 0, 0, 0, 0,    0,   6,    3,   0], $
[ 0, 1,-1, 1, 0,  0, -1,  0,-2, 4, 0, 0, 0,    5,   3,    2,  -2], $
[ 2, 0,-2, 1, 0, -6,  8,  0, 0, 0, 0, 0, 0,  -17,  -4,   -2,   9], $
[ 0,-2, 2, 1, 0,  5, -6,  0, 0, 0, 0, 0, 0,    0,   6,    3,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0,-1, 0, 0, 1,   32,  15,   -8,  17], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 0,-1, 0, 0, 0,  174,  84,   45, -93], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 1, 0, 0, 0,   11,  56,    0,   0], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 0, 1, 0, 0, 0,  -66, -12,   -6,  35], $
;/* 111-120 */
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 1, 0, 0, 1,   47,   8,    4, -25], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 1, 0, 0, 2,    0,   8,    4,   0], $
[ 0, 2,-2, 1, 0,  0, -9, 13, 0, 0, 0, 0, 0,   10, -22,  -12,  -5], $
[ 0, 0, 0, 1, 0,  0,  7,-13, 0, 0, 0, 0, 0,   -3,   0,    0,   2], $
[-2, 0, 2, 0, 0,  0,  5, -6, 0, 0, 0, 0, 0,  -24,  12,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  9,-17, 0, 0, 0, 0, 0,    5,  -6,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -9, 17, 0, 0, 0, 0, 2,    3,   0,    0,  -2], $
[ 1, 0,-1, 1, 0,  0, -3,  4, 0, 0, 0, 0, 0,    4,   3,    1,  -2], $
[ 1, 0,-1, 1, 0, -3,  4,  0, 0, 0, 0, 0, 0,    0,  29,   15,   0], $
[ 0, 0, 0, 2, 0,  0, -1,  2, 0, 0, 0, 0, 0,   -5,  -4,   -2,   2], $
;/* 121-130 */
[ 0,-1, 1, 1, 0,  0,  0,  2, 0, 0, 0, 0, 0,    8,  -3,   -1,  -5], $
[ 0,-2, 2, 0, 1,  0, -2,  0, 0, 0, 0, 0, 0,    0,  -3,    0,   0], $
[ 0, 0, 0, 0, 0,  3, -5,  0, 2, 0, 0, 0, 0,   10,   0,    0,   0], $
[-2, 0, 2, 1, 0,  0,  2,  0,-3, 1, 0, 0, 0,    3,   0,    0,  -2], $
[-2, 0, 2, 1, 0,  3, -3,  0, 0, 0, 0, 0, 0,   -5,   0,    0,   3], $
[ 0, 0, 0, 1, 0,  8,-13,  0, 0, 0, 0, 0, 0,   46,  66,   35, -25], $
[ 0,-1, 1, 0, 0,  8,-12,  0, 0, 0, 0, 0, 0,  -14,   7,    0,   0], $
[ 0, 2,-2, 1, 0, -8, 11,  0, 0, 0, 0, 0, 0,    0,   3,    2,   0], $
[-1, 0, 1, 0, 0,  0,  2, -2, 0, 0, 0, 0, 0,   -5,   0,    0,   0], $
[-1, 0, 0, 1, 0, 18,-16,  0, 0, 0, 0, 0, 0,  -68, -34,  -18,  36], $
;/* 131-140 */
[ 0, 1,-1, 1, 0,  0, -1,  0,-1, 1, 0, 0, 0,    0,  14,    7,   0], $
[ 0, 0, 0, 1, 0,  3, -7,  4, 0, 0, 0, 0, 0,   10,  -6,   -3,  -5], $
[-2, 1, 1, 1, 0,  0, -3,  7, 0, 0, 0, 0, 0,   -5,  -4,   -2,   3], $
[ 0, 1,-1, 2, 0,  0, -1,  0,-2, 5, 0, 0, 0,   -3,   5,    2,   1], $
[ 0, 0, 0, 1, 0,  0,  0,  0,-2, 5, 0, 0, 0,   76,  17,    9, -41], $
[ 0, 0, 0, 1, 0,  0, -4,  8,-3, 0, 0, 0, 0,   84, 298,  159, -45], $
[ 1, 0, 0, 1, 0,-10,  3,  0, 0, 0, 0, 0, 0,    3,   0,    0,  -1], $
[ 0, 2,-2, 1, 0,  0, -2,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   2], $
[-1, 0, 0, 1, 0, 10, -3,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   1], $
[ 0, 0, 0, 1, 0,  0,  4, -8, 3, 0, 0, 0, 0,  -82, 292,  156,  44], $
;/* 141-150 */
[ 0, 0, 0, 1, 0,  0,  0,  0, 2,-5, 0, 0, 0,  -73,  17,    9,  39], $
[ 0,-1, 1, 0, 0,  0,  1,  0, 2,-5, 0, 0, 0,   -9, -16,    0,   0], $
[ 2,-1,-1, 1, 0,  0,  3, -7, 0, 0, 0, 0, 0,    3,   0,   -1,  -2], $
[-2, 0, 2, 0, 0,  0,  2,  0, 0,-5, 0, 0, 0,   -3,   0,    0,   0], $
[ 0, 0, 0, 1, 0, -3,  7, -4, 0, 0, 0, 0, 0,   -9,  -5,   -3,   5], $
[-2, 0, 2, 0, 0,  0,  2,  0,-2, 0, 0, 0, 0, -439,   0,    0,   0], $
[ 1, 0, 0, 1, 0,-18, 16,  0, 0, 0, 0, 0, 0,   57, -28,  -15, -30], $
[-2, 1, 1, 1, 0,  0,  1,  0,-2, 0, 0, 0, 0,    0,  -6,   -3,   0], $
[ 0, 1,-1, 2, 0, -8, 12,  0, 0, 0, 0, 0, 0,   -4,   0,    0,   2], $
[ 0, 0, 0, 1, 0, -8, 13,  0, 0, 0, 0, 0, 0,  -40,  57,   30,  21], $
;/* 151-160 */
[ 0, 0, 0, 0, 0,  0,  1, -2, 0, 0, 0, 0, 1,   23,   7,    3, -13], $
[ 0, 1,-1, 1, 0,  0,  0, -2, 0, 0, 0, 0, 0,  273,  80,   43,-146], $
[ 0, 0, 0, 0, 0,  0,  1, -2, 0, 0, 0, 0, 0, -449, 430,    0,   0], $
[ 0, 1,-1, 1, 0,  0, -2,  2, 0, 0, 0, 0, 0,   -8, -47,  -25,   4], $
[ 0, 0, 0, 0, 0,  0, -1,  2, 0, 0, 0, 0, 1,    6,  47,   25,  -3], $
[-1, 0, 1, 1, 0,  3, -4,  0, 0, 0, 0, 0, 0,    0,  23,   13,   0], $
[-1, 0, 1, 1, 0,  0,  3, -4, 0, 0, 0, 0, 0,   -3,   0,    0,   2], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 0,-2, 0, 0, 0,    3,  -4,   -2,  -2], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 0, 2, 0, 0, 0,  -48,-110,  -59,  26], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 2, 0, 0, 1,   51, 114,   61, -27], $
;/* 161-170 */
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 2, 0, 0, 2, -133,   0,    0,  57], $
[ 0, 1,-1, 0, 0,  3, -6,  0, 0, 0, 0, 0, 0,    0,   4,    0,   0], $
[ 0, 0, 0, 1, 0, -3,  5,  0, 0, 0, 0, 0, 0,  -21,  -6,   -3,  11], $
[ 0, 1,-1, 2, 0, -3,  4,  0, 0, 0, 0, 0, 0,    0,  -3,   -1,   0], $
[ 0, 0, 0, 1, 0,  0, -2,  4, 0, 0, 0, 0, 0,  -11, -21,  -11,   6], $
[ 0, 2,-2, 1, 0, -5,  6,  0, 0, 0, 0, 0, 0,  -18,-436, -233,   9], $
[ 0,-1, 1, 0, 0,  5, -7,  0, 0, 0, 0, 0, 0,   35,  -7,    0,   0], $
[ 0, 0, 0, 1, 0,  5, -8,  0, 0, 0, 0, 0, 0,    0,   5,    3,   0], $
[-2, 0, 2, 1, 0,  6, -8,  0, 0, 0, 0, 0, 0,   11,  -3,   -1,  -6], $
[ 0, 0, 0, 1, 0,  0, -8, 15, 0, 0, 0, 0, 0,   -5,  -3,   -1,   3], $

;/* 171-180 */
[-2, 0, 2, 1, 0,  0,  2,  0,-3, 0, 0, 0, 0,  -53,  -9,   -5,  28], $
[-2, 0, 2, 1, 0,  0,  6, -8, 0, 0, 0, 0, 0,    0,   3,    2,   1], $
[ 1, 0,-1, 1, 0,  0, -1,  0, 1, 0, 0, 0, 0,    4,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 3,-5, 0, 0, 0,    0,  -4,    0,   0], $
[ 0, 1,-1, 1, 0,  0, -1,  0,-1, 0, 0, 0, 0,  -50, 194,  103,  27], $
[ 0, 0, 0, 0, 0,  0,  0,  0,-1, 0, 0, 0, 1,  -13,  52,   28,   7], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 1, 0, 0, 0, 0,  -91, 248,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 1, 0, 0, 0, 1,    6,  49,   26,  -3], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 1, 0, 0, 0, 0,   -6, -47,  -25,   3], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 1, 0, 0, 0, 1,    0,   5,    3,   0], $
;/* 181-190 */
[ 0, 0, 0, 0, 0,  0,  0,  0, 1, 0, 0, 0, 2,   52,  23,   10, -23], $
[ 0, 1,-1, 2, 0,  0, -1,  0, 0,-1, 0, 0, 0,   -3,   0,    0,   1], $
[ 0, 0, 0, 1, 0,  0,  0,  0, 0,-1, 0, 0, 0,    0,   5,    3,   0], $
[ 0,-1, 1, 0, 0,  0,  1,  0, 0,-1, 0, 0, 0,   -4,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -7, 13, 0, 0, 0, 0, 2,   -4,   8,    3,   2], $
[ 0, 0, 0, 0, 0,  0,  7,-13, 0, 0, 0, 0, 0,   10,   0,    0,   0], $
[ 2, 0,-2, 1, 0,  0, -5,  6, 0, 0, 0, 0, 0,    3,   0,    0,  -2], $
[ 0, 2,-2, 1, 0,  0, -8, 11, 0, 0, 0, 0, 0,    0,   8,    4,   0], $
[ 0, 2,-2, 1,-1,  0,  2,  0, 0, 0, 0, 0, 0,    0,   8,    4,   1], $
[-2, 0, 2, 0, 0,  0,  4, -4, 0, 0, 0, 0, 0,   -4,   0,    0,   0], $
;/* 191-200 */
[ 0, 0, 0, 0, 0,  0,  0,  0, 2,-2, 0, 0, 0,   -4,   0,    0,   0], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 0, 3, 0, 0, 0,   -8,   4,    2,   4], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 3, 0, 0, 1,    8,  -4,   -2,  -4], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 3, 0, 0, 2,    0,  15,    7,   0], $
[-2, 0, 2, 0, 0,  3, -3,  0, 0, 0, 0, 0, 0, -138,   0,    0,   0], $
[ 0, 0, 0, 2, 0,  0, -4,  8,-3, 0, 0, 0, 0,    0,  -7,   -3,   0], $
[ 0, 0, 0, 2, 0,  0,  4, -8, 3, 0, 0, 0, 0,    0,  -7,   -3,   0], $
[ 2, 0,-2, 1, 0,  0, -2,  0, 2, 0, 0, 0, 0,   54,   0,    0, -29], $
[ 0, 1,-1, 2, 0,  0, -1,  0, 2, 0, 0, 0, 0,    0,  10,    4,   0], $
[ 0, 1,-1, 2, 0,  0,  0, -2, 0, 0, 0, 0, 0,   -7,   0,    0,   3], $
;/* 201-210 */
[ 0, 0, 0, 1, 0,  0,  1, -2, 0, 0, 0, 0, 0,  -37,  35,   19,  20], $
[ 0,-1, 1, 0, 0,  0,  2, -2, 0, 0, 0, 0, 0,    0,   4,    0,   0], $
[ 0,-1, 1, 0, 0,  0,  1,  0, 0,-2, 0, 0, 0,   -4,   9,    0,   0], $
[ 0, 2,-2, 1, 0,  0, -2,  0, 0, 2, 0, 0, 0,    8,   0,    0,  -4], $
[ 0, 1,-1, 1, 0,  3, -6,  0, 0, 0, 0, 0, 0,   -9, -14,   -8,   5], $
[ 0, 0, 0, 0, 0,  3, -5,  0, 0, 0, 0, 0, 1,   -3,  -9,   -5,   3], $
[ 0, 0, 0, 0, 0,  3, -5,  0, 0, 0, 0, 0, 0, -145,  47,    0,   0], $
[ 0, 1,-1, 1, 0, -3,  4,  0, 0, 0, 0, 0, 0,  -10,  40,   21,   5], $
[ 0, 0, 0, 0, 0, -3,  5,  0, 0, 0, 0, 0, 1,   11, -49,  -26,  -7], $
[ 0, 0, 0, 0, 0, -3,  5,  0, 0, 0, 0, 0, 2,-2150,   0,    0, 932], $
;/* 211-220 */
[ 0, 2,-2, 2, 0, -3,  3,  0, 0, 0, 0, 0, 0,  -12,   0,    0,   5], $
[ 0, 0, 0, 0, 0, -3,  5,  0, 0, 0, 0, 0, 2,   85,   0,    0, -37], $
[ 0, 0, 0, 0, 0,  0,  2, -4, 0, 0, 0, 0, 1,    4,   0,    0,  -2], $
[ 0, 1,-1, 1, 0,  0,  1, -4, 0, 0, 0, 0, 0,    3,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  0,  2, -4, 0, 0, 0, 0, 0,  -86, 153,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -2,  4, 0, 0, 0, 0, 1,   -6,   9,    5,   3], $
[ 0, 1,-1, 1, 0,  0, -3,  4, 0, 0, 0, 0, 0,    9, -13,   -7,  -5], $
[ 0, 0, 0, 0, 0,  0, -2,  4, 0, 0, 0, 0, 1,   -8,  12,    6,   4], $
[ 0, 0, 0, 0, 0,  0, -2,  4, 0, 0, 0, 0, 2,  -51,   0,    0,  22], $
[ 0, 0, 0, 0, 0, -5,  8,  0, 0, 0, 0, 0, 2,  -11,-268, -116,   5], $
;/* 221-230 */
[ 0, 2,-2, 2, 0, -5,  6,  0, 0, 0, 0, 0, 0,    0,  12,    5,   0], $
[ 0, 0, 0, 0, 0, -5,  8,  0, 0, 0, 0, 0, 2,    0,   7,    3,   0], $
[ 0, 0, 0, 0, 0, -5,  8,  0, 0, 0, 0, 0, 1,   31,   6,    3, -17], $
[ 0, 1,-1, 1, 0, -5,  7,  0, 0, 0, 0, 0, 0,  140,  27,   14, -75], $
[ 0, 0, 0, 0, 0, -5,  8,  0, 0, 0, 0, 0, 1,   57,  11,    6, -30], $
[ 0, 0, 0, 0, 0,  5, -8,  0, 0, 0, 0, 0, 0,  -14, -39,    0,   0], $
[ 0, 1,-1, 2, 0,  0, -1,  0,-1, 0, 0, 0, 0,    0,  -6,   -2,   0], $
[ 0, 0, 0, 1, 0,  0,  0,  0,-1, 0, 0, 0, 0,    4,  15,    8,  -2], $
[ 0,-1, 1, 0, 0,  0,  1,  0,-1, 0, 0, 0, 0,    0,   4,    0,   0], $
[ 0, 2,-2, 1, 0,  0, -2,  0, 1, 0, 0, 0, 0,   -3,   0,    0,   1], $
;/* 231-240 */
[ 0, 0, 0, 0, 0,  0, -6, 11, 0, 0, 0, 0, 2,    0,  11,    5,   0], $
[ 0, 0, 0, 0, 0,  0,  6,-11, 0, 0, 0, 0, 0,    9,   6,    0,   0], $
[ 0, 0, 0, 0,-1,  0,  4,  0, 0, 0, 0, 0, 2,   -4,  10,    4,   2], $
[ 0, 0, 0, 0, 1,  0, -4,  0, 0, 0, 0, 0, 0,    5,   3,    0,   0], $
[ 2, 0,-2, 1, 0, -3,  3,  0, 0, 0, 0, 0, 0,   16,   0,    0,  -9], $
[-2, 0, 2, 0, 0,  0,  2,  0, 0,-2, 0, 0, 0,   -3,   0,    0,   0], $
[ 0, 2,-2, 1, 0,  0, -7,  9, 0, 0, 0, 0, 0,    0,   3,    2,  -1], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 4,-5, 0, 0, 2,    7,   0,    0,  -3], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 2, 0, 0, 0, 0,  -25,  22,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 2, 0, 0, 0, 1,   42, 223,  119, -22], $
;/* 241-250 */
[ 0, 1,-1, 1, 0,  0, -1,  0, 2, 0, 0, 0, 0,  -27,-143,  -77,  14], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 2, 0, 0, 0, 1,    9,  49,   26,  -5], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 2, 0, 0, 0, 2,-1166,   0,    0, 505], $
[ 0, 2,-2, 2, 0,  0, -2,  0, 2, 0, 0, 0, 0,   -5,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 5, 0, 0, 2,   -6,   0,    0,   3], $
[ 0, 0, 0, 1, 0,  3, -5,  0, 0, 0, 0, 0, 0,   -8,   0,    1,   4], $
[ 0,-1, 1, 0, 0,  3, -4,  0, 0, 0, 0, 0, 0,    0,  -4,    0,   0], $
[ 0, 2,-2, 1, 0, -3,  3,  0, 0, 0, 0, 0, 0,  117,   0,    0, -63], $
[ 0, 0, 0, 1, 0,  0,  2, -4, 0, 0, 0, 0, 0,   -4,   8,    4,   2], $
[ 0, 2,-2, 1, 0,  0, -4,  4, 0, 0, 0, 0, 0,    3,   0,    0,  -2], $
;/* 251-260 */
[ 0, 1,-1, 2, 0, -5,  7,  0, 0, 0, 0, 0, 0,   -5,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  0,  3, -6, 0, 0, 0, 0, 0,    0,  31,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -3,  6, 0, 0, 0, 0, 1,   -5,   0,    1,   3], $
[ 0, 1,-1, 1, 0,  0, -4,  6, 0, 0, 0, 0, 0,    4,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  0, -3,  6, 0, 0, 0, 0, 1,   -4,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  0, -3,  6, 0, 0, 0, 0, 2,  -24, -13,   -6,  10], $
[ 0,-1, 1, 0, 0,  2, -2,  0, 0, 0, 0, 0, 0,    3,   0,    0,   0], $
[ 0, 0, 0, 1, 0,  2, -3,  0, 0, 0, 0, 0, 0,    0, -32,  -17,   0], $
[ 0, 0, 0, 0, 0,  0, -5,  9, 0, 0, 0, 0, 2,    8,  12,    5,  -3], $
[ 0, 0, 0, 0, 0,  0, -5,  9, 0, 0, 0, 0, 1,    3,   0,    0,  -1], $
;/* 261-270 */
[ 0, 0, 0, 0, 0,  0,  5, -9, 0, 0, 0, 0, 0,    7,  13,    0,   0], $
[ 0,-1, 1, 0, 0,  0,  1,  0,-2, 0, 0, 0, 0,   -3,  16,    0,   0], $
[ 0, 2,-2, 1, 0,  0, -2,  0, 2, 0, 0, 0, 0,   50,   0,    0, -27], $
[-2, 1, 1, 1, 0,  0,  1,  0, 0, 0, 0, 0, 0,    0,  -5,   -3,   0], $
[ 0,-2, 2, 0, 0,  3, -3,  0, 0, 0, 0, 0, 0,   13,   0,    0,   0], $
[ 0, 0, 0, 0, 0, -6, 10,  0, 0, 0, 0, 0, 1,    0,   5,    3,   1], $
[ 0, 0, 0, 0, 0, -6, 10,  0, 0, 0, 0, 0, 2,   24,   5,    2, -11], $
[ 0, 0, 0, 0, 0, -2,  3,  0, 0, 0, 0, 0, 2,    5, -11,   -5,  -2], $
[ 0, 0, 0, 0, 0, -2,  3,  0, 0, 0, 0, 0, 1,   30,  -3,   -2, -16], $
[ 0, 1,-1, 1, 0, -2,  2,  0, 0, 0, 0, 0, 0,   18,   0,    0,  -9], $
;/* 271-280 */
[ 0, 0, 0, 0, 0,  2, -3,  0, 0, 0, 0, 0, 0,    8, 614,    0,   0], $
[ 0, 0, 0, 0, 0,  2, -3,  0, 0, 0, 0, 0, 1,    3,  -3,   -1,  -2], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 3, 0, 0, 0, 1,    6,  17,    9,  -3], $
[ 0, 1,-1, 1, 0,  0, -1,  0, 3, 0, 0, 0, 0,   -3,  -9,   -5,   2], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 3, 0, 0, 0, 1,    0,   6,    3,  -1], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 3, 0, 0, 0, 2, -127,  21,    9,  55], $
[ 0, 0, 0, 0, 0,  0,  4, -8, 0, 0, 0, 0, 0,    3,   5,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -4,  8, 0, 0, 0, 0, 2,   -6, -10,   -4,   3], $
[ 0,-2, 2, 0, 0,  0,  2,  0,-2, 0, 0, 0, 0,    5,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -4,  7, 0, 0, 0, 0, 2,   16,   9,    4,  -7], $
;/* 281-290 */
[ 0, 0, 0, 0, 0,  0, -4,  7, 0, 0, 0, 0, 1,    3,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  0,  4, -7, 0, 0, 0, 0, 0,    0,  22,    0,   0], $
[ 0, 0, 0, 1, 0, -2,  3,  0, 0, 0, 0, 0, 0,    0,  19,   10,   0], $
[ 0, 2,-2, 1, 0,  0, -2,  0, 3, 0, 0, 0, 0,    7,   0,    0,  -4], $
[ 0, 0, 0, 0, 0,  0, -5, 10, 0, 0, 0, 0, 2,    0,  -5,   -2,   0], $
[ 0, 0, 0, 1, 0, -1,  2,  0, 0, 0, 0, 0, 0,    0,   3,    1,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  0, 4, 0, 0, 0, 2,   -9,   3,    1,   4], $
[ 0, 0, 0, 0, 0,  0, -3,  5, 0, 0, 0, 0, 2,   17,   0,    0,  -7], $
[ 0, 0, 0, 0, 0,  0, -3,  5, 0, 0, 0, 0, 1,    0,  -3,   -2,  -1], $
[ 0, 0, 0, 0, 0,  0,  3, -5, 0, 0, 0, 0, 0,  -20,  34,    0,   0], $
;/* 291-300 */
[ 0, 0, 0, 0, 0,  1, -2,  0, 0, 0, 0, 0, 1,  -10,   0,    1,   5], $
[ 0, 1,-1, 1, 0,  1, -3,  0, 0, 0, 0, 0, 0,   -4,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  1, -2,  0, 0, 0, 0, 0, 0,   22, -87,    0,   0], $
[ 0, 0, 0, 0, 0, -1,  2,  0, 0, 0, 0, 0, 1,   -4,   0,    0,   2], $
[ 0, 0, 0, 0, 0, -1,  2,  0, 0, 0, 0, 0, 2,   -3,  -6,   -2,   1], $
[ 0, 0, 0, 0, 0, -7, 11,  0, 0, 0, 0, 0, 2,  -16,  -3,   -1,   7], $
[ 0, 0, 0, 0, 0, -7, 11,  0, 0, 0, 0, 0, 1,    0,  -3,   -2,   0], $
[ 0,-2, 2, 0, 0,  4, -4,  0, 0, 0, 0, 0, 0,    4,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  2, -3, 0, 0, 0, 0, 0,  -68,  39,    0,   0], $
[ 0, 2,-2, 1, 0, -4,  4,  0, 0, 0, 0, 0, 0,   27,   0,    0, -14], $
;/* 301-310 */
[ 0,-1, 1, 0, 0,  4, -5,  0, 0, 0, 0, 0, 0,    0,  -4,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  1, -1, 0, 0, 0, 0, 0,  -25,   0,    0,   0], $
[ 0, 0, 0, 0, 0, -4,  7,  0, 0, 0, 0, 0, 1,  -12,  -3,   -2,   6], $
[ 0, 1,-1, 1, 0, -4,  6,  0, 0, 0, 0, 0, 0,    3,   0,    0,  -1], $
[ 0, 0, 0, 0, 0, -4,  7,  0, 0, 0, 0, 0, 2,    3,  66,   29,  -1], $
[ 0, 0, 0, 0, 0, -4,  6,  0, 0, 0, 0, 0, 2,  490,   0,    0,-213], $
[ 0, 0, 0, 0, 0, -4,  6,  0, 0, 0, 0, 0, 1,  -22,  93,   49,  12], $
[ 0, 1,-1, 1, 0, -4,  5,  0, 0, 0, 0, 0, 0,   -7,  28,   15,   4], $
[ 0, 0, 0, 0, 0, -4,  6,  0, 0, 0, 0, 0, 1,   -3,  13,    7,   2], $
[ 0, 0, 0, 0, 0,  4, -6,  0, 0, 0, 0, 0, 0,  -46,  14,    0,   0], $
;/* 311-320 */
[-2, 0, 2, 0, 0,  2, -2,  0, 0, 0, 0, 0, 0,   -5,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  1, 0, 0, 0, 0, 0,    2,   1,    0,   0], $
[ 0,-1, 1, 0, 0,  1,  0,  0, 0, 0, 0, 0, 0,    0,  -3,    0,   0], $
[ 0, 0, 0, 1, 0,  1, -1,  0, 0, 0, 0, 0, 0,  -28,   0,    0,  15], $
[ 0, 0, 0, 0, 0,  0, -1,  0, 5, 0, 0, 0, 2,    5,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  0,  1, -3, 0, 0, 0, 0, 0,    0,   3,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -1,  3, 0, 0, 0, 0, 2,  -11,   0,    0,   5], $
[ 0, 0, 0, 0, 0,  0, -7, 12, 0, 0, 0, 0, 2,    0,   3,    1,   0], $
[ 0, 0, 0, 0, 0, -1,  1,  0, 0, 0, 0, 0, 2,   -3,   0,    0,   1], $
[ 0, 0, 0, 0, 0, -1,  1,  0, 0, 0, 0, 0, 1,   25, 106,   57, -13], $
;/* 321-330 */
[ 0, 1,-1, 1, 0, -1,  0,  0, 0, 0, 0, 0, 0,    5,  21,   11,  -3], $
[ 0, 0, 0, 0, 0,  1, -1,  0, 0, 0, 0, 0, 0, 1485,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  1, -1,  0, 0, 0, 0, 0, 1,   -7, -32,  -17,   4], $
[ 0, 1,-1, 1, 0,  1, -2,  0, 0, 0, 0, 0, 0,    0,   5,    3,   0], $
[ 0, 0, 0, 0, 0,  0, -2,  5, 0, 0, 0, 0, 2,   -6,  -3,   -2,   3], $
[ 0, 0, 0, 0, 0,  0, -1,  0, 4, 0, 0, 0, 2,   30,  -6,   -2, -13], $
[ 0, 0, 0, 0, 0,  0,  1,  0,-4, 0, 0, 0, 0,   -4,   4,    0,   0], $
[ 0, 0, 0, 1, 0, -1,  1,  0, 0, 0, 0, 0, 0,  -19,   0,    0,  10], $
[ 0, 0, 0, 0, 0,  0, -6, 10, 0, 0, 0, 0, 2,    0,   4,    2,  -1], $
[ 0, 0, 0, 0, 0,  0, -6, 10, 0, 0, 0, 0, 0,    0,   3,    0,   0], $
;/* 331-340 */
[ 0, 2,-2, 1, 0,  0, -3,  0, 3, 0, 0, 0, 0,    4,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  0, -3,  7, 0, 0, 0, 0, 2,    0,  -3,   -1,   0], $
[-2, 0, 2, 0, 0,  4, -4,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -5,  8, 0, 0, 0, 0, 2,    5,   3,    1,  -2], $
[ 0, 0, 0, 0, 0,  0,  5, -8, 0, 0, 0, 0, 0,    0,  11,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -1,  0, 3, 0, 0, 0, 2,  118,   0,    0, -52], $
[ 0, 0, 0, 0, 0,  0, -1,  0, 3, 0, 0, 0, 1,    0,  -5,   -3,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0,-3, 0, 0, 0, 0,  -28,  36,    0,   0], $
[ 0, 0, 0, 0, 0,  2, -4,  0, 0, 0, 0, 0, 0,    5,  -5,    0,   0], $
[ 0, 0, 0, 0, 0, -2,  4,  0, 0, 0, 0, 0, 1,   14, -59,  -31,  -8], $
;/* 341-350 */
[ 0, 1,-1, 1, 0, -2,  3,  0, 0, 0, 0, 0, 0,    0,   9,    5,   1], $
[ 0, 0, 0, 0, 0, -2,  4,  0, 0, 0, 0, 0, 2, -458,   0,    0, 198], $
[ 0, 0, 0, 0, 0, -6,  9,  0, 0, 0, 0, 0, 2,    0, -45,  -20,   0], $
[ 0, 0, 0, 0, 0, -6,  9,  0, 0, 0, 0, 0, 1,    9,   0,    0,  -5], $
[ 0, 0, 0, 0, 0,  6, -9,  0, 0, 0, 0, 0, 0,    0,  -3,    0,   0], $
[ 0, 0, 0, 1, 0,  0,  1,  0,-2, 0, 0, 0, 0,    0,  -4,   -2,  -1], $
[ 0, 2,-2, 1, 0, -2,  2,  0, 0, 0, 0, 0, 0,   11,   0,    0,  -6], $
[ 0, 0, 0, 0, 0,  0, -4,  6, 0, 0, 0, 0, 2,    6,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  0,  4, -6, 0, 0, 0, 0, 0,  -16,  23,    0,   0], $
[ 0, 0, 0, 1, 0,  3, -4,  0, 0, 0, 0, 0, 0,    0,  -4,   -2,   0], $
;/* 351-360 */
[ 0, 0, 0, 0, 0,  0, -1,  0, 2, 0, 0, 0, 2,   -5,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  0,  1,  0,-2, 0, 0, 0, 0, -166, 269,    0,   0], $
[ 0, 0, 0, 1, 0,  0,  1,  0,-1, 0, 0, 0, 0,   15,   0,    0,  -8], $
[ 0, 0, 0, 0, 0, -5,  9,  0, 0, 0, 0, 0, 2,   10,   0,    0,  -4], $
[ 0, 0, 0, 0, 0,  0,  3, -4, 0, 0, 0, 0, 0,  -78,  45,    0,   0], $
[ 0, 0, 0, 0, 0, -3,  4,  0, 0, 0, 0, 0, 2,    0,  -5,   -2,   0], $
[ 0, 0, 0, 0, 0, -3,  4,  0, 0, 0, 0, 0, 1,    7,   0,    0,  -4], $
[ 0, 0, 0, 0, 0,  3, -4,  0, 0, 0, 0, 0, 0,   -5, 328,    0,   0], $
[ 0, 0, 0, 0, 0,  3, -4,  0, 0, 0, 0, 0, 1,    3,   0,    0,  -2], $
[ 0, 0, 0, 1, 0,  0,  2, -2, 0, 0, 0, 0, 0,    5,   0,    0,  -2], $
;/* 361-370 */
[ 0, 0, 0, 1, 0,  0, -1,  0, 2, 0, 0, 0, 0,    0,   3,    1,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 0,-3, 0, 0, 0,   -3,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 1,-5, 0, 0, 0,   -3,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -1,  0, 1, 0, 0, 0, 1,    0,  -4,   -2,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0,-1, 0, 0, 0, 0,-1223, -26,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0,-1, 0, 0, 0, 1,    0,   7,    3,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0,-3, 5, 0, 0, 0,    3,   0,    0,   0], $
[ 0, 0, 0, 1, 0, -3,  4,  0, 0, 0, 0, 0, 0,    0,   3,    2,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 0,-2, 0, 0, 0,   -6,  20,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  2, -2, 0, 0, 0, 0, 0, -368,   0,    0,   0], $
;/* 371-380 */
[ 0, 0, 0, 0, 0,  0,  1,  0, 0,-1, 0, 0, 0,  -75,   0,    0,   0], $
[ 0, 0, 0, 1, 0,  0, -1,  0, 1, 0, 0, 0, 0,   11,   0,    0,  -6], $
[ 0, 0, 0, 1, 0,  0, -2,  2, 0, 0, 0, 0, 0,    3,   0,    0,  -2], $
[ 0, 0, 0, 0, 0, -8, 14,  0, 0, 0, 0, 0, 2,   -3,   0,    0,   1], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 2,-5, 0, 0, 0,  -13, -30,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  5, -8, 3, 0, 0, 0, 0,   21,   3,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  5, -8, 3, 0, 0, 0, 2,   -3,   0,    0,   1], $
[ 0, 0, 0, 0, 0,  0, -1,  0, 0, 0, 0, 0, 1,   -4,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 0, 0, 0, 0, 0,    8, -27,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  3, -8, 3, 0, 0, 0, 0,  -19, -11,    0,   0], $
;/* 381-390 */
[ 0, 0, 0, 0, 0,  0, -3,  8,-3, 0, 0, 0, 2,   -4,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  0,  1,  0,-2, 5, 0, 0, 2,    0,   5,    2,   0], $
[ 0, 0, 0, 0, 0, -8, 12,  0, 0, 0, 0, 0, 2,   -6,   0,    0,   2], $
[ 0, 0, 0, 0, 0, -8, 12,  0, 0, 0, 0, 0, 0,   -8,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 1,-2, 0, 0, 0,   -1,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 0, 1, 0, 0, 2,  -14,   0,    0,   6], $
[ 0, 0, 0, 0, 0,  0,  0,  2, 0, 0, 0, 0, 0,    6,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  0,  2, 0, 0, 0, 0, 2,  -74,   0,    0,  32], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 0, 2, 0, 0, 2,    0,  -3,   -1,   0], $
[ 0, 2,-2, 1, 0, -5,  5,  0, 0, 0, 0, 0, 0,    4,   0,    0,  -2], $
;/* 391-400 */
[ 0, 0, 0, 0, 0,  0,  1,  0, 1, 0, 0, 0, 0,    8,  11,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 1, 0, 0, 0, 1,    0,   3,    2,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 1, 0, 0, 0, 2, -262,   0,    0, 114], $
[ 0, 0, 0, 0, 0,  3, -6,  0, 0, 0, 0, 0, 0,    0,  -4,    0,   0], $
[ 0, 0, 0, 0, 0, -3,  6,  0, 0, 0, 0, 0, 1,   -7,   0,    0,   4], $
[ 0, 0, 0, 0, 0, -3,  6,  0, 0, 0, 0, 0, 2,    0, -27,  -12,   0], $
[ 0, 0, 0, 0, 0,  0, -1,  4, 0, 0, 0, 0, 2,  -19,  -8,   -4,   8], $
[ 0, 0, 0, 0, 0, -5,  7,  0, 0, 0, 0, 0, 2,  202,   0,    0, -87], $
[ 0, 0, 0, 0, 0, -5,  7,  0, 0, 0, 0, 0, 1,   -8,  35,   19,   5], $
[ 0, 1,-1, 1, 0, -5,  6,  0, 0, 0, 0, 0, 0,    0,   4,    2,   0], $
;/* 401-410 */
[ 0, 0, 0, 0, 0,  5, -7,  0, 0, 0, 0, 0, 0,   16,  -5,    0,   0], $
[ 0, 2,-2, 1, 0,  0, -1,  0, 1, 0, 0, 0, 0,    5,   0,    0,  -3], $
[ 0, 0, 0, 0, 0,  0, -1,  0, 1, 0, 0, 0, 0,    0,  -3,    0,   0], $
[ 0, 0, 0, 0,-1,  0,  3,  0, 0, 0, 0, 0, 2,    1,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 2, 0, 0, 0, 2,  -35, -48,  -21,  15], $
[ 0, 0, 0, 0, 0,  0, -2,  6, 0, 0, 0, 0, 2,   -3,  -5,   -2,   1], $
[ 0, 0, 0, 1, 0,  2, -2,  0, 0, 0, 0, 0, 0,    6,   0,    0,  -3], $
[ 0, 0, 0, 0, 0,  0, -6,  9, 0, 0, 0, 0, 2,    3,   0,    0,  -1], $
[ 0, 0, 0, 0, 0,  0,  6, -9, 0, 0, 0, 0, 0,    0,  -5,    0,   0], $
[ 0, 0, 0, 0, 0, -2,  2,  0, 0, 0, 0, 0, 1,   12,  55,   29,  -6], $
;/* 411-420 */
[ 0, 1,-1, 1, 0, -2,  1,  0, 0, 0, 0, 0, 0,    0,   5,    3,   0], $
[ 0, 0, 0, 0, 0,  2, -2,  0, 0, 0, 0, 0, 0, -598,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  2, -2,  0, 0, 0, 0, 0, 1,   -3, -13,   -7,   1], $
[ 0, 0, 0, 0, 0,  0,  1,  0, 3, 0, 0, 0, 2,   -5,  -7,   -3,   2], $
[ 0, 0, 0, 0, 0,  0, -5,  7, 0, 0, 0, 0, 2,    3,   0,    0,  -1], $
[ 0, 0, 0, 0, 0,  0,  5, -7, 0, 0, 0, 0, 0,    5,  -7,    0,   0], $
[ 0, 0, 0, 1, 0, -2,  2,  0, 0, 0, 0, 0, 0,    4,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  0,  4, -5, 0, 0, 0, 0, 0,   16,  -6,    0,   0], $
[ 0, 0, 0, 0, 0,  1, -3,  0, 0, 0, 0, 0, 0,    8,  -3,    0,   0], $
[ 0, 0, 0, 0, 0, -1,  3,  0, 0, 0, 0, 0, 1,    8, -31,  -16,  -4], $
;/* 421-430 */
[ 0, 1,-1, 1, 0, -1,  2,  0, 0, 0, 0, 0, 0,    0,   3,    1,   0], $
[ 0, 0, 0, 0, 0, -1,  3,  0, 0, 0, 0, 0, 2,  113,   0,    0, -49], $
[ 0, 0, 0, 0, 0, -7, 10,  0, 0, 0, 0, 0, 2,    0, -24,  -10,   0], $
[ 0, 0, 0, 0, 0, -7, 10,  0, 0, 0, 0, 0, 1,    4,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  0,  3, -3, 0, 0, 0, 0, 0,   27,   0,    0,   0], $
[ 0, 0, 0, 0, 0, -4,  8,  0, 0, 0, 0, 0, 2,   -3,   0,    0,   1], $
[ 0, 0, 0, 0, 0, -4,  5,  0, 0, 0, 0, 0, 2,    0,  -4,   -2,   0], $
[ 0, 0, 0, 0, 0, -4,  5,  0, 0, 0, 0, 0, 1,    5,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  4, -5,  0, 0, 0, 0, 0, 0,    0,  -3,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  1, 0, 0, 0, 0, 2,  -13,   0,    0,   6], $
;/* 431-440 */
[ 0, 0, 0, 0, 0,  0, -2,  0, 5, 0, 0, 0, 2,    5,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  0,  0,  3, 0, 0, 0, 0, 2,  -18, -10,   -4,   8], $
[ 0, 0, 0, 0, 0,  1,  0,  0, 0, 0, 0, 0, 0,   -4, -28,    0,   0], $
[ 0, 0, 0, 0, 0,  1,  0,  0, 0, 0, 0, 0, 2,   -5,   6,    3,   2], $
[ 0, 0, 0, 0, 0, -9, 13,  0, 0, 0, 0, 0, 2,   -3,   0,    0,   1], $
[ 0, 0, 0, 0, 0,  0, -1,  5, 0, 0, 0, 0, 2,   -5,  -9,   -4,   2], $
[ 0, 0, 0, 0, 0,  0, -2,  0, 4, 0, 0, 0, 2,   17,   0,    0,  -7], $
[ 0, 0, 0, 0, 0,  0,  2,  0,-4, 0, 0, 0, 0,   11,   4,    0,   0], $
[ 0, 0, 0, 0, 0,  0, -2,  7, 0, 0, 0, 0, 2,    0,  -6,   -2,   0], $
[ 0, 0, 0, 0, 0,  0,  2,  0,-3, 0, 0, 0, 0,   83,  15,    0,   0], $
;/* 441-450 */
[ 0, 0, 0, 0, 0, -2,  5,  0, 0, 0, 0, 0, 1,   -4,   0,    0,   2], $
[ 0, 0, 0, 0, 0, -2,  5,  0, 0, 0, 0, 0, 2,    0,-114,  -49,   0], $
[ 0, 0, 0, 0, 0, -6,  8,  0, 0, 0, 0, 0, 2,  117,   0,    0, -51], $
[ 0, 0, 0, 0, 0, -6,  8,  0, 0, 0, 0, 0, 1,   -5,  19,   10,   2], $
[ 0, 0, 0, 0, 0,  6, -8,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   0], $
[ 0, 0, 0, 1, 0,  0,  2,  0,-2, 0, 0, 0, 0,   -3,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  0, -3,  9, 0, 0, 0, 0, 2,    0,  -3,   -1,   0], $
[ 0, 0, 0, 0, 0,  0,  5, -6, 0, 0, 0, 0, 0,    3,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  5, -6, 0, 0, 0, 0, 2,    0,  -6,   -2,   0], $
[ 0, 0, 0, 0, 0,  0,  2,  0,-2, 0, 0, 0, 0,  393,   3,    0,   0], $
;/* 451-460 */
[ 0, 0, 0, 0, 0,  0,  2,  0,-2, 0, 0, 0, 1,   -4,  21,   11,   2], $
[ 0, 0, 0, 0, 0,  0,  2,  0,-2, 0, 0, 0, 2,   -6,   0,   -1,   3], $
[ 0, 0, 0, 0, 0, -5, 10,  0, 0, 0, 0, 0, 2,   -3,   8,    4,   1], $
[ 0, 0, 0, 0, 0,  0,  4, -4, 0, 0, 0, 0, 0,    8,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  4, -4, 0, 0, 0, 0, 2,   18, -29,  -13,  -8], $
[ 0, 0, 0, 0, 0, -3,  3,  0, 0, 0, 0, 0, 1,    8,  34,   18,  -4], $
[ 0, 0, 0, 0, 0,  3, -3,  0, 0, 0, 0, 0, 0,   89,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  3, -3,  0, 0, 0, 0, 0, 1,    3,  12,    6,  -1], $
[ 0, 0, 0, 0, 0,  3, -3,  0, 0, 0, 0, 0, 2,   54, -15,   -7, -24], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 0,-3, 0, 0, 0,    0,   3,    0,   0], $
;/* 461-470 */
[ 0, 0, 0, 0, 0,  0, -5, 13, 0, 0, 0, 0, 2,    3,   0,    0,  -1], $
[ 0, 0, 0, 0, 0,  0,  2,  0,-1, 0, 0, 0, 0,    0,  35,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  2,  0,-1, 0, 0, 0, 2, -154, -30,  -13,  67], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 0,-2, 0, 0, 0,   15,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 0,-2, 0, 0, 1,    0,   4,    2,   0], $
[ 0, 0, 0, 0, 0,  0,  3, -2, 0, 0, 0, 0, 0,    0,   9,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  3, -2, 0, 0, 0, 0, 2,   80, -71,  -31, -35], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 0,-1, 0, 0, 2,    0, -20,   -9,   0], $
[ 0, 0, 0, 0, 0,  0, -6, 15, 0, 0, 0, 0, 2,   11,   5,    2,  -5], $
[ 0, 0, 0, 0, 0, -8, 15,  0, 0, 0, 0, 0, 2,   61, -96,  -42, -27], $
;/* 471-480 */
[ 0, 0, 0, 0, 0, -3,  9, -4, 0, 0, 0, 0, 2,   14,   9,    4,  -6], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 2,-5, 0, 0, 2,  -11,  -6,   -3,   5], $
[ 0, 0, 0, 0, 0,  0, -2,  8,-1,-5, 0, 0, 2,    0,  -3,   -1,   0], $
[ 0, 0, 0, 0, 0,  0,  6, -8, 3, 0, 0, 0, 2,  123,-415, -180, -53], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 0, 0, 0, 0, 0,    0,   0,    0, -35], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 0, 0, 0, 0, 0,   -5,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 0, 0, 0, 0, 1,    7, -32,  -17,  -4], $
[ 0, 1,-1, 1, 0,  0,  1,  0, 0, 0, 0, 0, 0,    0,  -9,   -5,   0], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 0, 0, 0, 0, 1,    0,  -4,    2,   0], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 0, 0, 0, 0, 2,  -89,   0,    0,  38], $
;/* 481-490 */
[ 0, 0, 0, 0, 0,  0, -6, 16,-4,-5, 0, 0, 2,    0, -86,  -19,  -6], $
[ 0, 0, 0, 0, 0,  0, -2,  8,-3, 0, 0, 0, 2,    0,   0,  -19,   6], $
[ 0, 0, 0, 0, 0,  0, -2,  8,-3, 0, 0, 0, 2, -123,-416, -180,  53], $
[ 0, 0, 0, 0, 0,  0,  6, -8, 1, 5, 0, 0, 2,    0,  -3,   -1,   0], $
[ 0, 0, 0, 0, 0,  0,  2,  0,-2, 5, 0, 0, 2,   12,  -6,   -3,  -5], $
[ 0, 0, 0, 0, 0,  3, -5,  4, 0, 0, 0, 0, 2,  -13,   9,    4,   6], $
[ 0, 0, 0, 0, 0, -8, 11,  0, 0, 0, 0, 0, 2,    0, -15,   -7,   0], $
[ 0, 0, 0, 0, 0, -8, 11,  0, 0, 0, 0, 0, 1,    3,   0,    0,  -1], $
[ 0, 0, 0, 0, 0, -8, 11,  0, 0, 0, 0, 0, 2,  -62, -97,  -42,  27], $
[ 0, 0, 0, 0, 0,  0, 11,  0, 0, 0, 0, 0, 2,  -11,   5,    2,   5], $
;/* 491-500 */
[ 0, 0, 0, 0, 0,  0,  2,  0, 0, 1, 0, 0, 2,    0, -19,   -8,   0], $
[ 0, 0, 0, 0, 0,  3, -3,  0, 2, 0, 0, 0, 2,   -3,   0,    0,   1], $
[ 0, 2,-2, 1, 0,  0,  4, -8, 3, 0, 0, 0, 0,    0,   4,    2,   0], $
[ 0, 1,-1, 0, 0,  0,  1,  0, 0, 0, 0, 0, 0,    0,   3,    0,   0], $
[ 0, 2,-2, 1, 0,  0, -4,  8,-3, 0, 0, 0, 0,    0,   4,    2,   0], $
[ 0, 0, 0, 0, 0,  0,  1,  2, 0, 0, 0, 0, 2,  -85, -70,  -31,  37], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 1, 0, 0, 0, 2,  163, -12,   -5, -72], $
[ 0, 0, 0, 0, 0, -3,  7,  0, 0, 0, 0, 0, 2,  -63, -16,   -7,  28], $
[ 0, 0, 0, 0, 0,  0,  0,  4, 0, 0, 0, 0, 2,  -21, -32,  -14,   9], $
[ 0, 0, 0, 0, 0, -5,  6,  0, 0, 0, 0, 0, 2,    0,  -3,   -1,   0], $
;/* 501-510 */
[ 0, 0, 0, 0, 0, -5,  6,  0, 0, 0, 0, 0, 1,    3,   0,    0,  -2], $
[ 0, 0, 0, 0, 0,  5, -6,  0, 0, 0, 0, 0, 0,    0,   8,    0,   0], $
[ 0, 0, 0, 0, 0,  5, -6,  0, 0, 0, 0, 0, 2,    3,  10,    4,  -1], $
[ 0, 0, 0, 0, 0,  0,  2,  0, 2, 0, 0, 0, 2,    3,   0,    0,  -1], $
[ 0, 0, 0, 0, 0,  0, -1,  6, 0, 0, 0, 0, 2,    0,  -7,   -3,   0], $
[ 0, 0, 0, 0, 0,  0,  7, -9, 0, 0, 0, 0, 2,    0,  -4,   -2,   0], $
[ 0, 0, 0, 0, 0,  2, -1,  0, 0, 0, 0, 0, 0,    6,  19,    0,   0], $
[ 0, 0, 0, 0, 0,  2, -1,  0, 0, 0, 0, 0, 2,    5,-173,  -75,  -2], $
[ 0, 0, 0, 0, 0,  0,  6, -7, 0, 0, 0, 0, 2,    0,  -7,   -3,   0], $
[ 0, 0, 0, 0, 0,  0,  5, -5, 0, 0, 0, 0, 2,    7, -12,   -5,  -3], $
;/* 511-520 */
[ 0, 0, 0, 0, 0, -1,  4,  0, 0, 0, 0, 0, 1,   -3,   0,    0,   2], $
[ 0, 0, 0, 0, 0, -1,  4,  0, 0, 0, 0, 0, 2,    3,  -4,   -2,  -1], $
[ 0, 0, 0, 0, 0, -7,  9,  0, 0, 0, 0, 0, 2,   74,   0,    0, -32], $
[ 0, 0, 0, 0, 0, -7,  9,  0, 0, 0, 0, 0, 1,   -3,  12,    6,   2], $
[ 0, 0, 0, 0, 0,  0,  4, -3, 0, 0, 0, 0, 2,   26, -14,   -6, -11], $
[ 0, 0, 0, 0, 0,  0,  3, -1, 0, 0, 0, 0, 2,   19,   0,    0,  -8], $
[ 0, 0, 0, 0, 0, -4,  4,  0, 0, 0, 0, 0, 1,    6,  24,   13,  -3], $
[ 0, 0, 0, 0, 0,  4, -4,  0, 0, 0, 0, 0, 0,   83,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  4, -4,  0, 0, 0, 0, 0, 1,    0, -10,   -5,   0], $
[ 0, 0, 0, 0, 0,  4, -4,  0, 0, 0, 0, 0, 2,   11,  -3,   -1,  -5], $
;/* 521-530 */
[ 0, 0, 0, 0, 0,  0,  2,  1, 0, 0, 0, 0, 2,    3,   0,    1,  -1], $
[ 0, 0, 0, 0, 0,  0, -3,  0, 5, 0, 0, 0, 2,    3,   0,    0,  -1], $
[ 0, 0, 0, 0, 0,  1,  1,  0, 0, 0, 0, 0, 0,   -4,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  1,  1,  0, 0, 0, 0, 0, 1,    5, -23,  -12,  -3], $
[ 0, 0, 0, 0, 0,  1,  1,  0, 0, 0, 0, 0, 2, -339,   0,    0, 147], $
[ 0, 0, 0, 0, 0, -9, 12,  0, 0, 0, 0, 0, 2,    0, -10,   -5,   0], $
[ 0, 0, 0, 0, 0,  0,  3,  0,-4, 0, 0, 0, 0,    5,   0,    0,   0], $
[ 0, 2,-2, 1, 0,  1, -1,  0, 0, 0, 0, 0, 0,    3,   0,    0,  -1], $
[ 0, 0, 0, 0, 0,  0,  7, -8, 0, 0, 0, 0, 2,    0,  -4,   -2,   0], $
[ 0, 0, 0, 0, 0,  0,  3,  0,-3, 0, 0, 0, 0,   18,  -3,    0,   0], $
;/* 531-540 */
[ 0, 0, 0, 0, 0,  0,  3,  0,-3, 0, 0, 0, 2,    9, -11,   -5,  -4], $
[ 0, 0, 0, 0, 0, -2,  6,  0, 0, 0, 0, 0, 2,   -8,   0,    0,   4], $
[ 0, 0, 0, 0, 0, -6,  7,  0, 0, 0, 0, 0, 1,    3,   0,    0,  -1], $
[ 0, 0, 0, 0, 0,  6, -7,  0, 0, 0, 0, 0, 0,    0,   9,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  6, -6, 0, 0, 0, 0, 2,    6,  -9,   -4,  -2], $
[ 0, 0, 0, 0, 0,  0,  3,  0,-2, 0, 0, 0, 0,   -4, -12,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  3,  0,-2, 0, 0, 0, 2,   67, -91,  -39, -29], $
[ 0, 0, 0, 0, 0,  0,  5, -4, 0, 0, 0, 0, 2,   30, -18,   -8, -13], $
[ 0, 0, 0, 0, 0,  3, -2,  0, 0, 0, 0, 0, 0,    0,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  3, -2,  0, 0, 0, 0, 0, 2,    0,-114,  -50,   0], $

;/* 541-550 */
[ 0, 0, 0, 0, 0,  0,  3,  0,-1, 0, 0, 0, 2,    0,   0,    0,  23], $
[ 0, 0, 0, 0, 0,  0,  3,  0,-1, 0, 0, 0, 2,  517,  16,    7,-224], $
[ 0, 0, 0, 0, 0,  0,  3,  0, 0,-2, 0, 0, 2,    0,  -7,   -3,   0], $
[ 0, 0, 0, 0, 0,  0,  4, -2, 0, 0, 0, 0, 2,  143,  -3,   -1, -62], $
[ 0, 0, 0, 0, 0,  0,  3,  0, 0,-1, 0, 0, 2,   29,   0,    0, -13], $
[ 0, 2,-2, 1, 0,  0,  1,  0,-1, 0, 0, 0, 0,   -4,   0,    0,   2], $
[ 0, 0, 0, 0, 0, -8, 16,  0, 0, 0, 0, 0, 2,   -6,   0,    0,   3], $
[ 0, 0, 0, 0, 0,  0,  3,  0, 2,-5, 0, 0, 2,    5,  12,    5,  -2], $
[ 0, 0, 0, 0, 0,  0,  7, -8, 3, 0, 0, 0, 2,  -25,   0,    0,  11], $
[ 0, 0, 0, 0, 0,  0, -5, 16,-4,-5, 0, 0, 2,   -3,   0,    0,   1], $
;/* 551-560 */
[ 0, 0, 0, 0, 0,  0,  3,  0, 0, 0, 0, 0, 2,    0,   4,    2,   0], $
[ 0, 0, 0, 0, 0,  0, -1,  8,-3, 0, 0, 0, 2,  -22,  12,    5,  10], $
[ 0, 0, 0, 0, 0, -8, 10,  0, 0, 0, 0, 0, 2,   50,   0,    0, -22], $
[ 0, 0, 0, 0, 0, -8, 10,  0, 0, 0, 0, 0, 1,    0,   7,    4,   0], $
[ 0, 0, 0, 0, 0, -8, 10,  0, 0, 0, 0, 0, 2,    0,   3,    1,   0], $
[ 0, 0, 0, 0, 0,  0,  2,  2, 0, 0, 0, 0, 2,   -4,   4,    2,   2], $
[ 0, 0, 0, 0, 0,  0,  3,  0, 1, 0, 0, 0, 2,   -5, -11,   -5,   2], $
[ 0, 0, 0, 0, 0, -3,  8,  0, 0, 0, 0, 0, 2,    0,   4,    2,   0], $
[ 0, 0, 0, 0, 0, -5,  5,  0, 0, 0, 0, 0, 1,    4,  17,    9,  -2], $
[ 0, 0, 0, 0, 0,  5, -5,  0, 0, 0, 0, 0, 0,   59,   0,    0,   0], $
;/* 561-570 */
[ 0, 0, 0, 0, 0,  5, -5,  0, 0, 0, 0, 0, 1,    0,  -4,   -2,   0], $
[ 0, 0, 0, 0, 0,  5, -5,  0, 0, 0, 0, 0, 2,   -8,   0,    0,   4], $
[ 0, 0, 0, 0, 0,  2,  0,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  2,  0,  0, 0, 0, 0, 0, 1,    4, -15,   -8,  -2], $
[ 0, 0, 0, 0, 0,  2,  0,  0, 0, 0, 0, 0, 2,  370,  -8,    0,-160], $
[ 0, 0, 0, 0, 0,  0,  7, -7, 0, 0, 0, 0, 2,    0,   0,   -3,   0], $
[ 0, 0, 0, 0, 0,  0,  7, -7, 0, 0, 0, 0, 2,    0,   3,    1,   0], $
[ 0, 0, 0, 0, 0,  0,  6, -5, 0, 0, 0, 0, 2,   -6,   3,    1,   3], $
[ 0, 0, 0, 0, 0,  7, -8,  0, 0, 0, 0, 0, 0,    0,   6,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  5, -3, 0, 0, 0, 0, 2,  -10,   0,    0,   4], $
;/* 571-580 */
[ 0, 0, 0, 0, 0,  4, -3,  0, 0, 0, 0, 0, 2,    0,   9,    4,   0], $
[ 0, 0, 0, 0, 0,  1,  2,  0, 0, 0, 0, 0, 2,    4,  17,    7,  -2], $
[ 0, 0, 0, 0, 0, -9, 11,  0, 0, 0, 0, 0, 2,   34,   0,    0, -15], $
[ 0, 0, 0, 0, 0, -9, 11,  0, 0, 0, 0, 0, 1,    0,   5,    3,   0], $
[ 0, 0, 0, 0, 0,  0,  4,  0,-4, 0, 0, 0, 2,   -5,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  0,  4,  0,-3, 0, 0, 0, 2,  -37,  -7,   -3,  16], $
[ 0, 0, 0, 0, 0, -6,  6,  0, 0, 0, 0, 0, 1,    3,  13,    7,  -2], $
[ 0, 0, 0, 0, 0,  6, -6,  0, 0, 0, 0, 0, 0,   40,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  6, -6,  0, 0, 0, 0, 0, 1,    0,  -3,   -2,   0], $
[ 0, 0, 0, 0, 0,  0,  4,  0,-2, 0, 0, 0, 2, -184,  -3,   -1,  80], $
;/* 581-590 */
[ 0, 0, 0, 0, 0,  0,  6, -4, 0, 0, 0, 0, 2,   -3,   0,    0,   1], $
[ 0, 0, 0, 0, 0,  3, -1,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  3, -1,  0, 0, 0, 0, 0, 1,    0, -10,   -6,  -1], $
[ 0, 0, 0, 0, 0,  3, -1,  0, 0, 0, 0, 0, 2,   31,  -6,    0, -13], $
[ 0, 0, 0, 0, 0,  0,  4,  0,-1, 0, 0, 0, 2,   -3, -32,  -14,   1], $
[ 0, 0, 0, 0, 0,  0,  4,  0, 0,-2, 0, 0, 2,   -7,   0,    0,   3], $
[ 0, 0, 0, 0, 0,  0,  5, -2, 0, 0, 0, 0, 2,    0,  -8,   -4,   0], $
[ 0, 0, 0, 0, 0,  0,  4,  0, 0, 0, 0, 0, 0,    3,  -4,    0,   0], $
[ 0, 0, 0, 0, 0,  8, -9,  0, 0, 0, 0, 0, 0,    0,   4,    0,   0], $
[ 0, 0, 0, 0, 0,  5, -4,  0, 0, 0, 0, 0, 2,    0,   3,    1,   0], $
;/* 591-600 */
[ 0, 0, 0, 0, 0,  2,  1,  0, 0, 0, 0, 0, 2,   19, -23,  -10,   2], $
[ 0, 0, 0, 0, 0,  2,  1,  0, 0, 0, 0, 0, 1,    0,   0,    0, -10], $
[ 0, 0, 0, 0, 0,  2,  1,  0, 0, 0, 0, 0, 1,    0,   3,    2,   0], $
[ 0, 0, 0, 0, 0, -7,  7,  0, 0, 0, 0, 0, 1,    0,   9,    5,  -1], $
[ 0, 0, 0, 0, 0,  7, -7,  0, 0, 0, 0, 0, 0,   28,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  4, -2,  0, 0, 0, 0, 0, 1,    0,  -7,   -4,   0], $
[ 0, 0, 0, 0, 0,  4, -2,  0, 0, 0, 0, 0, 2,    8,  -4,    0,  -4], $
[ 0, 0, 0, 0, 0,  4, -2,  0, 0, 0, 0, 0, 0,    0,   0,   -2,   0], $
[ 0, 0, 0, 0, 0,  4, -2,  0, 0, 0, 0, 0, 0,    0,   3,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  5,  0,-4, 0, 0, 0, 2,   -3,   0,    0,   1], $
;/* 601-610 */
[ 0, 0, 0, 0, 0,  0,  5,  0,-3, 0, 0, 0, 2,   -9,   0,    1,   4], $
[ 0, 0, 0, 0, 0,  0,  5,  0,-2, 0, 0, 0, 2,    3,  12,    5,  -1], $
[ 0, 0, 0, 0, 0,  3,  0,  0, 0, 0, 0, 0, 2,   17,  -3,   -1,   0], $
[ 0, 0, 0, 0, 0, -8,  8,  0, 0, 0, 0, 0, 1,    0,   7,    4,   0], $
[ 0, 0, 0, 0, 0,  8, -8,  0, 0, 0, 0, 0, 0,   19,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  5, -3,  0, 0, 0, 0, 0, 1,    0,  -5,   -3,   0], $
[ 0, 0, 0, 0, 0,  5, -3,  0, 0, 0, 0, 0, 2,   14,  -3,    0,  -1], $
[ 0, 0, 0, 0, 0, -9,  9,  0, 0, 0, 0, 0, 1,    0,   0,   -1,   0], $
[ 0, 0, 0, 0, 0, -9,  9,  0, 0, 0, 0, 0, 1,    0,   0,    0,  -5], $
[ 0, 0, 0, 0, 0, -9,  9,  0, 0, 0, 0, 0, 1,    0,   5,    3,   0], $
;/* 611-620 */
[ 0, 0, 0, 0, 0,  9, -9,  0, 0, 0, 0, 0, 0,   13,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  6, -4,  0, 0, 0, 0, 0, 1,    0,  -3,   -2,   0], $
[ 0, 0, 0, 0, 0,  0,  6,  0, 0, 0, 0, 0, 2,    2,   9,    4,   3], $
[ 0, 0, 0, 0, 0,  0,  6,  0, 0, 0, 0, 0, 0,    0,   0,    0,  -4], $
[ 0, 0, 0, 0, 0,  0,  6,  0, 0, 0, 0, 0, 0,    8,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  6,  0, 0, 0, 0, 0, 1,    0,   4,    2,   0], $
[ 0, 0, 0, 0, 0,  0,  6,  0, 0, 0, 0, 0, 2,    6,   0,    0,  -3], $
[ 0, 0, 0, 0, 0,  0,  6,  0, 0, 0, 0, 0, 0,    6,   0,    0,   0], $
[ 0, 0, 0, 0, 0,  0,  6,  0, 0, 0, 0, 0, 1,    0,   3,    1,   0], $
[ 0, 0, 0, 0, 0,  0,  6,  0, 0, 0, 0, 0, 2,    5,   0,    0,  -2], $
;/* 621-630 */
[ 0, 0, 0, 0, 0,  0,  0,  0, 0, 0, 0, 0, 2,    3,   0,    0,  -1], $
[ 1, 0,-2, 0, 0,  0,  2,  0,-2, 0, 0, 0, 0,   -3,   0,    0,   0], $
[ 1, 0,-2, 0, 0,  2, -2,  0, 0, 0, 0, 0, 0,    6,   0,    0,   0], $
[ 1, 0,-2, 0, 0,  0,  1,  0,-1, 0, 0, 0, 0,    7,   0,    0,   0], $
[ 1, 0,-2, 0, 0,  1, -1,  0, 0, 0, 0, 0, 0,   -4,   0,    0,   0], $
[-1, 0, 0, 0, 0,  3, -3,  0, 0, 0, 0, 0, 0,    4,   0,    0,   0], $
[-1, 0, 0, 0, 0,  0,  2,  0,-2, 0, 0, 0, 0,    6,   0,    0,   0], $
[-1, 0, 2, 0, 0,  0,  4, -8, 3, 0, 0, 0, 0,    0,  -4,    0,   0], $
[ 1, 0,-2, 0, 0,  0,  4, -8, 3, 0, 0, 0, 0,    0,  -4,    0,   0], $
[-2, 0, 2, 0, 0,  0,  4, -8, 3, 0, 0, 0, 0,    5,   0,    0,   0], $
;/* 631-640 */
[-1, 0, 0, 0, 0,  0,  2,  0,-3, 0, 0, 0, 0,   -3,   0,    0,   0], $
[-1, 0, 0, 0, 0,  0,  1,  0,-1, 0, 0, 0, 0,    4,   0,    0,   0], $
[-1, 0, 0, 0, 0,  1, -1,  0, 0, 0, 0, 0, 0,   -5,   0,    0,   0], $
[-1, 0, 2, 0, 0,  2, -2,  0, 0, 0, 0, 0, 0,    4,   0,    0,   0], $
[ 1,-1, 1, 0, 0,  0,  1,  0, 0, 0, 0, 0, 0,    0,   3,    0,   0], $
[-1, 0, 2, 0, 0,  0,  2,  0,-3, 0, 0, 0, 0,   13,   0,    0,   0], $
[-2, 0, 0, 0, 0,  0,  2,  0,-3, 0, 0, 0, 0,   21,  11,    0,   0], $
[ 1, 0, 0, 0, 0,  0,  4, -8, 3, 0, 0, 0, 0,    0,  -5,    0,   0], $
[-1, 1,-1, 1, 0,  0, -1,  0, 0, 0, 0, 0, 0,    0,  -5,   -2,   0], $
[ 1, 1,-1, 1, 0,  0, -1,  0, 0, 0, 0, 0, 0,    0,   5,    3,   0], $
;/* 641-650 */
[-1, 0, 0, 0, 0,  0,  4, -8, 3, 0, 0, 0, 0,    0,  -5,    0,   0], $
[-1, 0, 2, 1, 0,  0,  2,  0,-2, 0, 0, 0, 0,   -3,   0,    0,   2], $
[ 0, 0, 0, 0, 0,  0,  2,  0,-2, 0, 0, 0, 0,   20,  10,    0,   0], $
[-1, 0, 2, 0, 0,  0,  2,  0,-2, 0, 0, 0, 0,  -34,   0,    0,   0], $
[-1, 0, 2, 0, 0,  3, -3,  0, 0, 0, 0, 0, 0,  -19,   0,    0,   0], $
[ 1, 0,-2, 1, 0,  0, -2,  0, 2, 0, 0, 0, 0,    3,   0,    0,  -2], $
[ 1, 2,-2, 2, 0, -3,  3,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   1], $
[ 1, 2,-2, 2, 0,  0, -2,  0, 2, 0, 0, 0, 0,   -6,   0,    0,   3], $
[ 1, 0, 0, 0, 0,  1, -1,  0, 0, 0, 0, 0, 0,   -4,   0,    0,   0], $
[ 1, 0, 0, 0, 0,  0,  1,  0,-1, 0, 0, 0, 0,    3,   0,    0,   0], $
;/* 651-660 */
[ 0, 0,-2, 0, 0,  2, -2,  0, 0, 0, 0, 0, 0,    3,   0,    0,   0], $
[ 0, 0,-2, 0, 0,  0,  1,  0,-1, 0, 0, 0, 0,    4,   0,    0,   0], $
[ 0, 2, 0, 2, 0, -2,  2,  0, 0, 0, 0, 0, 0,    3,   0,    0,  -1], $
[ 0, 2, 0, 2, 0,  0, -1,  0, 1, 0, 0, 0, 0,    6,   0,    0,  -3], $
[ 0, 2, 0, 2, 0, -1,  1,  0, 0, 0, 0, 0, 0,   -8,   0,    0,   3], $
[ 0, 2, 0, 2, 0, -2,  3,  0, 0, 0, 0, 0, 0,    0,   3,    1,   0], $
[ 0, 0, 2, 0, 0,  0,  2,  0,-2, 0, 0, 0, 0,   -3,   0,    0,   0], $
[ 0, 1, 1, 2, 0,  0,  1,  0, 0, 0, 0, 0, 0,    0,  -3,   -2,   0], $
[ 1, 2, 0, 2, 0,  0,  1,  0, 0, 0, 0, 0, 0,  126, -63,  -27, -55], $
[-1, 2, 0, 2, 0, 10, -3,  0, 0, 0, 0, 0, 0,   -5,   0,    1,   2], $
;/* 661-670 */
[ 0, 1, 1, 1, 0,  0,  1,  0, 0, 0, 0, 0, 0,   -3,  28,   15,   2], $
[ 1, 2, 0, 2, 0,  0,  1,  0, 0, 0, 0, 0, 0,    5,   0,    1,  -2], $
[ 0, 2, 0, 2, 0,  0,  4, -8, 3, 0, 0, 0, 0,    0,   9,    4,   1], $
[ 0, 2, 0, 2, 0,  0, -4,  8,-3, 0, 0, 0, 0,    0,   9,    4,  -1], $
[-1, 2, 0, 2, 0,  0, -4,  8,-3, 0, 0, 0, 0, -126, -63,  -27,  55], $
[ 2, 2,-2, 2, 0,  0, -2,  0, 3, 0, 0, 0, 0,    3,   0,    0,  -1], $
[ 1, 2, 0, 1, 0,  0, -2,  0, 3, 0, 0, 0, 0,   21, -11,   -6, -11], $
[ 0, 1, 1, 0, 0,  0,  1,  0, 0, 0, 0, 0, 0,    0,  -4,    0,   0], $
[-1, 2, 0, 1, 0,  0,  1,  0, 0, 0, 0, 0, 0,  -21, -11,   -6,  11], $
[-2, 2, 2, 2, 0,  0,  2,  0,-2, 0, 0, 0, 0,   -3,   0,    0,   1], $
;/* 671-680 */
[ 0, 2, 0, 2, 0,  2, -3,  0, 0, 0, 0, 0, 0,    0,   3,    1,   0], $
[ 0, 2, 0, 2, 0,  1, -1,  0, 0, 0, 0, 0, 0,    8,   0,    0,  -4], $
[ 0, 2, 0, 2, 0,  0,  1,  0,-1, 0, 0, 0, 0,   -6,   0,    0,   3], $
[ 0, 2, 0, 2, 0,  2, -2,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   1], $
[-1, 2, 2, 2, 0,  0, -1,  0, 1, 0, 0, 0, 0,    3,   0,    0,  -1], $
[ 1, 2, 0, 2, 0, -1,  1,  0, 0, 0, 0, 0, 0,   -3,   0,    0,   1], $
[-1, 2, 2, 2, 0,  0,  2,  0,-3, 0, 0, 0, 0,   -5,   0,    0,   2], $
[ 2, 2, 0, 2, 0,  0,  2,  0,-3, 0, 0, 0, 0,   24, -12,   -5, -11], $
[ 1, 2, 0, 2, 0,  0, -4,  8,-3, 0, 0, 0, 0,    0,   3,    1,   0], $
[ 1, 2, 0, 2, 0,  0,  4, -8, 3, 0, 0, 0, 0,    0,   3,    1,   0], $
;/* 681-687 */
[ 1, 1, 1, 1, 0,  0,  1,  0, 0, 0, 0, 0, 0,    0,   3,    2,   0], $
[ 0, 2, 0, 2, 0,  0,  1,  0, 0, 0, 0, 0, 0,  -24, -12,   -5,  10], $
[ 2, 2, 0, 1, 0,  0,  1,  0, 0, 0, 0, 0, 0,    4,   0,   -1,  -2], $
[-1, 2, 2, 2, 0,  0,  2,  0,-2, 0, 0, 0, 0,   13,   0,    0,  -6], $
[-1, 2, 2, 2, 0,  3, -3,  0, 0, 0, 0, 0, 0,    7,   0,    0,  -3], $
[ 1, 2, 0, 2, 0,  1, -1,  0, 0, 0, 0, 0, 0,    3,   0,    0,  -1], $
[ 0, 2, 2, 2, 0,  0,  2,  0,-2, 0, 0, 0, 0,    3,   0,    0,  -1] $
];

xpl.nl=reform(xpl_m[0,*])
xpl.nf=reform(xpl_m[1,*])
xpl.nd=reform(xpl_m[2,*])
xpl.nom=reform(xpl_m[3,*])
xpl.nme=reform(xpl_m[4,*])
xpl.nve=reform(xpl_m[5,*])
xpl.nea=reform(xpl_m[6,*])
xpl.nma=reform(xpl_m[7,*])
xpl.nju=reform(xpl_m[8,*])
xpl.nsa=reform(xpl_m[9,*])
xpl.nur=reform(xpl_m[10,*])
xpl.nne=reform(xpl_m[11,*])
xpl.npa=reform(xpl_m[12,*])
xpl.sp=reform(xpl_m[13,*])
xpl.cp=reform(xpl_m[14,*])
xpl.se=reform(xpl_m[15,*])
xpl.ce=reform(xpl_m[16,*])

xpl_m=0
;/* Number of terms in the planetary nutation model */
NPL = n_elements(xpl.ce) 
@erfam
;/*--------------------------------------------------------------------*/

;/* Interval between fundamental date J2000.0 and given date (JC). */
t = ((date1 - ERFA_DJ00) + date2) / ERFA_DJC;

;/* ------------------- */
;/* LUNI-SOLAR NUTATION */
;/* ------------------- */

;/* Fundamental (Delaunay) arguments */

;/* Mean anomaly of the Moon (IERS 2003). */
el = eraFal03(t);

;/* Mean anomaly of the Sun (MHB2000). */
elp = (1287104.79305d  + $
t * (129596581.0481d  + $
t * (-0.5532d  + $
t * (0.000136d  + $
t * (-0.00001149d)))) mod ERFA_TURNAS) * ERFA_DAS2R;

;/* Mean longitude of the Moon minus that of the ascending node */
;/* (IERS 2003. */
f = eraFaf03(t);

;/* Mean elongation of the Moon from the Sun (MHB2000). */
d = (1072260.70369d  +  $
t * (1602961601.2090d  +  $
t * (-6.3706d  +  $
t * (0.006593d  +  $
t * (-0.00003169d)))) mod ERFA_TURNAS) * ERFA_DAS2R;

;/* Mean longitude of the ascending node of the Moon (IERS 2003). */
om = eraFaom03(t);

;/* Initialize the nutation values. */
dp = 0.0d;
de = 0.0d;

;/* Summation of luni-solar nutation series (in reverse order). */
for i = NLS-1,0,-1 do begin; i >= 0; i--) {

;/* Argument and functions. */
arg = (1d*xls[i].nl  * el +  $
1d*xls[i].nlp * elp +  $
1d*xls[i].nf  * f +  $
1d*xls[i].nd  * d +  $
1d*xls[i].nom * om mod ERFA_D2PI);
sarg = sin(arg);
carg = cos(arg);

;/* Term. */
dp += (xls[i].sp + xls[i].spt * t) * sarg + xls[i].cp * carg;
de += (xls[i].ce + xls[i].cet * t) * carg + xls[i].se * sarg;
endfor

;/* Convert from 0.1 microarcsec units to radians. */
dpsils = dp * U2R;
depsls = de * U2R;

;/* ------------------ */
;/* PLANETARY NUTATION */
;/* ------------------ */

;/* n.b.  The MHB2000 code computes the luni-solar and planetary nutation */
;/* in different functions, using slightly different Delaunay */
;/* arguments in the two cases.  This behaviour is faithfully */
;/* reproduced here.  Use of the IERS 2003 expressions for both */
;/* cases leads to negligible changes, well below */
;/* 0.1 microarcsecond. */

;/* Mean anomaly of the Moon (MHB2000). */
al = (2.35555598d + 8328.6914269554d * t mod ERFA_D2PI);

;/* Mean longitude of the Moon minus that of the ascending node */
;/*(MHB2000). */
af = (1.627905234d + 8433.466158131d * t mod ERFA_D2PI);

;/* Mean elongation of the Moon from the Sun (MHB2000). */
ad = (5.198466741d + 7771.3771468121d * t mod ERFA_D2PI);

;/* Mean longitude of the ascending node of the Moon (MHB2000). */
aom = (2.18243920d - 33.757045d * t mod ERFA_D2PI);

;/* General accumulated precession in longitude (IERS 2003). */
apa = eraFapa03(t);ok

;/* Planetary longitudes, Mercury through Uranus (IERS 2003). */
alme = eraFame03(t);ok
alve = eraFave03(t);ok
alea = eraFae03(t);ok
alma = eraFama03(t);ok
alju = eraFaju03(t);ok
alsa = eraFasa03(t);ok
alur = eraFaur03(t);ok

;/* Neptune longitude (MHB2000). */
alne = (5.321159000d + 3.8127774000d * t mod ERFA_D2PI);

;/* Initialize the nutation values. */
dp = 0.0d;
de = 0.0d;

;/* Summation of planetary nutation series (in reverse order). */
for i = NPL-1,0,-1 do begin; i >= 0; i--) {

;/* Argument and functions. */
arg = (1d*xpl[i].nl  * al   +  $
1d*xpl[i].nf  * af   +  $
1d*xpl[i].nd  * ad   +  $
1d*xpl[i].nom * aom  +  $
1d*xpl[i].nme * alme +  $
1d*xpl[i].nve * alve +  $
1d*xpl[i].nea * alea +  $
1d*xpl[i].nma * alma +  $
1d*xpl[i].nju * alju +  $
1d*xpl[i].nsa * alsa +  $
1d*xpl[i].nur * alur +  $
1d*xpl[i].nne * alne +  $
1d*xpl[i].npa * apa mod ERFA_D2PI);
sarg = sin(arg);
carg = cos(arg);

;/* Term. */
dp += 1d*xpl[i].sp * sarg + 1d*xpl[i].cp * carg;
de += 1d*xpl[i].se * sarg + 1d*xpl[i].ce * carg;

endfor

;/* Convert from 0.1 microarcsec units to radians. */
dpsipl = dp * U2R;
depspl = de * U2R;

;/* ------- */
;/* RESULTS */
;/* ------- */

;/* Add luni-solar and planetary components. */
dpsi = dpsils + dpsipl;
deps = depsls + depspl;




;/*----------------------------------------------------------------------




end