pro eraNut06a,date1,date2,dpsi,deps

;  void eraNut06a(double date1, double date2, double *dpsi, double *deps)
;  /*
;  **  - - - - - - - - - -
;  **   e r a N u t 0 6 a
;  **  - - - - - - - - - -
;  **
;  **  IAU 2000A nutation with adjustments to match the IAU 2006
;  **  precession.
;  **
;  **  Given:
;  **     date1,date2   double   TT as a 2-part Julian Date (Note 1)
;  **
;  **  Returned:
;  **     dpsi,deps     double   nutation, luni-solar + planetary (Note 2)
;  **
;  **  Notes:
;  **
;  **  1) The TT date date1+date2 is a Julian Date, apportioned in any
;  **     convenient way between the two arguments.  For example,
;  **     JD(TT)=2450123.7 could be expressed in any of these ways,
;  **     among others:
;  **
;  **            date1          date2
;  **
;  **         2450123.7           0.0       (JD method)
;  **         2451545.0       -1421.3       (J2000 method)
;  **         2400000.5       50123.2       (MJD method)
;  **         2450123.5           0.2       (date & time method)
;  **
;  **     The JD method is the most natural and convenient to use in
;  **     cases where the loss of several decimal digits of resolution
;  **     is acceptable.  The J2000 method is best matched to the way
;  **     the argument is handled internally and will deliver the
;  **     optimum resolution.  The MJD method and the date & time methods
;  **     are both good compromises between resolution and convenience.
;  **
;  **  2) The nutation components in longitude and obliquity are in radians
;  **     and with respect to the mean equinox and ecliptic of date,
;  **     IAU 2006 precession model (Hilton et al. 2006, Capitaine et al.
;  **     2005).
;  **
;  **  3) The function first computes the IAU 2000A nutation, then applies
;  **     adjustments for (i) the consequences of the change in obliquity
;  **     from the IAU 1980 ecliptic to the IAU 2006 ecliptic and (ii) the
;  **     secular variation in the Earth's dynamical form factor J2.
;  **
;  **  4) The present function provides classical nutation, complementing
;  **     the IAU 2000 frame bias and IAU 2006 precession.  It delivers a
;  **     pole which is at current epochs accurate to a few tens of
;  **     microarcseconds, apart from the free core nutation.
;  **
;  **  Called:
;  **     eraNut00a    nutation, IAU 2000A
;  **
;  **  References:
;  **
;  **     Chapront, J., Chapront-Touze, M. & Francou, G. 2002,
;  **     Astron.Astrophys. 387, 700
;  **
;  **     Lieske, J.H., Lederle, T., Fricke, W. & Morando, B. 1977,
;  **     Astron.Astrophys. 58, 1-16
;  **
;  **     Mathews, P.M., Herring, T.A., Buffet, B.A. 2002, J.Geophys.Res.
;  **     107, B4.  The MHB_2000 code itself was obtained on 9th September
;  **     2002 from ftp//maia.usno.navy.mil/conv2000/chapter5/IAU2000A.
;  **
;  **     Simon, J.-L., Bretagnon, P., Chapront, J., Chapront-Touze, M.,
;  **     Francou, G., Laskar, J. 1994, Astron.Astrophys. 282, 663-683
;  **
;  **     Souchay, J., Loysel, B., Kinoshita, H., Folgueira, M. 1999,
;  **     Astron.Astrophys.Supp.Ser. 135, 111
;  **
;  **     Wallace, P.T., "Software for Implementing the IAU 2000
;  **     Resolutions", in IERS Workshop 5.1 (2002)
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
 t=0d & fj2=0d & dp=0d & de=0d;
@erfam  
;  /* Interval between fundamental date J2000.0 and given date (JC). */
  t = ((date1 - ERFA_DJ00) + date2) / ERFA_DJC;
  
 ; /* Factor correcting for secular variation of J2. */
  fj2 = -2.7774d-6 * t;
  
;  /* Obtain IAU 2000A nutation. */
  eraNut00a,date1, date2, dp, de;
  
;  /* Apply P03 adjustments (Wallace & Capitaine, 2006, Eqs.5). */
  dpsi = dp + dp * (0.4697d-6 + fj2);
  deps = de + de * fj2;
  

;/*----------------------------------------------------------------------


end