pro eraPmpx,rc,dc,pr,pd,px,rv,pmt,pob,pco

;  void eraPmpx(double rc, double dc, double pr, double pd,
;  double px, double rv, double pmt, double pob[3],
;  double pco[3])
;  /*
;  **  - - - - - - - -
;  **   e r a P m p x
;  **  - - - - - - - -
;  **
;  **  Proper motion and parallax.
;  **
;  **  Given:
;  **     rc,dc  double     ICRS RA,Dec at catalog epoch (radians)
;  **     pr     double     RA proper motion (radians/year; Note 1)
;  **     pd     double     Dec proper motion (radians/year)
;  **     px     double     parallax (arcsec)
;  **     rv     double     radial velocity (km/s, +ve if receding)
;  **     pmt    double     proper motion time interval (SSB, Julian years)
;  **     pob    double[3]  SSB to observer vector (au)
;  **
;  **  Returned:
;  **     pco    double[3]  coordinate direction (BCRS unit vector)
;  **
;  **  Notes:
;  **
;  **  1) The proper motion in RA is dRA/dt rather than cos(Dec)*dRA/dt.
;  **
;  **  2) The proper motion time interval is for when the starlight
;  **     reaches the solar system barycenter.
;  **
;  **  3) To avoid the need for iteration, the Roemer effect (i.e. the
;  **     small annual modulation of the proper motion coming from the
;  **     changing light time) is applied approximately, using the
;  **     direction of the star at the catalog epoch.
;  **
;  **  References:
;  **
;  **     1984 Astronomical Almanac, pp B39-B41.
;  **
;  **     Urban, S. & Seidelmann, P. K. (eds), Explanatory Supplement to
;  **     the Astronomical Almanac, 3rd ed., University Science Books
;  **     (2013), Section 7.2.
;  **
;  **  Called:
;  **     eraPdp       scalar product of two p-vectors
;  **     eraPn        decompose p-vector into modulus and direction
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
;/* Seconds per day. */
;ERFA_DAYSEC= 86400.0d
;;/* Astronomical unit (m) */
;ERFA_DAU= 149597870d3
;;/* Light time for 1 au (s) */
;ERFA_AULT=499.004782d
;;/* Days per Julian year */
;ERFA_DJY=365.25d
;;/* Days per Julian millennium */
;ERFA_DJM=365250.0d
;;/* Arcseconds to radians */
;ERFA_DAS2R= 4.848136811095359935899141d-6
  @erfam
;  /* Km/s to au/year */
VF = ERFA_DAYSEC*ERFA_DJM/ERFA_DAU;
  
;  /* Light time for 1 au, Julian years */
 AULTY = ERFA_AULT/ERFA_DAYSEC/ERFA_DJY;
  
i=0;
sr=0d & cr=0d & sd=0d & cd=0d & x=0d & y=0d & z=0d & p=dblarr(3) & dt=0d & pxr=0d & w=0d & pdz=0d & pm=dblarr(3);
  
;  /* Spherical coordinates to unit vector (and useful functions). */
  sr = sin(rc);
  cr = cos(rc);
  sd = sin(dc);
  cd = cos(dc);
  
  x = cr*cd;
  y = sr*cd;
  z = sd
  p[0] = x 
  p[1] = y 
  p[2] = z 
  
;  /* Proper motion time interval (y) including Roemer effect. */
  dt = pmt + eraPdp(p,pob)*AULTY;ok
  
;  /* Space motion (radians per year). */
  pxr = px * ERFA_DAS2R;
  w = VF * rv * pxr;
  pdz = pd * z;
  pm[0] = - pr*y - pdz*cr + w*x;
  pm[1] =   pr*x - pdz*sr + w*y;
  pm[2] =   pd*cd + w*z;
  
;  /* Coordinate direction of star (unit vector, BCRS). */
  for i = 0,2 do begin 
  p[i] += dt*pm[i] - pxr*pob[i];
endfor
eraPn,p, w, pco;ok

;/* Finished. */


;/*----------------------------------------------------------------------




end