pro eraPN,p,r,u

;  /*
;  **  - - - - - -
;  **   e r a P n
;  **  - - - - - -
;  **
;  **  Convert a p-vector into modulus and unit vector.
;  **
;  **  Given:
;  **     p        double[3]      p-vector
;  **
;  **  Returned:
;  **     r        double         modulus
;  **     u        double[3]      unit vector
;  **
;  **  Notes:
;  **
;  **  1) If p is null, the result is null.  Otherwise the result is a unit
;  **     vector.
;  **
;  **  2) It is permissible to re-use the same array for any of the
;  **     arguments.
;  **
;  **  Called:
;  **     eraPm        modulus of p-vector
;  **     eraZp        zero p-vector
;  **     eraSxp       multiply p-vector by scalar
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  w=0d
  
;  /* Obtain the modulus and test for zero. */
  w = eraPm(p);ok
if (w eq 0.0d) then begin
  
;  /* Null vector. */
  eraZp,u;ok
  
  endif else begin

;/* Unit vector. */
  eraSxp,1.0d/w, p, u;ok
endelse

;/* Return the modulus. */
r = w;


;/*----------------------------------------------------------------------




end