pro eraPpsp,a,s,b,apsb

;  void eraPpsp(double a[3], double s, double b[3], double apsb[3])
;  /*
;  **  - - - - - - - -
;  **   e r a P p s p
;  **  - - - - - - - -
;  **
;  **  P-vector plus scaled p-vector.
;  **
;  **  Given:
;  **     a      double[3]     first p-vector
;  **     s      double        scalar (multiplier for b)
;  **     b      double[3]     second p-vector
;  **
;  **  Returned:
;  **     apsb   double[3]     a + s*b
;  **
;  **  Note:
;  **     It is permissible for any of a, b and apsb to be the same array.
;  **
;  **  Called:
;  **     eraSxp       multiply p-vector by scalar
;  **     eraPpp       p-vector plus p-vector
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  sb=dblarr(3);
  
;  /* s*b. */
  eraSxp,s, b, sb;
  
;  /* a + s*b. */
  eraPpp,a, sb, apsb;
  

  

;/*----------------------------------------------------------------------

end