pro eraPxp,a,b,axb

;void eraPxp(double a[3], double b[3], double axb[3])
;/*
;**  - - - - - - -
;**   e r a P x p
;**  - - - - - - -
;**
;**  p-vector outer (=vector=cross) product.
;**
;**  Given:
;**     a        double[3]      first p-vector
;**     b        double[3]      second p-vector
;**
;**  Returned:
;**     axb      double[3]      a x b
;**
;**  Note:
;**     It is permissible to re-use the same array for any of the
;**     arguments.
;**
;**  Copyright (C) 2013-2015, NumFOCUS Foundation.
;**  Derived, with permission, from the SOFA library.  See notes at end of file.
;*/

xa=0d & ya=0d & za=0d & xb=0d & yb=0d & zb=0d;

xa = a[0];
ya = a[1];
za = a[2];
xb = b[0];
yb = b[1];
zb = b[2];
axb[0] = ya*zb - za*yb;
axb[1] = za*xb - xa*zb;
axb[2] = xa*yb - ya*xb;

;/*----------------------------------------------------------------------


end