pro eraRx,phi,r

;  void eraRx(double phi, double r[3][3])
;  /*
;  **  - - - - - -
;  **   e r a R x
;  **  - - - - - -
;  **
;  **  Rotate an r-matrix about the x-axis.
;  **
;  **  Given:
;  **     phi    double          angle (radians)
;  **
;  **  Given and returned:
;  **     r      double[3][3]    r-matrix, rotated
;  **
;  **  Notes:
;  **
;  **  1) Calling this function with positive phi incorporates in the
;  **     supplied r-matrix r an additional rotation, about the x-axis,
;  **     anticlockwise as seen looking towards the origin from positive x.
;  **
;  **  2) The additional rotation can be represented by this matrix:
;  **
;  **         (  1        0            0      )
;  **         (                               )
;  **         (  0   + cos(phi)   + sin(phi)  )
;  **         (                               )
;  **         (  0   - sin(phi)   + cos(phi)  )
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  s=0d & c=0d & a10=0d & a11=0d & a12=0d & a20=0d & a21=0d & a22=0d;
  
  s = sin(phi);
  c = cos(phi);
  
  a10 =   c*r[1,0] + s*r[2,0];
  a11 =   c*r[1,1] + s*r[2,1];
  a12 =   c*r[1,2] + s*r[2,2];
  a20 = - s*r[1,0] + c*r[2,0];
  a21 = - s*r[1,1] + c*r[2,1];
  a22 = - s*r[1,2] + c*r[2,2];
  
  r[1,0] = a10;
  r[1,1] = a11;
  r[1,2] = a12;
  r[2,0] = a20;
  r[2,1] = a21;
  r[2,2] = a22;
  

;/*----------------------------------------------------------------------



end