pro eraRxp,r,p,rp

;  void eraRxp(double r[3][3], double p[3], double rp[3])
;  /*
;  **  - - - - - - -
;  **   e r a R x p
;  **  - - - - - - -
;  **
;  **  Multiply a p-vector by an r-matrix.
;  **
;  **  Given:
;  **     r        double[3][3]    r-matrix
;  **     p        double[3]       p-vector
;  **
;  **  Returned:
;  **     rp       double[3]       r * p
;  **
;  **  Note:
;  **     It is permissible for p and rp to be the same array.
;  **
;  **  Called:
;  **     eraCp        copy p-vector
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
 w=0d & wrp=dblarr(3);
  i=0 & j=0;
  
;  /* Matrix r * vector p. */
  for j = 0,2 do begin 
  w = 0.0d;
  for i = 0,2 do begin
  w += r[j,i] * p[i];
endfor
wrp[j] = w;
endfor

;/* Return the result. */
eraCp,wrp, rp;

;rp=r #p

;/*----------------------------------------------------------------------



end