pro eraRxr,a,b,atb

;  void eraRxr(double a[3][3], double b[3][3], double atb[3][3])
;  /*
;  **  - - - - - - -
;  **   e r a R x r
;  **  - - - - - - -
;  **
;  **  Multiply two r-matrices.
;  **
;  **  Given:
;  **     a        double[3][3]    first r-matrix
;  **     b        double[3][3]    second r-matrix
;  **
;  **  Returned:
;  **     atb      double[3][3]    a * b
;  **
;  **  Note:
;  **     It is permissible to re-use the same array for any of the
;  **     arguments.
;  **
;  **  Called:
;  **     eraCr        copy r-matrix
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  i=0 & j=0 & k=0;
  w=0d & wm=dblarr(3,3);
  
  for i = 0,2 do begin; i < 3; i++) {
  for j = 0,2 do begin; j < 3; j++) {
  w = 0.0d;
  for k = 0,2 do begin; k < 3; k++) {
  w +=  a[i,k] * b[k,j];
endfor
wm[i,j] = w;
endfor
endfor
eraCr,wm, atb;




;/*----------------------------------------------------------------------


end