pro eraRy,theta ,r 

;  void eraRy(double theta, double r[3][3])
;  /*
;  **  - - - - - -
;  **   e r a R y
;  **  - - - - - -
;  **
;  **  Rotate an r-matrix about the y-axis.
;  **
;  **  Given:
;  **     theta  double          angle (radians)
;  **
;  **  Given and returned:
;  **     r      double[3][3]    r-matrix, rotated
;  **
;  **  Notes:
;  **
;  **  1) Calling this function with positive theta incorporates in the
;  **     supplied r-matrix r an additional rotation, about the y-axis,
;  **     anticlockwise as seen looking towards the origin from positive y.
;  **
;  **  2) The additional rotation can be represented by this matrix:
;  **
;  **         (  + cos(theta)     0      - sin(theta)  )
;  **         (                                        )
;  **         (       0           1           0        )
;  **         (                                        )
;  **         (  + sin(theta)     0      + cos(theta)  )
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  s=0d & c=0d & a00=0d & a01=0d & a02=0d & a20=0d & a21=0d & a22=0d;
  
  s = sin(theta);
  c = cos(theta);
  
  a00 = c*r[0,0] - s*r[2,0];
  a01 = c*r[0,1] - s*r[2,1];
  a02 = c*r[0,2] - s*r[2,2];
  a20 = s*r[0,0] + c*r[2,0];
  a21 = s*r[0,1] + c*r[2,1];
  a22 = s*r[0,2] + c*r[2,2];
  
  r[0,0] = a00;
  r[0,1] = a01;
  r[0,2] = a02;
  r[2,0] = a20;
  r[2,1] = a21;
  r[2,2] = a22;
  

;/*----------------------------------------------------------------------




end