pro eraRz,psi, r

;  void eraRz(double psi, double r[3][3])
;  /*
;  **  - - - - - -
;  **   e r a R z
;  **  - - - - - -
;  **
;  **  Rotate an r-matrix about the z-axis.
;  **
;  **  Given:
;  **     psi    double          angle (radians)
;  **
;  **  Given and returned:
;  **     r      double[3][3]    r-matrix, rotated
;  **
;  **  Notes:
;  **
;  **  1) Calling this function with positive psi incorporates in the
;  **     supplied r-matrix r an additional rotation, about the z-axis,
;  **     anticlockwise as seen looking towards the origin from positive z.
;  **
;  **  2) The additional rotation can be represented by this matrix:
;  **
;  **         (  + cos(psi)   + sin(psi)     0  )
;  **         (                                 )
;  **         (  - sin(psi)   + cos(psi)     0  )
;  **         (                                 )
;  **         (       0            0         1  )
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  s=0d & c=0d & a00=0d & a01=0d &  a02=0d & a10=0d & a11=0d & a12=0d;
  
  s = sin(psi);
  c = cos(psi);
  
  a00 =   c*r[0,0] + s*r[1,0];
  a01 =   c*r[0,1] + s*r[1,1];
  a02 =   c*r[0,2] + s*r[1,2];
  a10 = - s*r[0,0] + c*r[1,0];
  a11 = - s*r[0,1] + c*r[1,1];
  a12 = - s*r[0,2] + c*r[1,2];
  
  r[0,0] = a00;
  r[0,1] = a01;
  r[0,2] = a02;
  r[1,0] = a10;
  r[1,1] = a11;
  r[1,2] = a12;
  

;/*----------------------------------------------------------------------



end