function eraS06,date1,date2,x,y

;  double eraS06(double date1, double date2, double x, double y)
;  /*
;  **  - - - - - - -
;  **   e r a S 0 6
;  **  - - - - - - -
;  **
;  **  The CIO locator s, positioning the Celestial Intermediate Origin on
;  **  the equator of the Celestial Intermediate Pole, given the CIP's X,Y
;  **  coordinates.  Compatible with IAU 2006/2000A precession-nutation.
;  **
;  **  Given:
;  **     date1,date2   double    TT as a 2-part Julian Date (Note 1)
;  **     x,y           double    CIP coordinates (Note 3)
;  **
;  **  Returned (function value):
;  **                   double    the CIO locator s in radians (Note 2)
;  **
;  **  Notes:
;  **
;  **  1) The TT date date1+date2 is a Julian Date, apportioned in any
;  **     convenient way between the two arguments.  For example,
;  **     JD(TT)=2450123.7 could be expressed in any of these ways,
;  **     among others:
;  **
;  **            date1          date2
;  **
;  **         2450123.7           0.0       (JD method)
;  **         2451545.0       -1421.3       (J2000 method)
;  **         2400000.5       50123.2       (MJD method)
;  **         2450123.5           0.2       (date & time method)
;  **
;  **     The JD method is the most natural and convenient to use in
;  **     cases where the loss of several decimal digits of resolution
;  **     is acceptable.  The J2000 method is best matched to the way
;  **     the argument is handled internally and will deliver the
;  **     optimum resolution.  The MJD method and the date & time methods
;  **     are both good compromises between resolution and convenience.
;  **
;  **  2) The CIO locator s is the difference between the right ascensions
;  **     of the same point in two systems:  the two systems are the GCRS
;  **     and the CIP,CIO, and the point is the ascending node of the
;  **     CIP equator.  The quantity s remains below 0.1 arcsecond
;  **     throughout 1900-2100.
;  **
;  **  3) The series used to compute s is in fact for s+XY/2, where X and Y
;  **     are the x and y components of the CIP unit vector;  this series
;  **     is more compact than a direct series for s would be.  This
;  **     function requires X,Y to be supplied by the caller, who is
;  **     responsible for providing values that are consistent with the
;  **     supplied date.
;  **
;  **  4) The model is consistent with the "P03" precession (Capitaine et
;  **     al. 2003), adopted by IAU 2006 Resolution 1, 2006, and the
;  **     IAU 2000A nutation (with P03 adjustments).
;  **
;  **  Called:
;  **     eraFal03     mean anomaly of the Moon
;  **     eraFalp03    mean anomaly of the Sun
;  **     eraFaf03     mean argument of the latitude of the Moon
;  **     eraFad03     mean elongation of the Moon from the Sun
;  **     eraFaom03    mean longitude of the Moon's ascending node
;  **     eraFave03    mean longitude of Venus
;  **     eraFae03     mean longitude of Earth
;  **     eraFapa03    general accumulated precession in longitude
;  **
;  **  References:
;  **
;  **     Capitaine, N., Wallace, P.T. & Chapront, J., 2003, Astron.
;  **     Astrophys. 432, 355
;  **
;  **     McCarthy, D.D., Petit, G. (eds.) 2004, IERS Conventions (2003),
;  **     IERS Technical Note No. 32, BKG
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  @erfam
;  /* Time since J2000.0, in Julian centuries */
  t=0d;
  
;  /* Miscellaneous */
  i=0 & j=0;
  a=0d & w0=0d & w1=0d & w2=0d & w3=0d & w4=0d & w5=0d;
  
;  /* Fundamental arguments */
  fa=dblarr(8);
  
;  /* Returned value */
  s=0d;
  
;  /* --------------------- */
;  /* The series for s+XY/2 */
;  /* --------------------- */
  
;  typedef struct {
;  int nfa[8];      /* coefficients of l,l',F,D,Om,LVe,LE,pA */
;  double s, c;     /* sine and cosine coefficients */
;} TERM;
term = {nfa:intarr(8), s:0d, c:0d }
;/* Polynomial coefficients */
sp = [ $
 $
;/* 1-6 */ $
94.00d-6, $
3808.65d-6, $
-122.68d-6, $
-72574.11d-6, $
27.98d-6, $
15.62d-6 $
];

;/* Terms of order t^0 */
s0=replicate(term,33)


;/* 1-10 */
s0[0].nfa=[ 0,  0,  0,  0,  1,  0,  0,  0] & s0[0].s= -2640.73d-6 & s0[0].c=   0.39d-6 
s0[1].nfa=[ 0,  0,  0,  0,  2,  0,  0,  0] & s0[1].s=   -63.53d-6 & s0[1].c=   0.02d-6 
s0[2].nfa=[ 0,  0,  2, -2,  3,  0,  0,  0] & s0[2].s=   -11.75d-6 & s0[2].c=  -0.01d-6 
s0[3].nfa=[ 0,  0,  2, -2,  1,  0,  0,  0] & s0[3].s=   -11.21d-6 & s0[3].c=  -0.01d-6 
s0[4].nfa=[ 0,  0,  2, -2,  2,  0,  0,  0] & s0[4].s=     4.57d-6 & s0[4].c=   0.00d-6 
s0[5].nfa=[ 0,  0,  2,  0,  3,  0,  0,  0] & s0[5].s=    -2.02d-6 & s0[5].c=   0.00d-6 
s0[6].nfa=[ 0,  0,  2,  0,  1,  0,  0,  0] & s0[6].s=    -1.98d-6 & s0[6].c=   0.00d-6 
s0[7].nfa=[ 0,  0,  0,  0,  3,  0,  0,  0] & s0[7].s=     1.72d-6 & s0[7].c=   0.00d-6 
s0[8].nfa=[ 0,  1,  0,  0,  1,  0,  0,  0] & s0[8].s=     1.41d-6 & s0[8].c=   0.01d-6 
s0[9].nfa=[ 0,  1,  0,  0, -1,  0,  0,  0] & s0[9].s=     1.26d-6 & s0[9].c=   0.01d-6 

;/* 11-20 */
s0[10].nfa=[ 1,  0,  0,  0, -1,  0,  0,  0] & s0[10].s=     0.63d-6 & s0[10].c=   0.00d-6 
s0[11].nfa=[ 1,  0,  0,  0,  1,  0,  0,  0] & s0[11].s=     0.63d-6 & s0[11].c=   0.00d-6 
s0[12].nfa=[ 0,  1,  2, -2,  3,  0,  0,  0] & s0[12].s=    -0.46d-6 & s0[12].c=   0.00d-6 
s0[13].nfa=[ 0,  1,  2, -2,  1,  0,  0,  0] & s0[13].s=    -0.45d-6 & s0[13].c=   0.00d-6 
s0[14].nfa=[ 0,  0,  4, -4,  4,  0,  0,  0] & s0[14].s=    -0.36d-6 & s0[14].c=   0.00d-6 
s0[15].nfa=[ 0,  0,  1, -1,  1, -8, 12,  0] & s0[15].s=     0.24d-6 & s0[15].c=   0.12d-6 
s0[16].nfa=[ 0,  0,  2,  0,  0,  0,  0,  0] & s0[16].s=    -0.32d-6 & s0[16].c=   0.00d-6 
s0[17].nfa=[ 0,  0,  2,  0,  2,  0,  0,  0] & s0[17].s=    -0.28d-6 & s0[17].c=   0.00d-6 
s0[18].nfa=[ 1,  0,  2,  0,  3,  0,  0,  0] & s0[18].s=    -0.27d-6 & s0[18].c=   0.00d-6 
s0[19].nfa=[ 1,  0,  2,  0,  1,  0,  0,  0] & s0[19].s=    -0.26d-6 & s0[19].c=   0.00d-6 

;/* 21-30 */
s0[20].nfa=[ 0,  0,  2, -2,  0,  0,  0,  0] & s0[20].s=     0.21d-6 & s0[20].c=   0.00d-6 
s0[21].nfa=[ 0,  1, -2,  2, -3,  0,  0,  0] & s0[21].s=    -0.19d-6 & s0[21].c=   0.00d-6 
s0[22].nfa=[ 0,  1, -2,  2, -1,  0,  0,  0] & s0[22].s=    -0.18d-6 & s0[22].c=   0.00d-6 
s0[23].nfa=[ 0,  0,  0,  0,  0,  8,-13, -1] & s0[23].s=     0.10d-6 & s0[23].c=  -0.05d-6 
s0[24].nfa=[ 0,  0,  0,  2,  0,  0,  0,  0] & s0[24].s=    -0.15d-6 & s0[24].c=   0.00d-6 
s0[25].nfa=[ 2,  0, -2,  0, -1,  0,  0,  0] & s0[25].s=     0.14d-6 & s0[25].c=   0.00d-6 
s0[26].nfa=[ 0,  1,  2, -2,  2,  0,  0,  0] & s0[26].s=     0.14d-6 & s0[26].c=   0.00d-6 
s0[27].nfa=[ 1,  0,  0, -2,  1,  0,  0,  0] & s0[27].s=    -0.14d-6 & s0[27].c=   0.00d-6
s0[28].nfa=[ 1,  0,  0, -2, -1,  0,  0,  0] & s0[28].s=    -0.14d-6 & s0[28].c=   0.00d-6 
s0[29].nfa=[ 0,  0,  4, -2,  4,  0,  0,  0] & s0[29].s=    -0.13d-6 & s0[29].c=   0.00d-6 

;/* 31-33 */
s0[30].nfa=[ 0,  0,  2, -2,  4,  0,  0,  0] & s0[30].s=     0.11d-6 & s0[30].c=   0.00d-6 
s0[31].nfa=[ 1,  0, -2,  0, -3,  0,  0,  0] & s0[31].s=    -0.11d-6 & s0[31].c=   0.00d-6 
s0[32].nfa=[ 1,  0, -2,  0, -1,  0,  0,  0] & s0[32].s=    -0.11d-6 & s0[32].c=   0.00d-6
;

;/* Terms of order t^1 */
s1=replicate(term,3)

;/* 1 - 3 */
s1[0].nfa= [0,  0,  0,  0,  2,  0,  0,  0] & s1[0].s=    -0.07d-6 & s1[0].c=   3.57d-6 
s1[1].nfa= [0,  0,  0,  0,  1,  0,  0,  0] & s1[1].s=     1.73d-6 & s1[1].c=  -0.03d-6 
s1[2].nfa= [0,  0,  2, -2,  3,  0,  0,  0] & s1[2].s=     0.00d-6 & s1[2].c=   0.48d-6


;/* Terms of order t^2 */
s2=replicate(term,25)


;/* 1-10 */
s2[0].nfa= [0,  0,  0,  0,  1,  0,  0,  0] & s2[0].s=   743.52d-6 & s2[0].c=  -0.17d-6 
s2[1].nfa= [0,  0,  2, -2,  2,  0,  0,  0] & s2[1].s=    56.91d-6 & s2[1].c=   0.06d-6 
s2[2].nfa= [0,  0,  2,  0,  2,  0,  0,  0] & s2[2].s=     9.84d-6 & s2[2].c=  -0.01d-6 
s2[3].nfa= [0,  0,  0,  0,  2,  0,  0,  0] & s2[3].s=    -8.85d-6 & s2[3].c=   0.01d-6 
s2[4].nfa= [0,  1,  0,  0,  0,  0,  0,  0] & s2[4].s=    -6.38d-6 & s2[4].c=  -0.05d-6 
s2[5].nfa= [1,  0,  0,  0,  0,  0,  0,  0] & s2[5].s=    -3.07d-6 & s2[5].c=   0.00d-6 
s2[6].nfa= [0,  1,  2, -2,  2,  0,  0,  0] & s2[6].s=     2.23d-6 & s2[6].c=   0.00d-6 
s2[7].nfa= [0,  0,  2,  0,  1,  0,  0,  0] & s2[7].s=     1.67d-6 & s2[7].c=   0.00d-6 
s2[8].nfa= [1,  0,  2,  0,  2,  0,  0,  0] & s2[8].s=     1.30d-6 & s2[8].c=   0.00d-6 
s2[9].nfa= [0,  1, -2,  2, -2,  0,  0,  0] & s2[9].s=     0.93d-6 & s2[9].c=   0.00d-6 

;/* 11-20 */
s2[10].nfa= [1,  0,  0, -2,  0,  0,  0,  0] & s2[10].s=     0.68d-6 & s2[10].c=   0.00d-6 
s2[11].nfa= [0,  0,  2, -2,  1,  0,  0,  0] & s2[11].s=    -0.55d-6 & s2[11].c=   0.00d-6 
s2[12].nfa= [1,  0, -2,  0, -2,  0,  0,  0] & s2[12].s=     0.53d-6 & s2[12].c=   0.00d-6 
s2[13].nfa= [0,  0,  0,  2,  0,  0,  0,  0] & s2[13].s=    -0.27d-6 & s2[13].c=   0.00d-6 
s2[14].nfa= [1,  0,  0,  0,  1,  0,  0,  0] & s2[14].s=    -0.27d-6 & s2[14].c=   0.00d-6 
s2[15].nfa= [1,  0, -2, -2, -2,  0,  0,  0] & s2[15].s=    -0.26d-6 & s2[15].c=   0.00d-6 
s2[16].nfa= [1,  0,  0,  0, -1,  0,  0,  0] & s2[16].s=    -0.25d-6 & s2[16].c=   0.00d-6 
s2[17].nfa= [1,  0,  2,  0,  1,  0,  0,  0] & s2[17].s=     0.22d-6 & s2[17].c=   0.00d-6 
s2[18].nfa= [2,  0,  0, -2,  0,  0,  0,  0] & s2[18].s=    -0.21d-6 & s2[18].c=   0.00d-6 
s2[19].nfa= [2,  0, -2,  0, -1,  0,  0,  0] & s2[19].s=     0.20d-6 & s2[19].c=   0.00d-6 

;/* 21-25 */
s2[20].nfa= [0,  0,  2,  2,  2,  0,  0,  0] & s2[20].s=     0.17d-6 & s2[20].c=   0.00d-6
s2[21].nfa= [2,  0,  2,  0,  2,  0,  0,  0] & s2[21].s=     0.13d-6 & s2[21].c=   0.00d-6 
s2[22].nfa= [2,  0,  0,  0,  0,  0,  0,  0] & s2[22].s=    -0.13d-6 & s2[22].c=   0.00d-6 
s2[23].nfa= [1,  0,  2, -2,  2,  0,  0,  0] & s2[23].s=    -0.12d-6 & s2[23].c=   0.00d-6 
s2[24].nfa= [0,  0,  2,  0,  0,  0,  0,  0] & s2[24].s=    -0.11d-6 & s2[24].c=   0.00d-6 


;/* Terms of order t^3 */
s3=replicate(term,4)


;/* 1-4 */
s3[0].nfa= [ 0,  0,  0,  0,  1,  0,  0,  0] & s3[0].s=     0.30d-6 & s3[0].c= -23.42d-6 
s3[1].nfa= [ 0,  0,  2, -2,  2,  0,  0,  0] & s3[1].s=    -0.03d-6 & s3[1].c=  -1.46d-6 
s3[2].nfa= [ 0,  0,  2,  0,  2,  0,  0,  0] & s3[2].s=    -0.01d-6 & s3[2].c=  -0.25d-6 
s3[3].nfa= [ 0,  0,  0,  0,  2,  0,  0,  0] & s3[3].s=     0.00d-6 & s3[3].c=   0.23d-6 
;

;/* Terms of order t^4 */
;static const TERM s4[] = {
s4=replicate(term,1)
;/* 1-1 */
s4[0].nfa= [ 0,  0,  0,  0,  1,  0,  0,  0] & s4[0].s=    -0.26d-6 & s4[0].c=  -0.01d-6 
;

;/* Number of terms in the series */
NS0 =n_elements(s0.s);
NS1 = n_elements(s1.s)
NS2 = n_elements(s2.s)
NS3 = n_elements(s3.s);
NS4 = n_elements(s4.s);

;/*--------------------------------------------------------------------*/

;/* Interval between fundamental epoch J2000.0 and current date (JC). */
t = ((date1 - ERFA_DJ00) + date2) / ERFA_DJC;

;/* Fundamental Arguments (from IERS Conventions 2003) */

;/* Mean anomaly of the Moon. */
fa[0] = eraFal03(t);

;/* Mean anomaly of the Sun. */
fa[1] = eraFalp03(t);

;/* Mean longitude of the Moon minus that of the ascending node. */
fa[2] = eraFaf03(t);

;/* Mean elongation of the Moon from the Sun. */
fa[3] = eraFad03(t);

;/* Mean longitude of the ascending node of the Moon. */
fa[4] = eraFaom03(t);

;/* Mean longitude of Venus. */
fa[5] = eraFave03(t);

;/* Mean longitude of Earth. */
fa[6] = eraFae03(t);

;/* General precession in longitude. */
fa[7] = eraFapa03(t);

;/* Evaluate s. */
w0 = sp[0];
w1 = sp[1];
w2 = sp[2];
w3 = sp[3];
w4 = sp[4];
w5 = sp[5];

for i = NS0-1,0,-1 do begin; i >= 0; i--) {
 a = 0.0d;
  for j = 0,7 do begin; j < 8; j++) {
   a += s0[i].nfa[j] * fa[j];
  endfor
 w0 += s0[i].s * sin(a) + s0[i].c * cos(a);
endfor

for i = NS1-1,0,-1 do begin; i >= 0; i--) {
  a = 0.0d;
  for j = 0,7 do begin; j < 8; j++) {
  a += s1[i].nfa[j] * fa[j];
  endfor
  w1 += s1[i].s * sin(a) + s1[i].c * cos(a);
endfor

for i = NS2-1,0,-1 do begin; i >= 0; i--) {
  a = 0.0d;
  for j = 0,7 do begin; j < 8; j++) {
   a += s2[i].nfa[j] * fa[j];
  endfor
  w2 += s2[i].s * sin(a) + s2[i].c * cos(a);
endfor

for i = NS3-1,0,-1 do begin; i >= 0; i--) {
  a = 0.0d;
  for j = 0,7 do begin; j < 8; j++) {
    a += s3[i].nfa[j] * fa[j];
  endfor   
   w3 += s3[i].s * sin(a) + s3[i].c * cos(a);
endfor

for i = NS4-1,0,-1 do begin; i >= 0; i--) {
  a = 0.0d;
  for j = 0,7 do begin; j < 8; j++) {
    a += s4[i].nfa[j] * fa[j];
  endfor
  w4 += s4[i].s * sin(a) + s4[i].c * cos(a);
endfor

s = (w0 +  $ 
(w1 +  $
(w2 +  $
(w3 +  $
(w4 +  $
w5 * t) * t) * t) * t) * t) * ERFA_DAS2R - x*y/2.0d;

return, s;


end