function eraSp00,date1,date2
; Oliver Pfuhl 2017Mar01: ported erfa C-routines to IDL
;  double eraSp00(double date1, double date2)
;  /*
;  **  - - - - - - - -
;  **   e r a S p 0 0
;  **  - - - - - - - -
;  **
;  **  The TIO locator s', positioning the Terrestrial Intermediate Origin
;  **  on the equator of the Celestial Intermediate Pole.
;  **
;  **  Given:
;  **     date1,date2  double    TT as a 2-part Julian Date (Note 1)
;  **
;  **  Returned (function value):
;  **                  double    the TIO locator s' in radians (Note 2)
;  **
;  **  Notes:
;  **
;  **  1) The TT date date1+date2 is a Julian Date, apportioned in any
;  **     convenient way between the two arguments.  For example,
;  **     JD(TT)=2450123.7 could be expressed in any of these ways,
;  **     among others:
;  **
;  **            date1          date2
;  **
;  **         2450123.7           0.0       (JD method)
;  **         2451545.0       -1421.3       (J2000 method)
;  **         2400000.5       50123.2       (MJD method)
;  **         2450123.5           0.2       (date & time method)
;  **
;  **     The JD method is the most natural and convenient to use in
;  **     cases where the loss of several decimal digits of resolution
;  **     is acceptable.  The J2000 method is best matched to the way
;  **     the argument is handled internally and will deliver the
;  **     optimum resolution.  The MJD method and the date & time methods
;  **     are both good compromises between resolution and convenience.
;  **
;  **  2) The TIO locator s' is obtained from polar motion observations by
;  **     numerical integration, and so is in essence unpredictable.
;  **     However, it is dominated by a secular drift of about
;  **     47 microarcseconds per century, which is the approximation
;  **     evaluated by the present function.
;  **
;  **  Reference:
;  **
;  **     McCarthy, D. D., Petit, G. (eds.), IERS Conventions (2003),
;  **     IERS Technical Note No. 32, BKG (2004)
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
 t=0d & sp=0d;
  
;  /* Reference epoch (J2000.0), Julian Date */
ERFA_DJ00=2451545.0d

;/* Days per Julian century */
ERFA_DJC=36525.0d
;/* Arcseconds to radians */
ERFA_DAS2R=1d * 4.848136811095359935899141e-6

  
;  /* Interval between fundamental epoch J2000.0 and current date (JC). */
  t = ((date1 - ERFA_DJ00) + date2) / ERFA_DJC;
  
;  /* Approximate s'. */
  sp = -1d * 47e-6 * t * ERFA_DAS2R;
  
  return, sp;
  

;/*----------------------------------------------------------------------


end