function eraTaitt,tai1,tai2,tt1,tt2

;  int eraTaitt(double tai1, double tai2, double *tt1, double *tt2)
;  /*
;  **  - - - - - - - - -
;  **   e r a T a i t t
;  **  - - - - - - - - -
;  **
;  **  Time scale transformation:  International Atomic Time, TAI, to
;  **  Terrestrial Time, TT.
;  **
;  **  Given:
;  **     tai1,tai2  double    TAI as a 2-part Julian Date
;  **
;  **  Returned:
;  **     tt1,tt2    double    TT as a 2-part Julian Date
;  **
;  **  Returned (function value):
;  **                int       status:  0 = OK
;  **
;  **  Note:
;  **
;  **     tai1+tai2 is Julian Date, apportioned in any convenient way
;  **     between the two arguments, for example where tai1 is the Julian
;  **     Day Number and tai2 is the fraction of a day.  The returned
;  **     tt1,tt2 follow suit.
;  **
;  **  References:
;  **
;  **     McCarthy, D. D., Petit, G. (eds.), IERS Conventions (2003),
;  **     IERS Technical Note No. 32, BKG (2004)
;  **
;  **     Explanatory Supplement to the Astronomical Almanac,
;  **     P. Kenneth Seidelmann (ed), University Science Books (1992)
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
 ; /* TT minus TAI (s) */
;ERFA_TTMTAI=32.184d
 ; /* Seconds per day. */
;ERFA_DAYSEC=86400.0d
@erfam
;  /* TT minus TAI (days). */
 dtat = ERFA_TTMTAI/ERFA_DAYSEC;
  
;  /* Result, safeguarding precision. */
  if ( tai1 gt tai2 ) then begin
  tt1 = tai1;
  tt2 = tai2 + dtat;
endif else begin
tt1 = tai1 + dtat;
tt2 = tai2;
endelse

;/* Status (always OK). */
return, 0;


;/*----------------------------------------------------------------------



end