function eraTaiut1,tai1,tai2,dta,ut11,ut12

;  int eraTaiut1(double tai1, double tai2, double dta,
;  double *ut11, double *ut12)
;  /*
;  **  - - - - - - - - - -
;  **   e r a T a i u t 1
;  **  - - - - - - - - - -
;  **
;  **  Time scale transformation:  International Atomic Time, TAI, to
;  **  Universal Time, UT1.
;  **
;  **  Given:
;  **     tai1,tai2  double    TAI as a 2-part Julian Date
;  **     dta        double    UT1-TAI in seconds
;  **
;  **  Returned:
;  **     ut11,ut12  double    UT1 as a 2-part Julian Date
;  **
;  **  Returned (function value):
;  **                int       status:  0 = OK
;  **
;  **  Notes:
;  **
;  **  1) tai1+tai2 is Julian Date, apportioned in any convenient way
;  **     between the two arguments, for example where tai1 is the Julian
;  **     Day Number and tai2 is the fraction of a day.  The returned
;  **     UT11,UT12 follow suit.
;  **
;  **  2) The argument dta, i.e. UT1-TAI, is an observed quantity, and is
;  **     available from IERS tabulations.
;  **
;  **  Reference:
;  **
;  **     Explanatory Supplement to the Astronomical Almanac,
;  **     P. Kenneth Seidelmann (ed), University Science Books (1992)
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  dtad=0d;
  
 ; /* Seconds per day. */
ERFA_DAYSEC=86400.0d
  
;  /* Result, safeguarding precision. */
  dtad = dta / ERFA_DAYSEC;
  if ( tai1 gt tai2 ) then begin
  ut11 = tai1;
  ut12 = tai2 + dtad;
endif else begin
ut11 = tai1 + dtad;
ut12 = tai2;
endelse

;/* Status (always OK). */
return, 0;


;/*----------------------------------------------------------------------

end